set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8428962';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '4300200',
      2,
      NULL,
      3,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1,
      0.376035,
      '10-29-1999',
      NULL,
      0.208299,
      345,
      152.618763,
      NULL,
      ' 2-26-1997',
      '11- 8-1987',
      ' 0- 3-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.639495,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      18.735455,
      NULL,
      7,
      23,
      4.842156,
      2,
      7.937060,
      1.088539,
      NULL,
      NULL,
      0.026591,
      1,
      0,
      1,
      0.166359,
      NULL,
      2,
      0,
      0.770949,
      3.669029,
      NULL,
      1,
      NULL,
      NULL,
      3.521404,
      1.029734,
      1,
      1,
      0,
      1,
      1,
      0,
      0.005010,
      1.179616,
      8,
      1,
      3.749788,
      1,
      1,
      0.201601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.381733,
      0.220803,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.954121,
      1.274271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      8,
      0,
      0,
      1,
      3.681065,
      1,
      1.602645,
      3.265469,
      NULL,
      NULL,
      1,
      NULL,
      1.803163,
      0.570168,
      0,
      1.141552,
      NULL,
      NULL,
      0.216921,
      4.247779,
      3.517338,
      1,
      1.648099,
      0.101854,
      6.705133,
      1,
      NULL,
      0,
      5,
      9,
      0.987435,
      NULL,
      1,
      NULL,
      7.426290,
      NULL,
      NULL,
      8,
      6,
      1,
      0,
      4,
      7,
      0,
      0.567764,
      1.687207,
      NULL,
      810.131263,
      NULL,
      370.167271,
      2.187055,
      3.597526,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993149,
      NULL,
      0.152361,
      0,
      1,
      NULL,
      0.335735,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      0.497626,
      3,
      0.675393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.011439,
      NULL,
      3.377910,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352138,
      2,
      0.697763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721035,
      0.091288,
      1,
      2.877048,
      NULL,
      1,
      1.576816,
      2.435866,
      93,
      2.868278,
      2.783503,
      79,
      NULL,
      18,
      3,
      0.164711,
      0,
      4,
      3.503363,
      1,
      5.896723,
      NULL,
      0.779010,
      3.515836,
      1,
      1.226492,
      2,
      2,
      1,
      2.129646,
      0,
      1,
      0,
      NULL,
      NULL,
      1.897973,
      1.148274,
      1.809530,
      0.861100,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.668161,
      0.349939,
      5,
      3,
      0.658393,
      2,
      2,
      NULL,
      NULL,
      26.413797,
      2,
      0.172766,
      NULL,
      NULL,
      36,
      84.118045,
      3.723663,
      1,
      3,
      '22424',
      '34220',
      '',
      1.814277,
      '',
      '',
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      11.516451,
      45.308868,
      36,
      2.658017,
      14.447376,
      12,
      NULL,
      NULL,
      NULL,
      0.691895,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.553562,
      0.666424,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.139714,
      2.271999,
      0.472958,
      NULL,
      NULL,
      1,
      0.654200,
      0.035979,
      1.508613,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.843980,
      NULL,
      NULL,
      7,
      3.937092,
      6.291829,
      0,
      0.837706,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0.565150,
      0,
      1,
      1.020763,
      0,
      NULL,
      0.880221,
      0,
      1.036414,
      2,
      1.196764,
      0.920334,
      0.284640,
      NULL,
      0,
      1.661343,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.084917,
      NULL,
      0.777752,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.428923,
      NULL,
      NULL,
      NULL,
      3.752734,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      1,
      3,
      1.968508,
      NULL,
      NULL,
      6.605886,
      4.367126,
      4,
      0.053862,
      NULL,
      NULL,
      0.161652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193271,
      NULL,
      NULL,
      1.737500,
      NULL,
      NULL,
      0.954011,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      0.470075,
      0,
      1.321747,
      NULL,
      3.507006,
      1,
      4,
      NULL,
      NULL,
      3.123147,
      NULL,
      3,
      0.754511,
      0.272468,
      0.379805,
      1.644897,
      3.657044,
      0,
      3,
      NULL,
      5.710332,
      7,
      NULL,
      NULL,
      NULL,
      1,
      3.960046,
      1,
      NULL,
      NULL,
      3.026164,
      0.746133,
      0,
      2.767926,
      0.502121,
      8,
      NULL,
      NULL,
      NULL,
      1.782508,
      1.583439,
      2,
      5.964631,
      0.550085,
      0,
      NULL,
      NULL,
      1.076071,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965407,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.642474,
      NULL,
      NULL,
      1.435631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.263940,
      NULL,
      NULL,
      0.574374,
      0,
      NULL,
      NULL,
      0.336538,
      NULL,
      1.782535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938719,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.732951,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.824886,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.254677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.382051,
      NULL,
      NULL,
      NULL,
      1,
      2.142566,
      3.853312,
      3,
      NULL,
      111.651840,
      63,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      8.633499,
      9.269302,
      1.306328,
      NULL,
      NULL,
      0,
      NULL,
      1.089491,
      218,
      NULL,
      1.566323,
      0.307753,
      NULL,
      0,
      0.371911,
      0.187959,
      0.328998,
      0.096625,
      NULL,
      1.388743,
      0.057984,
      1,
      0.944413,
      0,
      1.762691,
      0.349605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053753,
      0.426443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.890515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609261,
      1.830826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.555753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429614,
      1.132594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.684050,
      NULL,
      2.232873,
      NULL,
      37,
      NULL,
      2.413081,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.761466,
      NULL,
      21,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      0,
      1.062160,
      3,
      2.648914,
      1.317904,
      NULL,
      NULL,
      6.749470,
      2,
      3,
      NULL,
      1,
      0.323162,
      NULL,
      0,
      1.681073,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.628917,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573990,
      NULL,
      0.550133,
      NULL,
      0.060683,
      NULL,
      3,
      9,
      9,
      NULL,
      NULL,
      1,
      54,
      NULL,
      0,
      NULL,
      1,
      '43230',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '42211',
      '',
      '');
commit;
end;
/


