set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9639067';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      30,
      4,
      NULL,
      NULL,
      1,
      2,
      2,
      '3144',
      3,
      NULL,
      NULL,
      NULL,
      '11- 1-1986',
      NULL,
      4.321126,
      NULL,
      3,
      NULL,
      '10-23-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 7-20-1977',
      ' 9- 4-1983',
      2,
      3.869816,
      0.967768,
      1.042408,
      1.433799,
      3,
      4,
      1.903706,
      NULL,
      NULL,
      NULL,
      8.183150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.350497,
      5,
      0.000257,
      11,
      NULL,
      NULL,
      0,
      NULL,
      6.697149,
      NULL,
      1,
      7,
      1,
      9,
      1.510474,
      5,
      2.174816,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.462726,
      1.449057,
      3.336226,
      NULL,
      NULL,
      3.019980,
      0.417463,
      2,
      NULL,
      2,
      2.624979,
      2.273934,
      3,
      0.029683,
      NULL,
      2.363085,
      1,
      0.550936,
      2,
      6.652571,
      NULL,
      2.423151,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.341035,
      NULL,
      0.701414,
      NULL,
      2.182545,
      NULL,
      0,
      0,
      0.945362,
      1,
      NULL,
      0,
      0,
      NULL,
      0.091805,
      0,
      1,
      1.757094,
      2.564116,
      NULL,
      0.746919,
      6.229952,
      NULL,
      0.648475,
      NULL,
      0.760197,
      1.498960,
      9,
      2.941136,
      NULL,
      0.249869,
      3.368796,
      1,
      6,
      0,
      2.295478,
      11,
      7,
      8,
      2.352218,
      0.331964,
      NULL,
      NULL,
      9.549319,
      5.597544,
      NULL,
      6.501781,
      2.574954,
      ' 2-12-1995',
      3.634908,
      ' 5-28-1979',
      6.060917,
      NULL,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030455,
      0,
      3.093810,
      1,
      1,
      3.221142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.832238,
      2,
      0.698361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977926,
      2,
      2.977369,
      0,
      0,
      1,
      3.719386,
      1,
      NULL,
      0.638929,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.722190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.899536,
      0.949230,
      0.639098,
      0.900782,
      NULL,
      0,
      0.784645,
      26,
      1.384151,
      0.903743,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085611,
      NULL,
      0.946636,
      2.002893,
      0,
      1.912408,
      4,
      3.899205,
      4.811646,
      2,
      1.353456,
      2.249031,
      5,
      NULL,
      NULL,
      1.773802,
      NULL,
      NULL,
      0.804942,
      NULL,
      NULL,
      0.921123,
      0,
      0.378915,
      NULL,
      0,
      1.589434,
      0,
      0,
      2.667296,
      1,
      1.434689,
      5,
      7,
      4,
      8.516087,
      1,
      4,
      2.999732,
      1.425336,
      0.274499,
      2.565510,
      NULL,
      37.493678,
      0.114566,
      NULL,
      NULL,
      NULL,
      19,
      51,
      3,
      3.147280,
      4.586537,
      NULL,
      '24421',
      '',
      NULL,
      NULL,
      '',
      '',
      0.414581,
      '',
      NULL,
      NULL,
      0,
      2,
      201,
      1,
      1,
      21,
      NULL,
      3,
      3.473205,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.400189,
      0.258511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300178,
      NULL,
      NULL,
      0,
      1.880312,
      0,
      1.283401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.711395,
      NULL,
      0,
      1.207602,
      1.748757,
      NULL,
      NULL,
      NULL,
      1.997639,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.601879,
      NULL,
      1.945048,
      NULL,
      NULL,
      1.583912,
      0.247457,
      0.785693,
      0,
      3,
      1.899876,
      NULL,
      3.442654,
      0.461063,
      NULL,
      3,
      1.388676,
      1,
      NULL,
      0.172996,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363306,
      NULL,
      NULL,
      1.968263,
      NULL,
      NULL,
      8,
      3,
      NULL,
      0.164550,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.157807,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.022250,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655221,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.216149,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.575605,
      NULL,
      NULL,
      2,
      3.454473,
      0.462032,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.597905,
      1.992215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.563071,
      0.694008,
      1.143692,
      0,
      NULL,
      NULL,
      5,
      3,
      0.771387,
      NULL,
      NULL,
      NULL,
      0.033243,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.300954,
      NULL,
      NULL,
      NULL,
      NULL,
      3.583292,
      1.525914,
      1.041307,
      3,
      2,
      2.630991,
      5.006000,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.387663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.231486,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.481752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      3.060895,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.903532,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.343278,
      0.974513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416915,
      0.897563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.606431,
      NULL,
      NULL,
      NULL,
      0.722831,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.034967,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.371288,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.650386,
      115,
      6379,
      3,
      2,
      547.696792,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.821592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      24,
      NULL,
      0.433837,
      NULL,
      1,
      1,
      NULL,
      0,
      0.332166,
      NULL,
      0.012257,
      2,
      1,
      1.189339,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.392132,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      108,
      NULL,
      2.892757,
      NULL,
      42.305754,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.745011,
      NULL,
      0,
      NULL,
      2.132443,
      NULL,
      1.560820,
      NULL,
      0,
      NULL,
      2.637947,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194644,
      NULL,
      0.300386,
      NULL,
      1.199271,
      1,
      NULL,
      3,
      NULL,
      0.637574,
      NULL,
      0.498164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899235,
      NULL,
      0.638962,
      NULL,
      1,
      1.321922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.080410,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.927204,
      NULL,
      0.721123,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125027,
      0.252142,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.298731,
      NULL,
      1,
      0.641954,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.063356,
      NULL,
      1.176295,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.035557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.397952,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.012811,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.066969,
      4,
      NULL,
      14.562265,
      2.480975,
      NULL,
      0,
      3.213284,
      6,
      1.468079,
      3,
      3,
      NULL,
      0.319580,
      0.673274,
      0,
      1.787780,
      1.363450,
      1,
      0.811246,
      0.979980,
      1.966304,
      1.155597,
      1,
      0,
      2.933469,
      0.363923,
      0.481429,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      1.981106,
      0,
      NULL,
      0.903234,
      1.872925,
      NULL,
      NULL,
      NULL,
      1.271255,
      1,
      0,
      1.291931,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606290,
      1.237070,
      0,
      0,
      0,
      0.373979,
      5.461803,
      NULL,
      NULL,
      0.753570,
      NULL,
      NULL,
      75,
      124.727851,
      3,
      1,
      2.836830,
      '43413',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.226261,
      '',
      '',
      '');
commit;
end;
/


