set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4122011',
      1,
      1,
      3,
      2,
      '2430',
      2.108931,
      0,
      NULL,
      NULL,
      ' 7-15-1995',
      NULL,
      NULL,
      5.578633,
      0,
      NULL,
      ' 9-10-1991',
      40,
      1,
      293,
      NULL,
      0.080079,
      ' 1-15-1992',
      ' 1-27-1993',
      ' 4-22-1994',
      1,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      36.487152,
      1.663340,
      17,
      NULL,
      22,
      7.010641,
      3,
      17,
      2.792988,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.987934,
      1.415927,
      2.739343,
      8,
      NULL,
      NULL,
      5.837594,
      NULL,
      4.682913,
      NULL,
      NULL,
      4.914985,
      1,
      NULL,
      5,
      5.078677,
      0,
      3.267603,
      NULL,
      0,
      0.075700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.369964,
      4.866497,
      NULL,
      0.900024,
      NULL,
      0,
      0.501931,
      1.412256,
      0,
      1.215850,
      NULL,
      3,
      0,
      3.350799,
      NULL,
      0,
      3,
      3.059298,
      1.241372,
      3,
      NULL,
      0.845775,
      0,
      0.965685,
      5.391022,
      0,
      NULL,
      NULL,
      NULL,
      1.661231,
      NULL,
      NULL,
      3,
      NULL,
      4.083058,
      5.678649,
      NULL,
      7,
      4,
      0.681249,
      3.264859,
      5.700989,
      3.317339,
      2.188740,
      1,
      0.082365,
      0.209785,
      NULL,
      NULL,
      NULL,
      0.343731,
      1.754912,
      3,
      0,
      2.332808,
      3.854451,
      3.857327,
      1.488257,
      4.691034,
      3.061123,
      3,
      4.430130,
      1.460091,
      NULL,
      4.872949,
      NULL,
      1,
      NULL,
      2.405576,
      5,
      3.940598,
      7,
      2,
      0,
      7.769194,
      5.670911,
      NULL,
      NULL,
      1,
      0,
      ' 6-14-1988',
      461,
      ' 4- 6-1999',
      NULL,
      NULL,
      NULL,
      0.256841,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.409999,
      2,
      1.153087,
      0.763848,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.442190,
      7,
      7.405601,
      0,
      NULL,
      NULL,
      NULL,
      0.997830,
      0.716059,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.920820,
      NULL,
      0,
      1.351708,
      NULL,
      49.483039,
      3.671076,
      0.290861,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685985,
      2.495975,
      3,
      2,
      0.152805,
      1.955426,
      0,
      0.983226,
      2.743622,
      0.489316,
      2,
      2,
      NULL,
      NULL,
      2.048259,
      4,
      1.325701,
      0.337112,
      2.647843,
      0.130869,
      1.617250,
      1,
      1,
      1,
      1,
      1.906382,
      1,
      0.850390,
      1.516022,
      NULL,
      NULL,
      3.012468,
      NULL,
      1.064561,
      8,
      6.970816,
      NULL,
      NULL,
      2.895974,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      0.470868,
      NULL,
      5,
      41.652491,
      50.999837,
      2,
      1,
      NULL,
      '33010',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.792752,
      22.749021,
      168.145819,
      20,
      0.301807,
      49.672603,
      2,
      0.032713,
      0.635852,
      0.475172,
      2.110459,
      1.877884,
      3.611367,
      0,
      1,
      3,
      3.851092,
      1.122114,
      1,
      1,
      NULL,
      3,
      0.341001,
      NULL,
      1.209265,
      2,
      1.800267,
      NULL,
      3.904781,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.172329,
      0,
      NULL,
      2.264439,
      1.925344,
      3,
      3.486778,
      NULL,
      0,
      3.612206,
      1.744572,
      8,
      NULL,
      6,
      1.223276,
      0,
      NULL,
      NULL,
      NULL,
      0.544427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.583320,
      2,
      NULL,
      0,
      2,
      0,
      3.705042,
      1,
      2.678769,
      3,
      1.551290,
      1,
      0.525051,
      2.571775,
      NULL,
      0,
      1.123163,
      NULL,
      NULL,
      2,
      2.904967,
      3.193629,
      0,
      1,
      0,
      0.396693,
      2,
      2,
      0,
      3.712145,
      2,
      9.610780,
      4.437855,
      NULL,
      0.782370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.088289,
      NULL,
      3.534753,
      3,
      3.150126,
      3.819315,
      0.451596,
      NULL,
      2.425243,
      1,
      NULL,
      0.062964,
      3.413676,
      5.845051,
      NULL,
      NULL,
      1.588945,
      2.396683,
      NULL,
      0,
      NULL,
      5,
      10,
      9,
      1.966010,
      NULL,
      NULL,
      0.137855,
      NULL,
      NULL,
      1.977889,
      NULL,
      NULL,
      1.665830,
      NULL,
      NULL,
      0.380170,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2.017000,
      1,
      NULL,
      NULL,
      2.190146,
      0.587885,
      NULL,
      5,
      5.631703,
      3,
      0,
      NULL,
      NULL,
      2.380521,
      1.741502,
      2,
      NULL,
      NULL,
      NULL,
      0.420847,
      NULL,
      NULL,
      2.551602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.989222,
      NULL,
      0,
      1.275343,
      NULL,
      NULL,
      0.831878,
      6.603311,
      2.797634,
      2.973050,
      NULL,
      0.357941,
      NULL,
      4,
      1.831835,
      1,
      1.994044,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.722108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599976,
      NULL,
      NULL,
      3.066416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.633392,
      1.865644,
      0.254648,
      0,
      0,
      NULL,
      NULL,
      1.224651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305212,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.517342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819429,
      4,
      2,
      1.773512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.786818,
      NULL,
      NULL,
      1.370116,
      NULL,
      NULL,
      0,
      NULL,
      0,
      722,
      0.895521,
      0.180053,
      2.887259,
      NULL,
      NULL,
      NULL,
      0,
      0.832489,
      3.906249,
      0,
      0.800323,
      1.930923,
      0.354242,
      0.376839,
      0.076281,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.973227,
      1.708894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504401,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086781,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951129,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.149058,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.202270,
      NULL,
      0.458923,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.526564,
      3,
      5.897726,
      1,
      NULL,
      1.340505,
      1.234026,
      9.678822,
      NULL,
      NULL,
      1.274895,
      3.396842,
      NULL,
      NULL,
      3.509226,
      1,
      NULL,
      2.952431,
      2.284012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.614263,
      NULL,
      1.647449,
      NULL,
      NULL,
      0.665829,
      2.038996,
      NULL,
      3.963666,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.291274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.549490,
      NULL,
      0.445531,
      NULL,
      4.286871,
      4,
      6,
      3,
      0.719212,
      3.872457,
      36.096482,
      53.799789,
      3,
      0,
      0.512618,
      '22144',
      '',
      '',
      1.192376,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


