set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      3,
      2.735403,
      NULL,
      2.249834,
      3,
      NULL,
      '341',
      NULL,
      9,
      7.591220,
      '2001004',
      1.075176,
      0,
      1,
      NULL,
      '2440',
      1,
      0.914086,
      NULL,
      NULL,
      '10- 6-1979',
      127.365702,
      160.668690,
      NULL,
      1,
      0,
      ' 3-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1.135883,
      ' 7-16-1994',
      ' 5-23-1996',
      NULL,
      3,
      0.774068,
      2,
      3.772822,
      1,
      3.367302,
      2,
      1,
      NULL,
      NULL,
      5,
      3.090078,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846777,
      3.651074,
      5,
      0,
      3.706095,
      0.972786,
      1,
      NULL,
      NULL,
      2,
      4,
      4,
      1,
      0.480114,
      5,
      2.805572,
      4.290474,
      NULL,
      NULL,
      2.670007,
      NULL,
      1.009819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.535742,
      1,
      2.390558,
      1.132432,
      1.358502,
      0.393212,
      0.821874,
      0,
      0,
      0.083607,
      2.329591,
      3,
      2.251659,
      0,
      1,
      NULL,
      0.787910,
      NULL,
      NULL,
      1.182843,
      5,
      3,
      1.656430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      5,
      NULL,
      NULL,
      1,
      1,
      1,
      0.894220,
      9.369431,
      NULL,
      3,
      0,
      1,
      1,
      1.125041,
      0.747025,
      NULL,
      0,
      1,
      1.556052,
      6,
      0,
      1.262343,
      1,
      2,
      NULL,
      NULL,
      0.968747,
      1.211533,
      0.981633,
      1,
      1,
      4,
      NULL,
      0.083746,
      NULL,
      9,
      7,
      5.499785,
      7.942992,
      NULL,
      NULL,
      0.518520,
      NULL,
      0,
      NULL,
      1197,
      ' 1- 5-1997',
      NULL,
      3.231142,
      1.850363,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.638057,
      NULL,
      1,
      1,
      4,
      NULL,
      2.470884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701253,
      0,
      NULL,
      0.294946,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.672776,
      2,
      0.775057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647899,
      NULL,
      0,
      0,
      0,
      NULL,
      0.769742,
      0.904979,
      13,
      3.497546,
      1.192622,
      NULL,
      NULL,
      NULL,
      2,
      0.013189,
      1.900192,
      3.268150,
      1.080442,
      0.132710,
      3.985853,
      1.390575,
      NULL,
      2.124919,
      2.690549,
      0.079056,
      1,
      0,
      NULL,
      3.171198,
      5,
      0.476809,
      NULL,
      2,
      NULL,
      0.316854,
      1,
      1,
      NULL,
      1,
      NULL,
      1.089517,
      1,
      0,
      0,
      1,
      10,
      9,
      4,
      1.767537,
      NULL,
      2,
      NULL,
      NULL,
      0.209087,
      NULL,
      1.352767,
      2,
      NULL,
      2,
      NULL,
      7.761703,
      NULL,
      NULL,
      2.415049,
      NULL,
      4,
      3,
      '04000',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      3.672855,
      NULL,
      298,
      NULL,
      NULL,
      NULL,
      0,
      5.496858,
      2.240914,
      NULL,
      1,
      NULL,
      3,
      1.501732,
      1,
      3.467138,
      0,
      NULL,
      1,
      NULL,
      3.936990,
      NULL,
      3.647730,
      3,
      1,
      0.283997,
      3.887881,
      0,
      NULL,
      NULL,
      1.085852,
      NULL,
      NULL,
      0,
      3,
      2,
      3,
      2,
      0,
      2.906186,
      0,
      3.309656,
      2.088556,
      0,
      0,
      6,
      NULL,
      2,
      0.126709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620604,
      1.446759,
      0.167337,
      0.766010,
      NULL,
      NULL,
      1,
      0.958318,
      1,
      1.009913,
      0.097550,
      0,
      3.916584,
      1.449706,
      NULL,
      NULL,
      0.683899,
      0.475752,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      1,
      2,
      NULL,
      0.150414,
      0,
      1.867395,
      3,
      1.560116,
      1.871372,
      9.107443,
      NULL,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960595,
      1.163710,
      NULL,
      0.597236,
      0,
      2,
      2.468583,
      3,
      NULL,
      NULL,
      3,
      1.347855,
      0.448040,
      1,
      0,
      NULL,
      NULL,
      0,
      6,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.468574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993491,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.125536,
      0.053030,
      0.112707,
      1,
      NULL,
      NULL,
      3.230507,
      1,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.129888,
      1.630068,
      3,
      NULL,
      1.641615,
      3.544415,
      1,
      NULL,
      NULL,
      3,
      0,
      2.742611,
      1,
      0,
      2,
      3,
      1.392584,
      1.439560,
      0,
      1.334061,
      1,
      NULL,
      2,
      2,
      NULL,
      6.240266,
      1.835596,
      0,
      1,
      3.386849,
      2.628618,
      0.577238,
      6,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.272985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458104,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.304915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.675009,
      NULL,
      NULL,
      1,
      0,
      1.043374,
      1,
      0,
      3.469823,
      0.278640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.904280,
      NULL,
      NULL,
      NULL,
      1.089162,
      NULL,
      NULL,
      NULL,
      1.850692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.502943,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      94.764603,
      96,
      1,
      NULL,
      NULL,
      1.367619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483746,
      NULL,
      1,
      252.472793,
      1.097119,
      1,
      0,
      0.977741,
      1.551708,
      1.757449,
      0,
      1.060049,
      0,
      1.528318,
      0,
      0,
      0,
      1,
      1.819916,
      0.049650,
      0,
      1.552276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.407381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.404046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442901,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277005,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.085183,
      NULL,
      1,
      NULL,
      0.587576,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536340,
      0.898605,
      0.531244,
      0.399188,
      1,
      NULL,
      NULL,
      3.647441,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      2.175701,
      2.020940,
      NULL,
      2.767878,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.478908,
      NULL,
      1,
      0.000632,
      NULL,
      2.081815,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.433423,
      1.125707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708556,
      NULL,
      0.844610,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0.056170,
      2,
      3.363352,
      0.157458,
      NULL,
      38,
      NULL,
      4,
      3.959892,
      '00312',
      '',
      '',
      1.295771,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


