set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3322310',
      2.236968,
      0.983320,
      NULL,
      2,
      '2204',
      2.328128,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0.791991,
      '10-25-1999',
      64,
      0,
      NULL,
      108.116884,
      1.619558,
      ' 3-27-1979',
      ' 5-12-1979',
      ' 5-22-1991',
      0.730252,
      1,
      NULL,
      1.576004,
      1,
      3.080836,
      NULL,
      0,
      1,
      74.707845,
      2.408564,
      3.992333,
      5.219037,
      12.752335,
      NULL,
      0,
      NULL,
      1.589035,
      2.718173,
      4,
      0.937167,
      0.697459,
      0.034967,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.976833,
      1.974207,
      1.311275,
      2,
      NULL,
      0.713659,
      2.431605,
      1.571860,
      0,
      0.294235,
      NULL,
      1,
      4.040299,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0.809441,
      5,
      5,
      1.081663,
      0.627129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.836411,
      0.086254,
      1.483057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121596,
      1,
      0.769857,
      0.471255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.924425,
      1,
      0.469890,
      5,
      NULL,
      NULL,
      1.227226,
      0,
      0.274487,
      0.206246,
      1.930593,
      0.211535,
      0.492292,
      0,
      1.958044,
      NULL,
      NULL,
      1.879596,
      NULL,
      NULL,
      4,
      0,
      1.229724,
      NULL,
      0.121265,
      3.944194,
      5,
      5,
      1.355831,
      1.298873,
      NULL,
      NULL,
      3,
      1.127739,
      1,
      4,
      1,
      10,
      NULL,
      NULL,
      1,
      3.818312,
      10,
      0,
      7,
      3,
      2,
      '10-21-1998',
      1959.786277,
      ' 0-20-1982',
      NULL,
      1.815979,
      1,
      1,
      1.050975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914058,
      1.828797,
      3,
      1.167917,
      1,
      NULL,
      0.074487,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      1,
      3,
      1.908020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103164,
      5.495149,
      1,
      NULL,
      NULL,
      5.137470,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528778,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869520,
      0,
      0,
      1,
      0,
      0,
      0.364726,
      9,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.321356,
      0,
      1.495058,
      5,
      0.328835,
      3.082665,
      3,
      NULL,
      0,
      1,
      0.903055,
      3,
      2,
      NULL,
      3,
      3.501999,
      0,
      0.894741,
      NULL,
      0.556943,
      0,
      NULL,
      0.102027,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.564209,
      1,
      1,
      11.581242,
      3,
      NULL,
      0.235334,
      2,
      4,
      3,
      1.180454,
      0.519768,
      1,
      3,
      37,
      NULL,
      3.884343,
      NULL,
      27.677429,
      50.226718,
      83.527660,
      0,
      1,
      3,
      '23330',
      '',
      '',
      1.906317,
      NULL,
      NULL,
      '',
      1.085861,
      '',
      NULL,
      '',
      1,
      40,
      439.164361,
      20.156732,
      0.733392,
      18,
      9.201008,
      11.740090,
      1,
      0,
      NULL,
      NULL,
      0.900923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.303421,
      0.966012,
      NULL,
      NULL,
      NULL,
      1.051444,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.888758,
      NULL,
      NULL,
      1.058627,
      NULL,
      NULL,
      0.008147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.797080,
      2,
      NULL,
      0.935692,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.614778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.310740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697892,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.012279,
      1.086319,
      0,
      0.317479,
      NULL,
      NULL,
      NULL,
      2,
      5.763499,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.394031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.358771,
      NULL,
      NULL,
      NULL,
      0,
      1.665159,
      4,
      NULL,
      NULL,
      NULL,
      2,
      2.524240,
      1.555417,
      NULL,
      NULL,
      7.652824,
      2,
      2,
      2.991921,
      3.856181,
      2,
      1,
      NULL,
      NULL,
      1.987889,
      NULL,
      0,
      1,
      NULL,
      1.875391,
      0.585393,
      1.355937,
      2,
      5.958920,
      6.040435,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      2.988827,
      1.463962,
      NULL,
      NULL,
      3,
      1,
      0.871979,
      5.794701,
      6.929483,
      8,
      NULL,
      NULL,
      NULL,
      0.693101,
      1.488752,
      6,
      1.922637,
      0.050005,
      0,
      1.111343,
      0,
      2,
      NULL,
      NULL,
      1.611152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.284701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.904160,
      NULL,
      NULL,
      0.744809,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.423244,
      1,
      1.871623,
      NULL,
      1.344166,
      3.541132,
      2.257648,
      NULL,
      NULL,
      0.979036,
      1.333107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.205259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281739,
      1.041644,
      NULL,
      NULL,
      0.427427,
      0.801272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.015510,
      NULL,
      NULL,
      1.102308,
      0.298283,
      NULL,
      NULL,
      NULL,
      1.935631,
      NULL,
      NULL,
      0.890341,
      0.978436,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      213,
      NULL,
      0.967616,
      2,
      1.973981,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.336228,
      14,
      0,
      0.081651,
      0.605540,
      0,
      0.639690,
      1.959814,
      1.889221,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.990141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.086530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.174537,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256815,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665414,
      0,
      4,
      3.190053,
      1.511924,
      2,
      NULL,
      6.170311,
      1.038156,
      NULL,
      NULL,
      NULL,
      0,
      1.984651,
      0,
      0.086358,
      NULL,
      NULL,
      1.214341,
      3,
      NULL,
      0.646252,
      0,
      0,
      0.328110,
      0,
      1.139291,
      0,
      0.917195,
      NULL,
      0,
      NULL,
      1,
      2,
      3.221214,
      1.478631,
      NULL,
      1,
      1,
      1,
      1,
      0.765003,
      NULL,
      1.961505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445980,
      0.884486,
      0,
      0.417910,
      NULL,
      1,
      5,
      6.534582,
      6,
      3,
      1.965727,
      1,
      NULL,
      NULL,
      5.625250,
      0,
      NULL,
      '01300',
      '01112',
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


