set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784714';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.352748,
      0,
      1.055417,
      2,
      0,
      2.668261,
      5,
      2.358218,
      '332',
      '20042413',
      NULL,
      37,
      NULL,
      2.930280,
      0.499502,
      0,
      1,
      '4124',
      6,
      0.145205,
      NULL,
      NULL,
      ' 4-12-1987',
      20.795688,
      123,
      NULL,
      NULL,
      2,
      ' 3-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      1.128675,
      '10-22-1974',
      ' 3-13-1975',
      ' 0-28-1993',
      2.424451,
      0,
      1,
      NULL,
      1.237834,
      NULL,
      3,
      1.615182,
      1.939692,
      1,
      6,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      6.648414,
      3.264604,
      NULL,
      0.519040,
      3.333257,
      1,
      1.267687,
      1.418500,
      0,
      NULL,
      1.214468,
      1,
      1.274794,
      0.925068,
      2,
      NULL,
      3.477882,
      2,
      0,
      NULL,
      2.032137,
      4.757296,
      1,
      NULL,
      2,
      6,
      5.887372,
      4,
      3,
      1,
      0.809811,
      0,
      3,
      0.435349,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.340958,
      6,
      2,
      2.969157,
      1,
      1.220020,
      1,
      0,
      1.660537,
      0.830287,
      0,
      3.291057,
      2,
      2,
      0.105483,
      0.325619,
      NULL,
      0.469633,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.128907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.657066,
      NULL,
      6,
      NULL,
      4,
      0.269287,
      4,
      NULL,
      2.313597,
      0.315915,
      NULL,
      1.613243,
      1.529317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849237,
      NULL,
      0,
      1,
      6,
      0,
      NULL,
      0.280576,
      8,
      NULL,
      1,
      0.553730,
      NULL,
      0,
      0,
      3,
      1,
      1,
      2.633779,
      9,
      2.853941,
      8.130648,
      6,
      NULL,
      1,
      8.298053,
      NULL,
      4.455407,
      4,
      2.085922,
      ' 4-11-2000',
      39.080364,
      NULL,
      21.464305,
      2.198607,
      0,
      NULL,
      4.321665,
      1.164701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.748152,
      0.676180,
      1,
      1,
      NULL,
      1.094061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096702,
      NULL,
      21.633832,
      1.527962,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492399,
      0.824984,
      3,
      NULL,
      0.645681,
      NULL,
      1.612575,
      5,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.948446,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.795231,
      0,
      1.559406,
      NULL,
      NULL,
      1,
      6.364091,
      NULL,
      1.072163,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.515237,
      NULL,
      NULL,
      0.222918,
      1,
      NULL,
      1.463946,
      4,
      0,
      2.345158,
      1,
      1.071726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.044977,
      0.514234,
      0.765370,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.356044,
      NULL,
      6.964553,
      6,
      6,
      NULL,
      5,
      1,
      0,
      3,
      0,
      0,
      2.863919,
      33,
      3.023033,
      2,
      3,
      NULL,
      58.906982,
      69.243168,
      0.258669,
      2.271454,
      1,
      '23411',
      '21234',
      '',
      NULL,
      '',
      '',
      NULL,
      0.863796,
      '',
      '',
      '',
      0,
      6.164151,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.111334,
      1.274351,
      0,
      0,
      1,
      2.041358,
      1,
      NULL,
      NULL,
      1.305247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338128,
      NULL,
      NULL,
      0,
      NULL,
      0.884446,
      21,
      NULL,
      3,
      0,
      0.907022,
      0,
      0,
      1.027396,
      2.586922,
      1.706370,
      3.268603,
      0,
      NULL,
      0.625659,
      1.166202,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.381894,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.819902,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.108148,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.607620,
      NULL,
      0,
      NULL,
      3,
      0.469550,
      0.907172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718431,
      0.262013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372417,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302014,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.983930,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.787544,
      NULL,
      1,
      NULL,
      1.309620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061712,
      0,
      0.562097,
      NULL,
      0,
      NULL,
      1,
      2,
      9,
      2,
      3.729147,
      1.581508,
      1,
      1.100932,
      NULL,
      0,
      0.623581,
      NULL,
      0,
      1.991721,
      NULL,
      NULL,
      0.594838,
      NULL,
      0.896861,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414069,
      NULL,
      1.825036,
      1.110649,
      NULL,
      0.517900,
      1.259601,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.636170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312177,
      NULL,
      1.898347,
      NULL,
      NULL,
      NULL,
      1.954796,
      4.061218,
      5.369610,
      0,
      NULL,
      NULL,
      91.010103,
      109.146589,
      1,
      2.502255,
      1,
      '31000',
      '31303',
      '',
      1.329486,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


