set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0172938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1.560352,
      3.247892,
      0.468344,
      1,
      3.165120,
      1,
      NULL,
      '343',
      '03242123',
      8,
      63,
      '4013244',
      NULL,
      NULL,
      2,
      0,
      '1332',
      1,
      1.374565,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      2,
      4,
      '10-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 5-14-1978',
      0.831005,
      1,
      NULL,
      3.512229,
      0,
      NULL,
      2.666475,
      3,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.931498,
      NULL,
      1,
      3.954000,
      NULL,
      1,
      0,
      NULL,
      1,
      1.422146,
      1,
      0.603664,
      0.204104,
      NULL,
      4.648560,
      5.078863,
      NULL,
      5.323752,
      0.777093,
      5.210490,
      6,
      0.100667,
      5.605867,
      NULL,
      2.393476,
      5.372058,
      5.613652,
      0.306389,
      NULL,
      7,
      1.138820,
      2.280143,
      5.223813,
      0,
      1,
      NULL,
      NULL,
      1.447951,
      NULL,
      NULL,
      9.805031,
      2.015358,
      NULL,
      1,
      1,
      0,
      3,
      0.199292,
      0,
      2,
      0.783387,
      NULL,
      3,
      1.293231,
      3.793866,
      1,
      0.034975,
      NULL,
      0,
      4.367047,
      0,
      4,
      10,
      1,
      NULL,
      3.704064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.967709,
      0.689210,
      NULL,
      0,
      1.935888,
      1.519889,
      1,
      1.946927,
      NULL,
      0,
      1.585410,
      1.601859,
      NULL,
      0,
      0.244240,
      NULL,
      0,
      0,
      NULL,
      0,
      3.673466,
      NULL,
      0.803521,
      1,
      1.248482,
      4,
      4.393798,
      1,
      NULL,
      1,
      7.823584,
      6,
      5,
      1,
      NULL,
      1,
      0,
      3,
      2,
      5.903043,
      0,
      6.971911,
      7,
      4,
      0,
      5.169484,
      0,
      ' 3- 4-1983',
      337,
      ' 3-16-1991',
      12,
      2.374083,
      NULL,
      NULL,
      1.407639,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214381,
      0.745077,
      NULL,
      2.057888,
      0,
      NULL,
      2,
      0.815313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.935593,
      4.356104,
      NULL,
      7,
      2.058924,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.547730,
      1.571583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900289,
      1,
      0.736833,
      1.039571,
      1.752077,
      NULL,
      0,
      1,
      NULL,
      2.962677,
      1,
      NULL,
      NULL,
      NULL,
      2.809386,
      NULL,
      0,
      3,
      2,
      1.195311,
      0.146730,
      6,
      NULL,
      5,
      2,
      5,
      1.032328,
      0,
      NULL,
      1,
      NULL,
      1.466001,
      1,
      NULL,
      0.091138,
      0,
      0,
      0,
      1,
      1.438505,
      0.722092,
      0,
      0.527873,
      1.991125,
      1.974024,
      0,
      8.236712,
      0.995966,
      5,
      10.673485,
      6,
      3,
      5,
      3,
      4,
      2.537824,
      1.885816,
      0.027247,
      37.020111,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5,
      3,
      '40142',
      '',
      '',
      1,
      '',
      '',
      '',
      1.905115,
      '',
      NULL,
      '',
      0.696947,
      22.345367,
      117.675314,
      7,
      0.083645,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.478802,
      NULL,
      NULL,
      3.508006,
      0,
      0,
      2,
      0.416904,
      1.287332,
      2.208105,
      1.868384,
      0,
      2.591203,
      0,
      1.675740,
      3,
      0,
      0.572071,
      3.009390,
      0,
      1,
      1,
      1.805859,
      1,
      3.150393,
      1,
      1.831738,
      0,
      NULL,
      NULL,
      0.033672,
      NULL,
      NULL,
      0.359426,
      1,
      NULL,
      0.038337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.703269,
      0.463310,
      1.769758,
      1,
      1,
      1.673543,
      NULL,
      1.807330,
      0.158893,
      1.505844,
      0.273998,
      2,
      NULL,
      NULL,
      3,
      2.684706,
      2,
      NULL,
      1.689548,
      0,
      0,
      0,
      0,
      1.883867,
      0.168116,
      0,
      0,
      1,
      NULL,
      NULL,
      0.779822,
      1,
      1.525857,
      7,
      1,
      0.664508,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.622680,
      3,
      NULL,
      1,
      1,
      3,
      2,
      0,
      2.793965,
      5.522286,
      3,
      2,
      1.397820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.576087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319102,
      NULL,
      NULL,
      0,
      3,
      1.422097,
      1,
      NULL,
      NULL,
      9,
      5.259444,
      3,
      NULL,
      6.153504,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.169957,
      1.659159,
      NULL,
      NULL,
      0,
      2.036493,
      0,
      NULL,
      4.487371,
      5,
      1,
      NULL,
      3,
      3.766443,
      1.276068,
      NULL,
      2,
      1.713803,
      2,
      3.554726,
      0.957485,
      3.366799,
      8,
      2,
      5.347415,
      3,
      2.112959,
      1,
      3.660926,
      0,
      2,
      1,
      1.299699,
      0.279033,
      0.422724,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904309,
      NULL,
      NULL,
      1.918031,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242388,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.197316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.345946,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.290384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720622,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.243218,
      NULL,
      NULL,
      NULL,
      1.122310,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.353283,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.131577,
      NULL,
      NULL,
      NULL,
      1.188464,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      2.530836,
      0,
      NULL,
      1.085628,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.248036,
      1,
      0,
      1,
      NULL,
      0,
      1.071941,
      NULL,
      1.484909,
      NULL,
      0.258703,
      1,
      0.045669,
      NULL,
      1,
      NULL,
      NULL,
      1.914718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.928250,
      2,
      NULL,
      0.128805,
      3.252017,
      2.207458,
      4.584301,
      4,
      2,
      2.227801,
      NULL,
      1.628968,
      1,
      NULL,
      0.595792,
      0.658620,
      NULL,
      NULL,
      0.759253,
      NULL,
      1.124214,
      NULL,
      NULL,
      2.703587,
      0.126271,
      NULL,
      0.777792,
      0.452781,
      NULL,
      1,
      3.128661,
      NULL,
      2.918517,
      3,
      NULL,
      1.521702,
      3.282222,
      NULL,
      0,
      0.108012,
      NULL,
      1,
      0,
      NULL,
      3,
      1.322470,
      1.549773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397809,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      8.919589,
      6.810002,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      3.312880,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.012301,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


