set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '41',
      14.435286,
      32,
      NULL,
      3.823968,
      0.213884,
      1,
      3,
      '3442',
      0.529553,
      1.226785,
      NULL,
      NULL,
      ' 6-19-1984',
      106.371558,
      48,
      NULL,
      0.539334,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606426,
      ' 0-21-1990',
      NULL,
      ' 9- 0-1999',
      0.517818,
      0,
      2.588626,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827691,
      1.198988,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.665560,
      NULL,
      1.519927,
      0,
      5,
      NULL,
      1.494639,
      1.393662,
      2.487821,
      0,
      8.484620,
      1,
      NULL,
      4,
      0,
      6.194515,
      NULL,
      6,
      2.205278,
      1.116664,
      NULL,
      8,
      NULL,
      NULL,
      1.725874,
      3.119058,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4.748927,
      2.085012,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099566,
      NULL,
      2,
      4,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0.038221,
      3.827019,
      0,
      1.924575,
      8,
      0.758421,
      2,
      1.275441,
      0,
      0,
      NULL,
      0.982424,
      0,
      1,
      1.540574,
      1,
      0,
      0.810558,
      0.391877,
      1.728709,
      4,
      NULL,
      2,
      4,
      6,
      1,
      4.524038,
      1.332310,
      NULL,
      0.032256,
      1,
      0.924337,
      3.892098,
      0.849441,
      1,
      5.732430,
      4.929731,
      5.560783,
      3.241851,
      NULL,
      NULL,
      NULL,
      0,
      4,
      6.757593,
      NULL,
      1.580399,
      7.790233,
      NULL,
      0.030429,
      ' 6- 3-1994',
      6.810862,
      ' 7- 1-1974',
      6.417429,
      0,
      4.255652,
      NULL,
      7,
      1.454592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365459,
      1.266196,
      2.986110,
      1,
      1,
      0.938372,
      5.638199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857386,
      NULL,
      1,
      3.289420,
      2.168095,
      7.318383,
      NULL,
      1,
      NULL,
      3,
      4.855528,
      9,
      1,
      2,
      2,
      0.760657,
      1,
      1.743703,
      NULL,
      9.151406,
      1,
      6,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      15.686075,
      2.973361,
      NULL,
      1,
      3.568784,
      6,
      ' 8- 8-1979',
      NULL,
      ' 0-14-1974',
      7.889368,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.841365,
      2.764316,
      0,
      1,
      NULL,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.462597,
      1.015391,
      1,
      0,
      NULL,
      2,
      0,
      0.329921,
      3,
      2.360979,
      1,
      NULL,
      3,
      NULL,
      2,
      1.215464,
      0.843853,
      1,
      NULL,
      NULL,
      1,
      0.946111,
      0,
      NULL,
      1,
      0,
      0.990858,
      1.145968,
      0,
      0,
      0,
      3.329648,
      9,
      NULL,
      2,
      1,
      1.785478,
      0,
      NULL,
      NULL,
      1.459199,
      0.006241,
      NULL,
      3.211460,
      NULL,
      1,
      37.363148,
      NULL,
      11.043048,
      21.023943,
      1.473810,
      2,
      2,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.217957,
      NULL,
      '',
      '',
      0.423457,
      41,
      2.218661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.051320,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.450001,
      1.933826,
      1,
      1.920681,
      1,
      1,
      0.638562,
      1,
      1,
      0.424042,
      0,
      NULL,
      0.730518,
      1,
      0,
      1.741513,
      NULL,
      0.518888,
      1.186326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.493212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010238,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566533,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.644923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043468,
      3,
      NULL,
      1.288325,
      NULL,
      2.722137,
      NULL,
      207,
      NULL,
      1,
      NULL,
      0.224750,
      NULL,
      1,
      3,
      0.027877,
      16,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.785388,
      4.261550,
      0,
      0.025368,
      NULL,
      NULL,
      4,
      0.627138,
      1.667806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325238,
      3.980067,
      NULL,
      NULL,
      2,
      NULL,
      0.929109,
      1.756091,
      NULL,
      1,
      3.113123,
      NULL,
      0.019435,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.993607,
      NULL,
      NULL,
      1,
      NULL,
      0.020367,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.746784,
      NULL,
      1.227177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589047,
      NULL,
      1.378401,
      NULL,
      1.590425,
      NULL,
      NULL,
      NULL,
      5,
      1.924835,
      NULL,
      NULL,
      86.283966,
      20.291505,
      4,
      NULL,
      2,
      '22221',
      '01333',
      '',
      1,
      '',
      '',
      '',
      1.752308,
      '',
      '',
      '');
commit;
end;
/


