set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      NULL,
      NULL,
      4.326784,
      1,
      0,
      1.735291,
      1.558331,
      '324',
      '14142014',
      71.078484,
      24.074070,
      '1344100',
      NULL,
      0.955055,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 8-22-2003',
      141,
      NULL,
      NULL,
      2,
      NULL,
      ' 4-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      3.312023,
      NULL,
      ' 2-22-1989',
      ' 1-25-1993',
      0,
      1.196596,
      3,
      2.958348,
      1,
      0.536938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.239047,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      6.003475,
      2,
      NULL,
      NULL,
      1.133553,
      0,
      1,
      0,
      NULL,
      1,
      2,
      1,
      1.350926,
      1,
      0.762977,
      6,
      1,
      3.650662,
      1.755247,
      NULL,
      1,
      NULL,
      1,
      1.320325,
      NULL,
      NULL,
      0,
      0.341019,
      0,
      0,
      3.843943,
      0.496841,
      0,
      1.394104,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.595284,
      1.183728,
      0.337095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750975,
      0,
      0.857557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799312,
      0,
      0.956593,
      1.232381,
      0,
      1.703471,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1.797137,
      0.822955,
      1.313493,
      0,
      0,
      NULL,
      1.667782,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.992956,
      2,
      0.325987,
      5.536340,
      4.944591,
      1,
      4.914898,
      3,
      0.179215,
      1,
      6,
      4,
      3.992814,
      NULL,
      4.633541,
      9.967379,
      5,
      NULL,
      NULL,
      0,
      3,
      1.091581,
      ' 1-22-1978',
      10,
      NULL,
      2,
      1,
      0.604778,
      1,
      1,
      1.710115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.787741,
      0,
      NULL,
      NULL,
      0.254669,
      0.933040,
      1.010186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.853672,
      NULL,
      1.863338,
      3,
      NULL,
      1.287748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153545,
      0.672800,
      0.162225,
      NULL,
      NULL,
      NULL,
      1.058308,
      NULL,
      NULL,
      2.723922,
      1.835179,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.700391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.033698,
      1.325379,
      1.541383,
      1,
      1.727641,
      NULL,
      2.136381,
      0.398795,
      1.600135,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.924627,
      2.865175,
      NULL,
      0,
      2.158711,
      NULL,
      0.463490,
      1,
      NULL,
      1.226767,
      1.852035,
      0.757419,
      2.074256,
      5,
      0,
      NULL,
      1,
      2.572394,
      0.496475,
      1,
      NULL,
      1,
      0.229708,
      1.635252,
      1.892936,
      0.256963,
      1.900269,
      NULL,
      1.792222,
      6.524701,
      1.650449,
      4.528936,
      4.434570,
      NULL,
      5.109296,
      1.599551,
      1.017361,
      1.549225,
      NULL,
      1.541319,
      2,
      NULL,
      2,
      NULL,
      1.561827,
      NULL,
      2,
      33.170745,
      NULL,
      4,
      2,
      '02410',
      '',
      '',
      1.960812,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      34,
      27.021638,
      NULL,
      2.246189,
      46,
      3,
      NULL,
      NULL,
      3.768727,
      0.323139,
      1.799410,
      1.760809,
      NULL,
      NULL,
      NULL,
      0.493750,
      1.818807,
      2,
      1,
      1,
      0.025523,
      NULL,
      NULL,
      3.634729,
      1,
      0,
      1,
      0.176896,
      0.736683,
      0,
      1.603835,
      NULL,
      NULL,
      1.017761,
      1,
      1.266489,
      NULL,
      NULL,
      1,
      1,
      0.944369,
      0.919068,
      3.753697,
      NULL,
      6,
      NULL,
      0.818199,
      1.117592,
      0.136062,
      NULL,
      NULL,
      NULL,
      3.564089,
      2.373213,
      1.415559,
      NULL,
      NULL,
      3.068330,
      1.722248,
      1.333395,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.119421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      3,
      1,
      5,
      1.288151,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.662606,
      0,
      0.150701,
      NULL,
      NULL,
      3,
      0,
      0,
      1.042046,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078630,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.412284,
      NULL,
      NULL,
      0.286805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999220,
      NULL,
      NULL,
      0.463683,
      NULL,
      NULL,
      1.841080,
      3.157085,
      0.585732,
      3,
      1,
      NULL,
      0,
      1.285614,
      1,
      2.756886,
      5,
      6.152849,
      2,
      5.225546,
      0.283333,
      NULL,
      1.669569,
      1.213774,
      1.904344,
      0.571150,
      0,
      1,
      3,
      3,
      0.072456,
      9.364868,
      0.065562,
      2,
      NULL,
      0,
      3.932818,
      2.746433,
      3.511488,
      2,
      NULL,
      NULL,
      1.435704,
      2.527966,
      0,
      2,
      5.233411,
      NULL,
      0,
      3.333249,
      1.521030,
      0,
      NULL,
      1.387725,
      NULL,
      0.396445,
      0,
      0.827505,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947456,
      NULL,
      NULL,
      0.715539,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.787180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3.246778,
      NULL,
      0,
      0.992236,
      0,
      3,
      NULL,
      4.538580,
      NULL,
      NULL,
      NULL,
      3.560040,
      NULL,
      84.445143,
      NULL,
      2.067265,
      NULL,
      1.846301,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.792897,
      NULL,
      1.410384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.800880,
      NULL,
      1.734512,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.847689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211045,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.775919,
      NULL,
      0.930646,
      NULL,
      0.813552,
      NULL,
      0.774525,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.728786,
      NULL,
      0.250066,
      NULL,
      12.674833,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.428259,
      6,
      0.236312,
      3,
      NULL,
      7,
      0,
      NULL,
      NULL,
      0.497917,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      11.241364,
      0.079558,
      62.399853,
      NULL,
      0.154114,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.250398,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.390001,
      NULL,
      1.625108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352074,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.926348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294689,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511712,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422035,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      12.680164,
      NULL,
      0,
      1.841047,
      2.750134,
      1,
      3.522331,
      0.687084,
      3,
      NULL,
      NULL,
      0,
      2.037937,
      NULL,
      2.571046,
      0,
      0,
      0,
      1,
      38,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.941419,
      0,
      1,
      5,
      0.872617,
      4,
      3.050314,
      1.598484,
      6.586493,
      0,
      1.445549,
      1.753952,
      1.311725,
      1,
      NULL,
      1.647613,
      0.854437,
      NULL,
      NULL,
      1,
      NULL,
      1.678493,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140428,
      NULL,
      NULL,
      1.169283,
      NULL,
      NULL,
      0.511300,
      1.371771,
      NULL,
      1.516182,
      1,
      NULL,
      0,
      3,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140511,
      0,
      NULL,
      0.626450,
      0.668519,
      1,
      5.530052,
      NULL,
      3.209617,
      0.023026,
      NULL,
      NULL,
      31.362411,
      64.686552,
      4,
      3.234949,
      3,
      NULL,
      '41300',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


