set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7127190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.391448,
      0,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      '02324213',
      5,
      NULL,
      '0302042',
      0,
      0,
      2,
      2,
      '4042',
      5,
      0.854075,
      NULL,
      NULL,
      ' 3- 6-2001',
      82,
      168.416180,
      NULL,
      3,
      5,
      ' 0- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 9-12-1983',
      2.133296,
      1.653732,
      1.864008,
      NULL,
      NULL,
      2,
      6.371314,
      3,
      NULL,
      NULL,
      NULL,
      0.005426,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.721881,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710035,
      6.798451,
      5,
      NULL,
      4.380619,
      0,
      NULL,
      0.307031,
      NULL,
      4,
      8.755808,
      5.207840,
      1.095095,
      2,
      4,
      0.105913,
      5.178646,
      0.025602,
      0,
      4,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.647733,
      1,
      2.491750,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      1.960480,
      4.898248,
      1.828215,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.615852,
      NULL,
      10.347756,
      3.266631,
      4,
      NULL,
      8,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.639967,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.765580,
      7.000038,
      9.542137,
      NULL,
      6,
      0,
      6,
      3,
      1.829207,
      2.276487,
      0.932815,
      NULL,
      7.102828,
      1,
      2.724006,
      1.861634,
      0,
      8.808872,
      NULL,
      9,
      3.381818,
      2.655225,
      7.846357,
      0.103102,
      1.962245,
      1,
      3.414302,
      ' 0-12-1987',
      341,
      ' 4-15-1994',
      549,
      NULL,
      NULL,
      0.855933,
      NULL,
      0.711951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.685757,
      4,
      0.372476,
      1,
      1,
      1.941207,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      3.871957,
      0,
      5.760648,
      1,
      1,
      3.954915,
      1.223907,
      0,
      NULL,
      2.022200,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.135819,
      4,
      3.143950,
      NULL,
      5.054243,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203589,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1.714357,
      0.100945,
      1,
      0.160964,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861771,
      0,
      3,
      3,
      NULL,
      3.967525,
      NULL,
      3.725994,
      2,
      2,
      1.897099,
      1.371750,
      1.003183,
      NULL,
      NULL,
      0,
      0.545843,
      3,
      0,
      1.632774,
      3,
      0.984490,
      1,
      0,
      NULL,
      1,
      0.821524,
      1.354582,
      NULL,
      1,
      2.948450,
      5,
      3.566950,
      11.788959,
      1.248918,
      0.070292,
      2,
      0.045608,
      5,
      2,
      NULL,
      0.484277,
      15.718454,
      1.828020,
      0.457070,
      66,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3.144337,
      '01233',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3.220045,
      13,
      138,
      42.186186,
      NULL,
      67,
      NULL,
      4.720254,
      NULL,
      0,
      1.373712,
      0,
      2.300611,
      1.146680,
      1.711886,
      0.646008,
      2.356047,
      1.691725,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.551728,
      1,
      NULL,
      NULL,
      0,
      1.491497,
      NULL,
      1.365543,
      NULL,
      1.472073,
      0,
      3,
      0.293361,
      1,
      NULL,
      NULL,
      0.258583,
      NULL,
      NULL,
      11,
      7.143855,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363518,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.701585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963805,
      NULL,
      NULL,
      0.407885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.250848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525509,
      NULL,
      NULL,
      2.836214,
      0,
      1.265669,
      3,
      NULL,
      0.771746,
      2.568983,
      3,
      NULL,
      1,
      7,
      NULL,
      2,
      2.207928,
      1.935499,
      1.223463,
      NULL,
      0,
      NULL,
      1.436122,
      2,
      0.774054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.517984,
      0.117016,
      2.630226,
      2.646527,
      0,
      NULL,
      6,
      2.475162,
      3,
      3,
      NULL,
      7.207143,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504792,
      3.041312,
      2,
      NULL,
      0.486990,
      NULL,
      1,
      0,
      8.103928,
      8.490182,
      1,
      2,
      3.750495,
      2.916414,
      1,
      1.124661,
      3,
      2,
      1,
      3.140587,
      0,
      0,
      2.227775,
      7.563268,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      1.903383,
      1,
      1.766656,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      12.843225,
      NULL,
      NULL,
      2.868520,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.240144,
      NULL,
      NULL,
      2.344203,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.076171,
      NULL,
      NULL,
      9.309430,
      NULL,
      NULL,
      1,
      1.724615,
      NULL,
      0.343531,
      NULL,
      3,
      0.177592,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.598805,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.218132,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.896749,
      NULL,
      NULL,
      NULL,
      0.588793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.701496,
      NULL,
      NULL,
      NULL,
      0.751042,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.311206,
      36,
      14,
      0.394662,
      107.763764,
      21,
      0.307148,
      NULL,
      NULL,
      2.965385,
      6,
      2,
      NULL,
      1,
      0.055776,
      1,
      NULL,
      NULL,
      0,
      13,
      1.426475,
      60.215036,
      1,
      1.505877,
      0.837989,
      1.899925,
      1.184490,
      1,
      1,
      NULL,
      NULL,
      0.971161,
      1.626560,
      0,
      NULL,
      1.766998,
      1.146945,
      1,
      0,
      0.600145,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021485,
      0.284681,
      NULL,
      1,
      NULL,
      0.765970,
      1,
      1.285460,
      NULL,
      0.161559,
      0.456016,
      NULL,
      3.008110,
      NULL,
      0.782234,
      0,
      NULL,
      3,
      2.299261,
      NULL,
      0.584301,
      1,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3.930207,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.854043,
      NULL,
      NULL,
      1.688962,
      2,
      NULL,
      3.302306,
      NULL,
      0.920190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173996,
      NULL,
      0.394050,
      NULL,
      0.285529,
      NULL,
      2.467014,
      8,
      2,
      NULL,
      0,
      3,
      NULL,
      59.279265,
      4.925317,
      NULL,
      NULL,
      '43021',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.084190,
      '',
      '',
      '');
commit;
end;
/


