set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311844';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      2,
      3.679772,
      NULL,
      0,
      NULL,
      NULL,
      0.529250,
      '333',
      NULL,
      12.533858,
      33,
      '1221220',
      2.541994,
      0,
      1,
      1,
      '0314',
      0.661382,
      NULL,
      NULL,
      NULL,
      NULL,
      10.462353,
      36,
      NULL,
      1,
      1.273734,
      ' 3-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      2.905364,
      NULL,
      NULL,
      ' 9- 3-1991',
      NULL,
      1.198375,
      1.613691,
      NULL,
      0.365714,
      0.687371,
      2,
      2,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.455015,
      NULL,
      1.841165,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      2.438809,
      0,
      6,
      1.953082,
      4.822709,
      1.921158,
      0,
      0,
      0,
      0,
      4.677368,
      1.701778,
      1,
      4,
      1.653073,
      5.229398,
      6.802921,
      1.117918,
      5.306863,
      3.676541,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      5.587943,
      2,
      1,
      1,
      1,
      2.708461,
      3,
      NULL,
      2,
      1.790827,
      2,
      0.579458,
      1,
      1.895405,
      0.826034,
      3.555591,
      1.794553,
      NULL,
      1,
      0.503677,
      1.810282,
      5.901724,
      1,
      2,
      1.259370,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.952126,
      NULL,
      1.493482,
      NULL,
      1.344819,
      5,
      0.258127,
      1.185127,
      1,
      1,
      0,
      0,
      1.846057,
      1,
      1.292573,
      NULL,
      1.850137,
      1.845486,
      NULL,
      NULL,
      0,
      7.693250,
      0,
      NULL,
      3,
      1,
      6.019298,
      6.900809,
      NULL,
      1.336101,
      NULL,
      0,
      0.299033,
      NULL,
      NULL,
      0.463549,
      5.601000,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      7,
      0.654594,
      1.569158,
      NULL,
      2.405105,
      NULL,
      940.261069,
      ' 7-15-1984',
      1308,
      3.971596,
      1,
      NULL,
      NULL,
      0.109146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975475,
      1.569806,
      1,
      0.453141,
      1,
      1,
      0.756697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.031391,
      0,
      NULL,
      NULL,
      NULL,
      0.065128,
      1,
      NULL,
      6,
      NULL,
      3,
      1.741133,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.448822,
      NULL,
      1,
      2.768741,
      0,
      NULL,
      0.685502,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.075732,
      1,
      NULL,
      3.095804,
      2,
      1.003544,
      1.499177,
      0,
      NULL,
      2.968490,
      2.703664,
      3.942582,
      1.965489,
      NULL,
      NULL,
      2,
      2,
      1.896957,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.549473,
      3,
      NULL,
      1,
      2,
      NULL,
      3.649769,
      NULL,
      NULL,
      4,
      7.108066,
      4.831575,
      5,
      7,
      0,
      1.000418,
      NULL,
      2.822007,
      2.583072,
      NULL,
      21,
      2,
      0,
      10,
      NULL,
      NULL,
      NULL,
      4.800551,
      0.961354,
      3,
      '32401',
      NULL,
      '',
      1.451665,
      '',
      '',
      '',
      NULL,
      '0332',
      '',
      '',
      3,
      NULL,
      227,
      NULL,
      0,
      35.200897,
      37.977999,
      16.592953,
      2.857709,
      NULL,
      0,
      3.872788,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.901054,
      NULL,
      NULL,
      1.188559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1.163052,
      NULL,
      3,
      0,
      1.738098,
      2.703745,
      1,
      1,
      1.991010,
      0,
      0.522012,
      1.124333,
      0.133230,
      1.336876,
      2,
      1,
      7.811307,
      0.966751,
      NULL,
      NULL,
      NULL,
      NULL,
      3.168975,
      NULL,
      2.959802,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.229682,
      NULL,
      2.224189,
      3.628434,
      NULL,
      0.896813,
      0.909508,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      3,
      0,
      1,
      2,
      2,
      1,
      1.737880,
      NULL,
      0.713518,
      1,
      3.078953,
      1.142893,
      NULL,
      1.503554,
      NULL,
      0,
      3,
      4.821165,
      9,
      1.303927,
      0.558455,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.999502,
      0.833319,
      1.396940,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.971701,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      1,
      NULL,
      NULL,
      0.978613,
      NULL,
      NULL,
      0.835449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415596,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      4.033707,
      0,
      1.436017,
      7,
      0.187510,
      5.886377,
      NULL,
      NULL,
      NULL,
      0.788358,
      1,
      NULL,
      1.352619,
      1.707603,
      NULL,
      2.867147,
      1.156111,
      NULL,
      1.121655,
      0,
      NULL,
      NULL,
      NULL,
      2.041697,
      2.037047,
      0.377803,
      NULL,
      NULL,
      1.293602,
      3,
      NULL,
      0,
      3.369153,
      NULL,
      0.558054,
      2,
      2,
      1.427117,
      NULL,
      1,
      3.041930,
      0,
      0.622207,
      NULL,
      0.292290,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.331018,
      3,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      1,
      2.322848,
      NULL,
      NULL,
      9.583074,
      3,
      NULL,
      NULL,
      2,
      0.912583,
      NULL,
      NULL,
      1,
      1.333538,
      NULL,
      NULL,
      3,
      1.871965,
      NULL,
      NULL,
      0,
      1.100644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.268765,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2.136217,
      NULL,
      NULL,
      NULL,
      0.238816,
      NULL,
      NULL,
      1.794304,
      0,
      NULL,
      NULL,
      0,
      1.911109,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.807747,
      2,
      NULL,
      NULL,
      0.717706,
      3.206520,
      NULL,
      NULL,
      0.933315,
      NULL,
      NULL,
      NULL,
      3.742212,
      3.692863,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.734824,
      0.067460,
      3.188223,
      5,
      5,
      0.290801,
      158,
      57.432830,
      1.751915,
      NULL,
      16.661606,
      0,
      NULL,
      NULL,
      0.484062,
      8.163346,
      3,
      1,
      NULL,
      NULL,
      0.363917,
      NULL,
      NULL,
      1.343922,
      NULL,
      1,
      NULL,
      10,
      NULL,
      NULL,
      1.705681,
      NULL,
      0.272969,
      3,
      0.881960,
      1.912994,
      0.176776,
      3,
      1,
      1,
      0,
      NULL,
      0,
      0.651037,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.862810,
      NULL,
      3.124493,
      NULL,
      0.089463,
      NULL,
      3.831156,
      NULL,
      179.625693,
      NULL,
      0.962774,
      2.821417,
      NULL,
      1,
      1.035602,
      0.403465,
      NULL,
      0.653092,
      NULL,
      1.685162,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.990772,
      NULL,
      0,
      NULL,
      1.705533,
      NULL,
      1.028568,
      NULL,
      0.142817,
      NULL,
      1.523004,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      0.241829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.784404,
      NULL,
      0,
      NULL,
      0.003725,
      NULL,
      768.743550,
      NULL,
      2.033573,
      1,
      0.304437,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3.188423,
      NULL,
      3,
      NULL,
      788.637963,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.993265,
      26.356772,
      7.610693,
      0,
      1.789441,
      1.489385,
      3.787510,
      1.053397,
      1.879975,
      0,
      2.356379,
      0.588230,
      4,
      2,
      NULL,
      NULL,
      2,
      2.194003,
      1,
      1,
      0.330251,
      1,
      0.389610,
      0,
      NULL,
      1,
      0.808208,
      3.801702,
      2,
      NULL,
      NULL,
      0.908566,
      0.078967,
      NULL,
      1,
      1,
      NULL,
      1,
      1.248616,
      0,
      0.160602,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.667672,
      NULL,
      NULL,
      0,
      0,
      0.318071,
      1.076617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.999283,
      NULL,
      1.996497,
      NULL,
      0,
      NULL,
      2.052401,
      8,
      NULL,
      1,
      2,
      49.907018,
      48,
      5.866240,
      1,
      2,
      '33300',
      '43300',
      '12044',
      0,
      NULL,
      '',
      '',
      2.018182,
      '0312',
      NULL,
      '');
commit;
end;
/


