set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000093';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4044440',
      2.781132,
      1,
      3,
      NULL,
      '4233',
      1,
      0,
      1,
      38.528760,
      ' 3-28-1999',
      12,
      NULL,
      3,
      0,
      1,
      ' 7-28-1978',
      NULL,
      5,
      17.279111,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1982',
      2,
      1.727045,
      1.600305,
      1,
      0.814025,
      2.991958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.249521,
      4.107570,
      18.384996,
      NULL,
      NULL,
      5.694439,
      NULL,
      NULL,
      7.996117,
      1,
      1,
      NULL,
      0.181970,
      NULL,
      0,
      1,
      1,
      1,
      0.358307,
      1.384914,
      5.827661,
      3.633970,
      7.963251,
      2,
      1.443108,
      0,
      0.047699,
      0,
      0.438559,
      0,
      NULL,
      0.508787,
      1,
      0.857811,
      1.018039,
      0.290919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.681054,
      1.515371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475054,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.079176,
      NULL,
      2,
      0.770551,
      1,
      1,
      0,
      5,
      1,
      1.614926,
      1,
      NULL,
      1.291947,
      0,
      1,
      0.399854,
      NULL,
      NULL,
      1.857904,
      NULL,
      NULL,
      0.734913,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0.189914,
      0,
      2.218282,
      NULL,
      0,
      0.425617,
      3,
      3,
      2.096257,
      2,
      4.741487,
      0,
      4,
      0,
      2,
      NULL,
      0.190641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.454869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.115737,
      0.422121,
      1.634279,
      0,
      1.991552,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.109829,
      3,
      2,
      1.079315,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.325416,
      0,
      1.389638,
      1,
      0.217076,
      NULL,
      1.090387,
      NULL,
      3,
      0.176047,
      NULL,
      NULL,
      NULL,
      3.059373,
      NULL,
      0.003812,
      NULL,
      0,
      5.088772,
      2.679125,
      4,
      7,
      0,
      2.267704,
      3.271950,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0.394908,
      NULL,
      0.806555,
      0.539062,
      NULL,
      NULL,
      0.708485,
      1.426447,
      3.918228,
      NULL,
      0.786572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      85,
      NULL,
      NULL,
      NULL,
      8,
      0.107627,
      0,
      '12423',
      NULL,
      '',
      0.700233,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      37.969293,
      362,
      38.497088,
      0,
      36,
      17,
      28,
      3.743612,
      2.762557,
      1,
      NULL,
      1.815591,
      0.858930,
      1,
      1.793466,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.500847,
      2,
      NULL,
      1.018281,
      NULL,
      NULL,
      1,
      2,
      NULL,
      12.947379,
      NULL,
      NULL,
      11.182655,
      NULL,
      NULL,
      19.459590,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      9.716178,
      NULL,
      NULL,
      1.790180,
      4.041863,
      2.726352,
      1,
      NULL,
      9.677213,
      3,
      NULL,
      0.367970,
      NULL,
      NULL,
      NULL,
      1.076228,
      1.081719,
      11,
      1,
      3,
      0.810774,
      18,
      NULL,
      NULL,
      0.220812,
      NULL,
      NULL,
      2,
      1.369343,
      3,
      0.941675,
      1.984696,
      0.750450,
      3.930816,
      0,
      1.395728,
      0.857554,
      NULL,
      0.913153,
      NULL,
      0.365313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.759055,
      2,
      7,
      7.729762,
      7,
      NULL,
      1,
      3.569847,
      NULL,
      8.336234,
      1,
      0.362036,
      NULL,
      NULL,
      NULL,
      1.562418,
      NULL,
      NULL,
      2.505227,
      1,
      1,
      0.768347,
      NULL,
      NULL,
      5.690460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.609840,
      3.003646,
      0.142746,
      2.925515,
      NULL,
      2.772981,
      1,
      0.084191,
      7.291317,
      0,
      NULL,
      NULL,
      0.020949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.510361,
      NULL,
      NULL,
      NULL,
      1.226202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.374148,
      0.261136,
      0,
      NULL,
      NULL,
      1,
      2.657288,
      1,
      NULL,
      NULL,
      0.720390,
      0.971735,
      NULL,
      NULL,
      2,
      0.047752,
      6.262327,
      2,
      0.741804,
      6.171901,
      3.204193,
      0.998509,
      0.236006,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      5.948426,
      1,
      NULL,
      NULL,
      1.021172,
      3.525967,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.550544,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715839,
      NULL,
      NULL,
      0.612602,
      NULL,
      NULL,
      1.875947,
      NULL,
      NULL,
      3.933545,
      NULL,
      1.788406,
      7,
      NULL,
      3,
      NULL,
      NULL,
      1,
      7.794593,
      NULL,
      1.960290,
      0,
      NULL,
      2.067726,
      11,
      NULL,
      NULL,
      3,
      NULL,
      3.653771,
      NULL,
      NULL,
      NULL,
      24.311420,
      NULL,
      3,
      1.106535,
      1,
      0,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1091.290939,
      NULL,
      NULL,
      NULL,
      2.142818,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.522069,
      NULL,
      NULL,
      3.232108,
      NULL,
      NULL,
      NULL,
      1.912631,
      0.593159,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.251160,
      1.057658,
      NULL,
      NULL,
      1.167819,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.968981,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0.498455,
      5.365314,
      6,
      2.609273,
      192,
      63,
      3.135290,
      617,
      1976.561753,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      31.993951,
      15,
      1,
      NULL,
      NULL,
      0.203078,
      NULL,
      NULL,
      105,
      1.110971,
      1.430922,
      3,
      0,
      1.420765,
      0,
      1,
      1,
      0.177164,
      0,
      0,
      0.262971,
      0.304403,
      1.831234,
      NULL,
      1,
      1,
      1.157443,
      3.211031,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.970225,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      0.841173,
      1,
      1,
      NULL,
      0,
      1,
      2.777589,
      0.000504,
      1,
      NULL,
      0,
      0.506192,
      0.192213,
      0,
      0,
      1.148884,
      0,
      NULL,
      0,
      1.203538,
      1,
      1,
      0,
      1.015908,
      2,
      0.415157,
      1.153633,
      0,
      1.916020,
      NULL,
      0,
      0.204200,
      0,
      NULL,
      1.879138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001886,
      1.877355,
      1,
      1.134063,
      0.103619,
      1,
      0,
      5,
      1,
      0,
      NULL,
      NULL,
      34,
      10,
      2.214177,
      0,
      3,
      '02024',
      '',
      '',
      0.822693,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


