set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4432142',
      3.598288,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      140,
      NULL,
      5.303745,
      0.349070,
      0,
      ' 0- 4-1994',
      54.653351,
      0.942885,
      7,
      NULL,
      2,
      ' 5-22-2000',
      ' 4-27-1983',
      ' 5- 1-1992',
      NULL,
      NULL,
      0,
      0,
      1.808345,
      3.363284,
      5.793669,
      0.071145,
      1.244127,
      174,
      9.219179,
      7.334732,
      5.775860,
      15.461900,
      4,
      3,
      19,
      3.274020,
      0.591211,
      4,
      0.445376,
      0,
      3,
      0,
      0.594685,
      0,
      NULL,
      0.189991,
      0.525071,
      0,
      NULL,
      NULL,
      2,
      2.269376,
      0.654864,
      4.523022,
      1,
      4,
      1.800473,
      0.104776,
      1,
      2,
      1.514684,
      1,
      0,
      1.196465,
      0,
      NULL,
      0,
      3,
      1,
      0,
      0.554840,
      NULL,
      NULL,
      NULL,
      1,
      4,
      7,
      0.175608,
      0.050935,
      2.652589,
      NULL,
      0.658223,
      NULL,
      2.378893,
      3.701876,
      0,
      3,
      1,
      0.001047,
      NULL,
      1.022287,
      0.385824,
      0,
      0.230256,
      0,
      1.008018,
      1,
      0.790469,
      7,
      1,
      5.855911,
      1.556091,
      1.167130,
      NULL,
      NULL,
      0.783927,
      NULL,
      NULL,
      1.387620,
      0.334744,
      3.221704,
      NULL,
      3,
      1,
      0,
      1.331086,
      1.842764,
      NULL,
      4.850091,
      0.610932,
      NULL,
      2,
      1,
      1,
      NULL,
      0.468688,
      NULL,
      NULL,
      0,
      2.947164,
      0.390199,
      0,
      NULL,
      1,
      5.894350,
      1.479145,
      5.333545,
      6.168064,
      0.757749,
      1,
      3,
      4.186168,
      2,
      NULL,
      NULL,
      2.976155,
      9,
      7,
      4,
      0.893607,
      0,
      NULL,
      1,
      10.110881,
      6.012368,
      0,
      ' 1- 0-1995',
      1942,
      ' 1-14-1980',
      20,
      1.754157,
      3,
      0.558315,
      2.579909,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856955,
      3,
      1.915862,
      1,
      1,
      1.086785,
      1.989430,
      0.754670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3,
      1,
      0.361764,
      0.562382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.891059,
      2,
      1.256793,
      NULL,
      NULL,
      NULL,
      0.667512,
      5.422365,
      NULL,
      5,
      0.059334,
      5,
      2.796270,
      0.992340,
      NULL,
      NULL,
      3.992359,
      2.002343,
      1.594661,
      NULL,
      5.582475,
      2.354523,
      3,
      ' 2- 5-1980',
      11,
      ' 9- 8-1979',
      5.641207,
      NULL,
      2,
      0.181488,
      0,
      2.149000,
      1.505447,
      1,
      1.221533,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.339706,
      2,
      NULL,
      2.734108,
      3.014333,
      NULL,
      0.569995,
      3.840883,
      18.703449,
      1,
      0,
      1,
      2.366458,
      NULL,
      1.031084,
      NULL,
      0,
      1.599856,
      NULL,
      0,
      0,
      1,
      1.178312,
      2.147735,
      1.219816,
      2.957090,
      4,
      2.062428,
      NULL,
      1,
      6.852543,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      14.780061,
      0.372194,
      0.811327,
      NULL,
      30,
      NULL,
      9.711984,
      1.672074,
      5.510345,
      NULL,
      '11130',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.241491,
      '42024',
      NULL,
      '00214',
      2.659170,
      NULL,
      429,
      10.095163,
      0,
      57.700093,
      NULL,
      4.533795,
      2,
      0,
      1,
      3.647790,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.897696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.368965,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      3.054993,
      0,
      2,
      NULL,
      1,
      NULL,
      1.325204,
      NULL,
      1,
      1,
      1.861187,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.413685,
      NULL,
      0,
      3.859875,
      NULL,
      1,
      NULL,
      0.924716,
      2,
      1.870050,
      1.774842,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      3.560897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.487930,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.026032,
      NULL,
      NULL,
      4.657370,
      1.816969,
      1.148628,
      NULL,
      3.729994,
      0.186143,
      3,
      2,
      0,
      3,
      5.035028,
      0.177425,
      1,
      NULL,
      NULL,
      1.510150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.983829,
      1.034135,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      3.431306,
      NULL,
      0.176866,
      0.716014,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      1,
      0.920594,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.074769,
      NULL,
      1.238891,
      0.022040,
      2,
      4.722394,
      7.989204,
      3,
      6.139953,
      NULL,
      3,
      1,
      2.539424,
      4.359164,
      2,
      NULL,
      2,
      1.034764,
      3.263915,
      0.415949,
      NULL,
      7.781767,
      3,
      NULL,
      19.841665,
      111.062182,
      NULL,
      NULL,
      1,
      NULL,
      0.781964,
      1.716600,
      NULL,
      NULL,
      NULL,
      NULL,
      3.502279,
      1,
      NULL,
      1.408514,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.771442,
      NULL,
      0.166308,
      0,
      NULL,
      0,
      0,
      NULL,
      4.187679,
      4.934536,
      NULL,
      2,
      0,
      3.354086,
      2.568447,
      NULL,
      0.514755,
      2.444714,
      NULL,
      NULL,
      NULL,
      0.483914,
      0.573376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.436291,
      NULL,
      NULL,
      NULL,
      0.881788,
      NULL,
      NULL,
      NULL,
      3.681642,
      1,
      NULL,
      NULL,
      1.017019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.692039,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.183618,
      1.499654,
      NULL,
      0,
      0.409426,
      0.227996,
      NULL,
      NULL,
      0.672367,
      1,
      NULL,
      1.181071,
      NULL,
      0,
      NULL,
      1,
      0,
      1.857137,
      NULL,
      1.645650,
      0,
      1,
      NULL,
      5,
      2,
      7.077229,
      NULL,
      3.256627,
      0,
      NULL,
      NULL,
      NULL,
      1.802979,
      NULL,
      303.080563,
      1.298609,
      7.512230,
      0,
      0.943972,
      NULL,
      NULL,
      1,
      23.970557,
      11,
      NULL,
      69.028615,
      31,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948457,
      104.291306,
      1.225340,
      0,
      1.796599,
      0.967502,
      1.222776,
      1,
      1.292374,
      0,
      0.205982,
      0.817567,
      1.849798,
      1.430021,
      0.923593,
      1.937193,
      1.561948,
      NULL,
      0,
      NULL,
      1.743972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902153,
      1,
      2.551855,
      3,
      1.405792,
      3.679853,
      0.321685,
      1,
      2.651505,
      1,
      0,
      1,
      2,
      2,
      1.246621,
      NULL,
      2,
      3.711486,
      NULL,
      0,
      1,
      1.037914,
      NULL,
      2,
      1,
      1.430058,
      0.327185,
      0,
      0,
      0.011417,
      2.910920,
      0.953811,
      NULL,
      1.695827,
      0.121799,
      0.014210,
      NULL,
      1,
      NULL,
      0.140663,
      1.371347,
      0,
      0,
      NULL,
      3.643035,
      2.103716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734841,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      59.293766,
      NULL,
      4,
      1.696123,
      0.929902,
      0.067347,
      0,
      1.332945,
      NULL,
      3,
      6.038966,
      NULL,
      0.520426,
      NULL,
      NULL,
      86.539048,
      18,
      NULL,
      3,
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      4,
      '24413',
      '2134',
      '20210');
commit;
end;
/


