set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3334022',
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-27-1994',
      7.263464,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-20-2001',
      29.594405,
      0.539486,
      143,
      107.038672,
      5,
      NULL,
      NULL,
      ' 2-25-2003',
      0.671129,
      0.760670,
      NULL,
      3,
      0.519317,
      0,
      0.372657,
      2,
      NULL,
      NULL,
      NULL,
      5,
      3,
      6.741017,
      32,
      3.403834,
      28,
      3,
      2,
      2,
      1.472723,
      0.401612,
      0,
      1.691795,
      0.489817,
      0.174273,
      1,
      1.712290,
      1,
      NULL,
      1.055428,
      7.653314,
      NULL,
      10.621872,
      2,
      4,
      NULL,
      NULL,
      NULL,
      2.933031,
      0,
      4,
      0,
      NULL,
      1.751492,
      2,
      2.824410,
      0.312110,
      0,
      4,
      0,
      0,
      0.518638,
      NULL,
      NULL,
      1.381667,
      NULL,
      NULL,
      3.694522,
      7,
      1.074140,
      1.230526,
      2,
      1.852116,
      2.549839,
      1.797290,
      3.235722,
      1.665719,
      3,
      1.538078,
      3,
      2.833526,
      0.373738,
      2.261307,
      2,
      3.104140,
      NULL,
      1.600035,
      0.110924,
      NULL,
      6.466690,
      1,
      4.794089,
      1.384893,
      0.894148,
      NULL,
      NULL,
      0.199113,
      NULL,
      NULL,
      3,
      NULL,
      3.629511,
      NULL,
      NULL,
      6.349892,
      NULL,
      0.200049,
      1,
      1.246676,
      NULL,
      0,
      1,
      6,
      0,
      1.519367,
      1.620794,
      0.840408,
      0.432636,
      NULL,
      1.810835,
      0,
      3.465129,
      3,
      1,
      0,
      4.931076,
      7.107571,
      0.603815,
      NULL,
      NULL,
      0.214760,
      1,
      NULL,
      1.630745,
      0,
      1,
      2,
      6,
      5,
      0,
      0.578629,
      NULL,
      0.052363,
      3,
      9.113505,
      1,
      0,
      ' 4- 5-1997',
      242.764626,
      ' 2- 9-1991',
      NULL,
      0,
      0.087794,
      0.701424,
      4.248761,
      1.296736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279348,
      NULL,
      0.528184,
      0.259588,
      1,
      1.281196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.628118,
      3,
      3,
      0,
      2,
      5.482208,
      1.032568,
      7.215343,
      NULL,
      2.342287,
      6.649430,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100420,
      5.557939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      2,
      1,
      0.687185,
      2.928041,
      2.270118,
      1,
      1,
      NULL,
      1.603553,
      0.846342,
      NULL,
      3,
      0,
      1.147882,
      2.633318,
      NULL,
      NULL,
      1,
      0.656856,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.524947,
      NULL,
      NULL,
      5.014276,
      4,
      5.640072,
      4,
      10,
      2.112882,
      4,
      2,
      2,
      1,
      0.589611,
      3,
      61.364622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      '12210',
      '',
      '',
      0.189760,
      '',
      '',
      NULL,
      1.922733,
      '',
      NULL,
      '',
      1.212074,
      21.890216,
      73.873194,
      10.861847,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.211857,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.602821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      3,
      0.412920,
      3.611959,
      3.370065,
      NULL,
      3,
      3.398441,
      0,
      NULL,
      NULL,
      1,
      0.336374,
      0,
      1.343788,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286817,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759538,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600673,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.004823,
      1,
      0.567121,
      2.005092,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2.407653,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      1.042559,
      4.638185,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.835979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.188165,
      NULL,
      NULL,
      2.198791,
      3.748678,
      1.846649,
      3.080344,
      0.256402,
      2.409608,
      5,
      2.032791,
      3,
      3.545250,
      4.762526,
      5,
      NULL,
      NULL,
      NULL,
      2,
      2.470954,
      2,
      2,
      NULL,
      2.035143,
      NULL,
      3,
      1.736229,
      3.574245,
      5,
      7,
      1,
      1,
      1.680886,
      2,
      0,
      1.815807,
      1,
      3,
      2.175541,
      2.758860,
      2,
      3,
      2.011347,
      2.992084,
      4.515482,
      NULL,
      2,
      7.756055,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218905,
      1.443081,
      0.941721,
      1,
      1.521765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411834,
      1.622055,
      0.294798,
      0.806357,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.100309,
      NULL,
      NULL,
      3,
      2,
      1,
      0.561930,
      NULL,
      NULL,
      0.825274,
      NULL,
      NULL,
      1.573041,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.615961,
      NULL,
      1.716522,
      28,
      NULL,
      NULL,
      0.573728,
      0.828995,
      1.742553,
      1,
      0,
      NULL,
      0,
      1.831095,
      1.899902,
      0,
      NULL,
      1.497892,
      1.076542,
      0.549390,
      NULL,
      1,
      1.098840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.350299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400669,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.185855,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.133502,
      2,
      2.662613,
      NULL,
      3.301690,
      0.163506,
      0.929968,
      NULL,
      NULL,
      0,
      1,
      0.178095,
      1,
      0,
      0.145556,
      1.109271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766930,
      4.459160,
      2,
      8,
      1,
      1.053628,
      2.530992,
      NULL,
      11,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.848584,
      NULL,
      NULL,
      2.732601,
      2.852605,
      NULL,
      1.082628,
      1.388251,
      NULL,
      3,
      0.006924,
      NULL,
      0.183758,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.048264,
      2.348204,
      NULL,
      1,
      3,
      NULL,
      0,
      2.523353,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.363104,
      0.347500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.967945,
      NULL,
      0.468777,
      NULL,
      1.638729,
      5,
      7,
      0.820263,
      NULL,
      NULL,
      17,
      91,
      2.885374,
      0,
      1.658331,
      '44401',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.150829,
      '',
      '',
      '');
commit;
end;
/


