set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      32.121838,
      25,
      '3104444',
      NULL,
      NULL,
      5,
      0,
      '4202',
      NULL,
      1.145954,
      NULL,
      NULL,
      '10-11-1991',
      NULL,
      60,
      NULL,
      0,
      2,
      ' 0-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1983',
      ' 1-18-1989',
      ' 3- 1-1994',
      NULL,
      1,
      NULL,
      0.139939,
      0.335164,
      NULL,
      2.346358,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      2.685003,
      NULL,
      NULL,
      0.506897,
      3,
      NULL,
      0.869740,
      NULL,
      0,
      NULL,
      NULL,
      0.905210,
      1.919975,
      1,
      3,
      3,
      NULL,
      3,
      2,
      0.321791,
      0.436163,
      1,
      NULL,
      NULL,
      1.009594,
      0,
      1,
      0,
      0.222705,
      1,
      2.421563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.414731,
      2.143359,
      3.337013,
      0.236332,
      0,
      0.977833,
      NULL,
      0.568628,
      1,
      NULL,
      0,
      1.743190,
      1,
      1.545956,
      1.559020,
      0.243340,
      NULL,
      0.986762,
      0.288250,
      0,
      0.992414,
      5,
      1.552662,
      3.316024,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.103246,
      NULL,
      NULL,
      3.334497,
      0.539390,
      0,
      0,
      1.273442,
      1.220055,
      0,
      NULL,
      1.722245,
      1.042480,
      1.088290,
      NULL,
      1,
      0,
      1.569992,
      NULL,
      0,
      NULL,
      1.001172,
      0,
      1.097640,
      1.079120,
      6.682133,
      1.807275,
      NULL,
      2,
      6.069316,
      1,
      1.584939,
      2.815524,
      0.548602,
      NULL,
      8.755728,
      5,
      3,
      3,
      1.866710,
      NULL,
      0.024760,
      2,
      NULL,
      2,
      4,
      3.146879,
      ' 0- 1-1978',
      90.541474,
      ' 7-12-1997',
      1.550793,
      0.295978,
      0,
      0.757713,
      2.190905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474735,
      NULL,
      0.968591,
      NULL,
      0.873891,
      1,
      0,
      0.230338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      2.826173,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.640426,
      0,
      NULL,
      0.582432,
      1,
      NULL,
      1.529118,
      0.929266,
      40,
      2.509211,
      0.719973,
      NULL,
      NULL,
      NULL,
      1.261899,
      1,
      1,
      2.113015,
      1.429281,
      2,
      1.554791,
      0.709409,
      0.558248,
      0.492462,
      NULL,
      1,
      3.782896,
      3,
      0.655183,
      1.655317,
      NULL,
      0.001104,
      1,
      2,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.780550,
      0,
      NULL,
      2.852274,
      1,
      4,
      6,
      0.562085,
      1,
      7,
      NULL,
      NULL,
      NULL,
      5.500828,
      2.221512,
      2,
      0,
      NULL,
      NULL,
      3,
      22.685458,
      NULL,
      NULL,
      17,
      5,
      3.916653,
      2.019132,
      '32212',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      0,
      19.895866,
      NULL,
      3.233347,
      6.589178,
      NULL,
      2.411094,
      5,
      NULL,
      2,
      0.610512,
      NULL,
      NULL,
      NULL,
      0,
      2.930790,
      1.680353,
      NULL,
      NULL,
      1,
      2.028285,
      2,
      1.722029,
      0,
      1.771622,
      NULL,
      0,
      1.643285,
      NULL,
      2,
      1,
      0.449845,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.968342,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      6,
      2.215899,
      0.629599,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.803471,
      2,
      0.361892,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.928043,
      0.617066,
      1.269017,
      NULL,
      NULL,
      1.341935,
      1,
      1.562298,
      1.031776,
      NULL,
      2.740258,
      0,
      0.448352,
      NULL,
      0.223233,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644638,
      5.713864,
      NULL,
      3.021251,
      1.695377,
      0.991086,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.699105,
      1,
      NULL,
      NULL,
      1.584654,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3.633478,
      0,
      3.535157,
      2.416110,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841412,
      NULL,
      NULL,
      0.793455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.402663,
      0.214356,
      NULL,
      0,
      NULL,
      NULL,
      5,
      6.783395,
      NULL,
      NULL,
      4,
      0.473710,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.901967,
      3.118976,
      2,
      3.302587,
      NULL,
      NULL,
      9,
      1.353628,
      NULL,
      NULL,
      2,
      1.896070,
      NULL,
      3.702775,
      1,
      NULL,
      0.922340,
      3.180989,
      3.664803,
      2.122117,
      NULL,
      2.791983,
      0.821683,
      1.308860,
      4.168213,
      2.312256,
      0.029701,
      2,
      1,
      2.928797,
      0,
      NULL,
      0.699386,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064215,
      NULL,
      NULL,
      0.093860,
      NULL,
      NULL,
      0.014337,
      NULL,
      NULL,
      1.264074,
      NULL,
      NULL,
      1.131774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.391651,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.345319,
      2,
      1,
      2,
      0.321430,
      3.584257,
      NULL,
      0.663596,
      NULL,
      1.615969,
      NULL,
      5.034490,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.971046,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072920,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.682498,
      NULL,
      0.560137,
      NULL,
      NULL,
      NULL,
      1.693131,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.524027,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.187296,
      NULL,
      1.222332,
      NULL,
      1.359621,
      NULL,
      2.501851,
      NULL,
      0.766651,
      NULL,
      0,
      NULL,
      2.794764,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4.099955,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796613,
      0,
      2.782683,
      1,
      1,
      NULL,
      NULL,
      0.756436,
      NULL,
      NULL,
      0.112530,
      NULL,
      NULL,
      1.492021,
      NULL,
      NULL,
      1.040398,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.192808,
      0,
      0,
      0.065541,
      1.829713,
      NULL,
      1.704318,
      0.510111,
      1,
      1,
      0.201359,
      NULL,
      0,
      0.210392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210084,
      0.368756,
      2,
      0.883721,
      1,
      NULL,
      NULL,
      0.769401,
      1.457989,
      NULL,
      NULL,
      0.318390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.117560,
      1.845695,
      0,
      1.751169,
      3,
      0.313179,
      1.050606,
      2.291888,
      0.284314,
      0,
      1.060952,
      1.305067,
      0.075747,
      NULL,
      NULL,
      NULL,
      0,
      1.171717,
      NULL,
      0.352535,
      NULL,
      2.825835,
      3,
      0,
      3.075282,
      0.171824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565830,
      0,
      1.962021,
      1.163383,
      NULL,
      1,
      4,
      NULL,
      2.712629,
      1.516826,
      NULL,
      NULL,
      89,
      NULL,
      5.320799,
      3.676194,
      2,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.012274,
      '',
      '',
      '');
commit;
end;
/


