set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1341134',
      2,
      0.543881,
      0,
      3,
      '3144',
      3.273580,
      NULL,
      NULL,
      NULL,
      ' 0-22-1989',
      NULL,
      NULL,
      4.111900,
      1,
      0,
      NULL,
      79.200285,
      2.033135,
      11.163078,
      65,
      0.603933,
      NULL,
      ' 8-28-1982',
      '11-20-1987',
      0,
      3.190578,
      0,
      3,
      NULL,
      3,
      3.892576,
      NULL,
      1,
      150.787922,
      1.867332,
      7.791452,
      2.338423,
      131.942237,
      7.091007,
      2.068546,
      17.919470,
      5,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621105,
      3.809373,
      0,
      0.088927,
      0,
      0.075787,
      0.272645,
      NULL,
      0.048626,
      NULL,
      0.149698,
      NULL,
      1.305937,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.165363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519549,
      NULL,
      0.979146,
      1,
      1,
      1,
      1.610765,
      1,
      1,
      0.413923,
      0,
      2,
      NULL,
      NULL,
      1,
      0.572713,
      1,
      0,
      1,
      NULL,
      NULL,
      5.616207,
      1.068580,
      1,
      0,
      NULL,
      3,
      3,
      3.479787,
      0,
      NULL,
      8.227871,
      0.536278,
      NULL,
      5.035630,
      NULL,
      9,
      1.670332,
      4,
      0,
      3,
      7.030830,
      7.466274,
      3,
      0,
      0,
      2,
      3,
      ' 1-16-1986',
      1707,
      ' 1-28-2003',
      NULL,
      0,
      1.900294,
      1,
      3.554436,
      1.548712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.650309,
      1.730128,
      1.337739,
      2.266926,
      0,
      2,
      NULL,
      NULL,
      0.625041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042709,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644637,
      NULL,
      1.787873,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238100,
      0.982707,
      0.742333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840288,
      1.337142,
      NULL,
      0,
      1,
      0.724642,
      NULL,
      1,
      NULL,
      1,
      1.474327,
      NULL,
      NULL,
      NULL,
      3,
      1.610687,
      0,
      1,
      1.585363,
      0.619812,
      NULL,
      3.019521,
      0,
      3.445547,
      1,
      2,
      3.876251,
      0,
      3.345003,
      0.957514,
      NULL,
      1,
      1,
      NULL,
      0.591361,
      1,
      1.910775,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      5.983723,
      NULL,
      9,
      10,
      3.682818,
      11.060676,
      0,
      1.624228,
      NULL,
      3,
      NULL,
      3,
      0.680774,
      NULL,
      NULL,
      0.196037,
      1.356203,
      NULL,
      NULL,
      56,
      28.027801,
      1,
      NULL,
      4,
      '34243',
      '32000',
      '',
      NULL,
      '',
      '',
      '',
      2.692476,
      '1424',
      '2241',
      NULL,
      3.491675,
      12,
      348,
      NULL,
      0.950502,
      21,
      13,
      71.218786,
      2,
      0.082362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.498341,
      NULL,
      NULL,
      0.510551,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.932229,
      2.448402,
      0.041166,
      1.419085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111254,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.022822,
      0.011472,
      1.017688,
      3.481647,
      1.704196,
      0.475470,
      3,
      NULL,
      3.010423,
      0,
      1.696377,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.265220,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.971324,
      NULL,
      0,
      1,
      1.795404,
      0.190435,
      1,
      0,
      1.898793,
      3,
      NULL,
      0.791726,
      1.807369,
      1.210032,
      0,
      1.541373,
      3,
      1,
      1,
      NULL,
      NULL,
      1.650956,
      NULL,
      NULL,
      2.345688,
      0.797986,
      0.030083,
      1,
      0.844224,
      NULL,
      NULL,
      NULL,
      0.225905,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842743,
      NULL,
      1.649073,
      0.640563,
      NULL,
      NULL,
      5,
      1.120908,
      1.119402,
      1.111496,
      3.634801,
      NULL,
      1.076767,
      1.498812,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.610677,
      NULL,
      NULL,
      1,
      NULL,
      3.689368,
      0.665909,
      NULL,
      NULL,
      NULL,
      0.498983,
      1,
      2.026540,
      NULL,
      3.580250,
      7,
      0.214394,
      4,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.113801,
      NULL,
      2.100009,
      0.187253,
      3.289762,
      0,
      3,
      NULL,
      0,
      0,
      3.809263,
      2.391917,
      2,
      NULL,
      2.623611,
      6.142180,
      5.745847,
      NULL,
      4.017748,
      2.610212,
      1.926984,
      0,
      4,
      4,
      0.311075,
      1.744334,
      0.398715,
      NULL,
      1,
      3.358342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.448823,
      1.748222,
      1.376432,
      3.660260,
      0,
      NULL,
      NULL,
      0.541217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.900605,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591588,
      NULL,
      NULL,
      NULL,
      0.299001,
      NULL,
      NULL,
      NULL,
      0.971727,
      NULL,
      NULL,
      NULL,
      0.877874,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      447.180107,
      82,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.763647,
      NULL,
      NULL,
      0.040243,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.713117,
      94.902004,
      NULL,
      NULL,
      200,
      NULL,
      0,
      0.338395,
      1,
      0.590606,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1.033174,
      0,
      1,
      0,
      0,
      0.188042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      11.564899,
      0,
      7.245507,
      1,
      1.875559,
      NULL,
      1.416970,
      3,
      1.275911,
      0,
      1,
      NULL,
      0,
      0.285221,
      NULL,
      3,
      2.884925,
      NULL,
      0.710258,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.436390,
      NULL,
      1,
      3,
      NULL,
      1.770202,
      NULL,
      NULL,
      0,
      1.132464,
      NULL,
      2,
      0,
      NULL,
      1.755237,
      NULL,
      NULL,
      2,
      1.778789,
      1.148887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681834,
      NULL,
      1.706744,
      NULL,
      1,
      NULL,
      6.618217,
      9.029820,
      3.004337,
      0.293996,
      NULL,
      1.927165,
      24,
      51,
      3.931940,
      NULL,
      6.830962,
      '23040',
      '34024',
      '32321',
      0,
      '',
      '',
      '',
      5.554478,
      '3331',
      '4313',
      '');
commit;
end;
/


