set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '42',
      15,
      15.265526,
      '0011041',
      NULL,
      NULL,
      6,
      1,
      NULL,
      2,
      1.180493,
      NULL,
      NULL,
      ' 3-24-1985',
      30.560582,
      NULL,
      NULL,
      1.182637,
      0.449164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11-29-1979',
      ' 0-26-2000',
      ' 1-26-1983',
      0.216153,
      0.225488,
      2,
      1,
      0.703744,
      NULL,
      3,
      0,
      NULL,
      54,
      0,
      4.251936,
      5.490094,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.259478,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.179449,
      0,
      NULL,
      0,
      NULL,
      1,
      3.911360,
      NULL,
      NULL,
      1,
      9.558638,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.234517,
      1.283938,
      1,
      0,
      NULL,
      NULL,
      2.189940,
      1,
      NULL,
      0.615362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      5,
      2.974614,
      3.525732,
      0,
      1.818678,
      2.044914,
      2,
      0,
      NULL,
      2,
      1.103129,
      NULL,
      1.532705,
      3.881787,
      1.334356,
      2,
      0.330455,
      1,
      0.208480,
      0.624254,
      0,
      1,
      1.289885,
      5.289651,
      2.507385,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177766,
      NULL,
      4.019910,
      1,
      8.267195,
      0.936005,
      5.587799,
      1,
      0,
      0,
      1,
      1,
      0.165687,
      0.772206,
      1.667866,
      1.707857,
      0,
      1.785862,
      1,
      NULL,
      1,
      1,
      1.791271,
      NULL,
      NULL,
      0,
      2.909022,
      2.114356,
      1.766478,
      NULL,
      NULL,
      NULL,
      0,
      5.330354,
      1.093058,
      1.394362,
      11,
      9.532551,
      6.985998,
      7,
      0,
      1.618692,
      0.454704,
      5,
      3,
      2,
      5.970144,
      1,
      ' 1- 7-1991',
      180.166529,
      ' 9-16-2002',
      135.945308,
      NULL,
      1,
      3.873782,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      1.531007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.116322,
      1.025305,
      7.711596,
      1.632879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048331,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.981488,
      0,
      0,
      0.993452,
      NULL,
      0.447794,
      9,
      3.571232,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.595843,
      0.011091,
      3.043365,
      2.093554,
      4,
      5,
      1,
      0.372393,
      NULL,
      NULL,
      1,
      5.325458,
      2,
      1,
      3,
      0,
      3,
      0.416773,
      0.925511,
      0,
      NULL,
      1.257148,
      1.341903,
      0,
      1,
      1.965790,
      NULL,
      1.090566,
      0,
      3.595860,
      0.114081,
      6.345720,
      1,
      6,
      0.419208,
      NULL,
      3.060339,
      3.620588,
      0,
      0,
      1.169633,
      3.663603,
      0.075754,
      20.617288,
      0,
      NULL,
      NULL,
      NULL,
      44.315905,
      NULL,
      5,
      3.853799,
      7,
      NULL,
      '11324',
      '20330',
      0.529884,
      '',
      '',
      '',
      2.805885,
      NULL,
      NULL,
      '',
      2.382301,
      34,
      26,
      38,
      2,
      19,
      2,
      NULL,
      4,
      3.159836,
      2.405788,
      NULL,
      1.618489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.864194,
      2.505616,
      1,
      NULL,
      NULL,
      0.967029,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467836,
      NULL,
      NULL,
      0.248270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      4.184658,
      1.521726,
      1.046593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291870,
      2.161078,
      3.870308,
      NULL,
      2.231257,
      1,
      NULL,
      1.314076,
      0.833329,
      2.084272,
      1.096635,
      1.681491,
      0.726265,
      1,
      1,
      0.121178,
      NULL,
      0,
      1.014514,
      0,
      1.124432,
      0,
      1,
      1.961479,
      0,
      0.711946,
      NULL,
      NULL,
      1.958765,
      NULL,
      NULL,
      2,
      0.744485,
      1,
      NULL,
      7,
      1,
      NULL,
      1.539575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0.017881,
      3,
      2.372387,
      1,
      NULL,
      NULL,
      4,
      10,
      5,
      2.831159,
      2,
      1,
      1.921749,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.946404,
      NULL,
      NULL,
      1.973534,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.775894,
      NULL,
      NULL,
      3,
      0,
      1.389641,
      2.714635,
      NULL,
      NULL,
      3,
      4.890736,
      NULL,
      NULL,
      NULL,
      NULL,
      5.665655,
      0,
      1,
      3,
      NULL,
      2,
      2.234689,
      2,
      NULL,
      NULL,
      2,
      2.233778,
      0.229931,
      6.536469,
      NULL,
      2,
      3,
      2,
      0,
      1.822695,
      0.299187,
      2,
      2.817008,
      3.009791,
      NULL,
      2.829836,
      NULL,
      0.069000,
      5.518481,
      2.025456,
      NULL,
      7,
      2.201165,
      1.240067,
      0.096111,
      7,
      NULL,
      1.794404,
      1.285126,
      1,
      1.787807,
      1.783420,
      NULL,
      NULL,
      1.121707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.912095,
      NULL,
      NULL,
      1.241274,
      0.273968,
      1,
      1,
      NULL,
      1.599292,
      0.405164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.970580,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.119043,
      NULL,
      NULL,
      NULL,
      0.963152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013328,
      NULL,
      NULL,
      NULL,
      8.338934,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      4.611715,
      3.314909,
      1.921554,
      130,
      0.736361,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498110,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.626768,
      0,
      0,
      0,
      1.386979,
      0.278127,
      0,
      NULL,
      1.574225,
      0,
      1.528894,
      1.865514,
      1.243953,
      0,
      1.733587,
      0,
      NULL,
      1.260702,
      NULL,
      0.823943,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.102861,
      NULL,
      210.649411,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      1.145688,
      0.848527,
      2,
      0,
      NULL,
      1.892299,
      NULL,
      3,
      NULL,
      0.000968,
      NULL,
      0.766048,
      NULL,
      1,
      NULL,
      3.928105,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.966812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144789,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604857,
      NULL,
      0,
      NULL,
      0.698322,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.764006,
      NULL,
      0.179599,
      3.645708,
      NULL,
      1.495497,
      NULL,
      197.452568,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.628585,
      NULL,
      0,
      0.949030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.873893,
      NULL,
      0.329537,
      NULL,
      1.865434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224918,
      NULL,
      0,
      0,
      0.323325,
      NULL,
      NULL,
      0,
      NULL,
      0.319790,
      1.113026,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1.146880,
      NULL,
      0,
      3.071859,
      0.524257,
      4.061120,
      NULL,
      1,
      7,
      1.947148,
      NULL,
      1.275415,
      1,
      NULL,
      1.127459,
      1.470737,
      1,
      NULL,
      0.609484,
      0,
      NULL,
      0,
      0.636295,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.701613,
      NULL,
      0.314538,
      1.368609,
      NULL,
      0.647724,
      1.627943,
      NULL,
      1,
      1,
      NULL,
      0,
      1.566077,
      NULL,
      1,
      2,
      NULL,
      0.382773,
      0.130157,
      NULL,
      3.101087,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.151998,
      NULL,
      1,
      4.123249,
      NULL,
      1.767691,
      0.373324,
      3,
      NULL,
      25.968885,
      5.913868,
      0,
      0,
      NULL,
      '01312',
      '00213',
      0,
      '',
      '',
      '',
      0.595086,
      '3232',
      '',
      '');
commit;
end;
/


