set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9538351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2134122',
      2.215045,
      1,
      5,
      1,
      '2440',
      0,
      1.603063,
      NULL,
      NULL,
      ' 6- 9-2003',
      18,
      NULL,
      1.928933,
      1.058488,
      10.595452,
      NULL,
      2,
      NULL,
      39,
      NULL,
      7.342069,
      NULL,
      NULL,
      ' 0-25-1993',
      2.851568,
      0,
      NULL,
      0.873117,
      NULL,
      NULL,
      1,
      0.406753,
      1,
      NULL,
      NULL,
      6,
      1,
      24,
      8.032241,
      1.836225,
      NULL,
      5,
      3.262568,
      10.817130,
      1.978403,
      0,
      1.343470,
      1,
      1,
      1.435767,
      0.307349,
      NULL,
      0.678028,
      0.181676,
      1.535927,
      15.087179,
      3.699782,
      6.055496,
      1,
      3.592843,
      4.457533,
      1,
      6.731648,
      1.153320,
      0.865633,
      6.195880,
      0,
      1,
      NULL,
      1,
      1,
      6.395386,
      NULL,
      4,
      NULL,
      3,
      0.193553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.015221,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735373,
      NULL,
      1,
      1,
      2,
      1.984334,
      0,
      0.944825,
      NULL,
      NULL,
      1.865425,
      NULL,
      NULL,
      3,
      4,
      4,
      0.053049,
      4,
      NULL,
      0.865157,
      NULL,
      0.565988,
      3,
      2.248573,
      1,
      1,
      NULL,
      0.768163,
      1.789669,
      0,
      1,
      0,
      NULL,
      0,
      0,
      5,
      1,
      NULL,
      1.835975,
      NULL,
      2,
      1.437821,
      0.770041,
      7,
      NULL,
      0,
      4,
      3.752388,
      0.125204,
      NULL,
      NULL,
      5,
      1.880235,
      0,
      NULL,
      9,
      5,
      1.270935,
      0,
      6.159818,
      NULL,
      ' 3-13-1994',
      27,
      ' 5- 3-1984',
      0,
      0,
      0.717596,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099576,
      0.642025,
      1,
      0.006573,
      3.838865,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.237313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.168026,
      2,
      NULL,
      1.267888,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.590003,
      0,
      1.883557,
      NULL,
      0,
      1.722636,
      1.785365,
      NULL,
      1.554230,
      0.944277,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.959082,
      2,
      2.474444,
      2.972422,
      3.470952,
      0.144575,
      1,
      3.900617,
      1,
      1,
      2,
      NULL,
      0.931647,
      1.523189,
      0.049747,
      0.442204,
      NULL,
      NULL,
      NULL,
      1.843114,
      1.243495,
      NULL,
      0.659483,
      1.381609,
      1.458486,
      1.516228,
      0.909153,
      3.058851,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.456411,
      NULL,
      '00312',
      '43224',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.050242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.441544,
      NULL,
      NULL,
      34.399808,
      4.540257,
      1.553811,
      2,
      NULL,
      NULL,
      1.912969,
      1.078822,
      0,
      1,
      0.777773,
      3,
      0,
      1.563589,
      0,
      0.162836,
      0,
      1.462996,
      0,
      3.431007,
      NULL,
      2.883175,
      NULL,
      3.448827,
      NULL,
      0.607612,
      NULL,
      NULL,
      NULL,
      1.611938,
      NULL,
      77,
      NULL,
      4,
      8.387515,
      NULL,
      2.931525,
      0.641730,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.089885,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.502256,
      NULL,
      1.680100,
      NULL,
      0.763867,
      NULL,
      1.531899,
      NULL,
      1.819377,
      NULL,
      0.598345,
      NULL,
      0.361251,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.954032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286081,
      0.071717,
      NULL,
      1.891289,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.461430,
      1.475232,
      NULL,
      NULL,
      1.806354,
      NULL,
      2,
      NULL,
      53,
      NULL,
      1.861189,
      NULL,
      3.232997,
      NULL,
      0,
      NULL,
      NULL,
      1.844065,
      1.255434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955019,
      0,
      3,
      0,
      NULL,
      0.273946,
      0.333141,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      0.382599,
      1,
      0.968498,
      160,
      72.223831,
      3,
      3,
      2,
      NULL,
      3.680021,
      NULL,
      1.960746,
      2,
      2,
      NULL,
      0.644729,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.260241,
      3,
      1.695018,
      3,
      1,
      0.446599,
      9,
      2,
      1.582168,
      0.404866,
      0.636296,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.311248,
      0.410832,
      NULL,
      0,
      0.716485,
      NULL,
      1.223910,
      0,
      NULL,
      0.055209,
      3,
      NULL,
      1.743773,
      0,
      NULL,
      0.716258,
      0.459216,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.598287,
      NULL,
      NULL,
      0.246407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.527016,
      NULL,
      1,
      NULL,
      5,
      0,
      0,
      1,
      69.384638,
      100,
      5.981060,
      0,
      2,
      '20204',
      '24141',
      '',
      1.326839,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


