set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8234168';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7.176852,
      NULL,
      3.407847,
      6,
      2.939894,
      3,
      NULL,
      1.479625,
      '013',
      '41433240',
      NULL,
      46.242363,
      '2331100',
      2,
      NULL,
      0,
      3,
      '2313',
      5.711414,
      1.154695,
      NULL,
      NULL,
      ' 8- 0-1987',
      47.300523,
      95,
      NULL,
      0.664262,
      NULL,
      '10-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 1-10-1999',
      0,
      1,
      3.701375,
      NULL,
      0.149487,
      0,
      3.674026,
      0.204117,
      0.099434,
      59,
      0.568261,
      9.804131,
      4.805235,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      1.279483,
      0,
      NULL,
      4.123881,
      1,
      0,
      0.889609,
      NULL,
      0,
      1,
      3,
      11.248604,
      1,
      NULL,
      NULL,
      NULL,
      2.944574,
      1,
      1.213132,
      1.942423,
      1,
      3.670869,
      3,
      NULL,
      1.897871,
      11.655043,
      0,
      1,
      5,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.005839,
      0,
      1,
      0.244642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181836,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.282633,
      0,
      1,
      3.193405,
      0.722297,
      1.088075,
      NULL,
      1.012673,
      NULL,
      1.864158,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.384515,
      1,
      1.421140,
      NULL,
      1,
      0.433585,
      1.896953,
      0,
      NULL,
      1,
      0,
      0.171298,
      0.532499,
      1.999334,
      NULL,
      0.523055,
      0,
      0.256092,
      1,
      1.511505,
      7.711870,
      NULL,
      6.978983,
      0.011630,
      1.464045,
      4.271076,
      1.307970,
      5,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-23-1975',
      659.134204,
      ' 3-13-1982',
      79,
      0,
      1,
      0.710254,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.542822,
      0.088109,
      1.752977,
      0.080655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.936771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585058,
      NULL,
      2.356797,
      NULL,
      0,
      1.314568,
      1.199999,
      0,
      2.613319,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.676282,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.452044,
      1,
      0,
      3,
      0.058116,
      4.894878,
      NULL,
      2.494453,
      2,
      2.240341,
      7,
      3.766274,
      0,
      1,
      2,
      NULL,
      NULL,
      2.739062,
      0,
      5,
      NULL,
      NULL,
      1.923887,
      NULL,
      1,
      0,
      1.530101,
      0.922473,
      NULL,
      NULL,
      3.781388,
      0.335432,
      7,
      1.375679,
      NULL,
      4,
      6.896244,
      3,
      2,
      3,
      3,
      3.411663,
      0.012830,
      NULL,
      NULL,
      2,
      0,
      4.704013,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      '34331',
      '',
      '',
      1.203234,
      '',
      '',
      '',
      1.710707,
      NULL,
      '',
      '',
      NULL,
      18,
      NULL,
      41.432234,
      1,
      48.200815,
      4.611417,
      10,
      0.338808,
      3.683028,
      3.391219,
      3.285887,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.420054,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.561284,
      0.958257,
      1,
      3.429648,
      1,
      1.281442,
      2.541985,
      2,
      2,
      3.933082,
      2,
      2,
      3.635688,
      NULL,
      1.894043,
      1,
      NULL,
      NULL,
      NULL,
      3,
      9,
      0.243486,
      1.816369,
      NULL,
      NULL,
      NULL,
      0,
      0.215867,
      2.241994,
      NULL,
      1.624806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.414345,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122628,
      2.536096,
      3,
      3,
      0.827409,
      0,
      NULL,
      0.224814,
      0.069529,
      0,
      NULL,
      NULL,
      4.448567,
      NULL,
      6,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.663785,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.119031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.445886,
      NULL,
      NULL,
      1.668176,
      NULL,
      NULL,
      0.607076,
      NULL,
      NULL,
      1.173150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.943083,
      2.724230,
      3,
      2.134604,
      2.994167,
      0,
      1.111892,
      1.599668,
      0,
      1,
      2.471992,
      4.973238,
      3.197901,
      3,
      NULL,
      1,
      2,
      3.213206,
      0,
      NULL,
      0.605344,
      1.528774,
      2.226872,
      2.667995,
      7.547490,
      3.815654,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.524315,
      2,
      0,
      NULL,
      0.478580,
      1.567039,
      1.815755,
      NULL,
      1,
      0,
      NULL,
      NULL,
      117.315046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.942340,
      1,
      NULL,
      NULL,
      0.082726,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766927,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.921170,
      NULL,
      NULL,
      NULL,
      0.145945,
      1.821636,
      NULL,
      NULL,
      0.029489,
      NULL,
      NULL,
      NULL,
      2.996355,
      3,
      NULL,
      NULL,
      0.877432,
      3.589455,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.850941,
      0.219515,
      NULL,
      NULL,
      0,
      0.025978,
      NULL,
      NULL,
      12,
      5,
      NULL,
      NULL,
      0.996627,
      1,
      NULL,
      NULL,
      NULL,
      3.240862,
      15.068774,
      NULL,
      3,
      1,
      4.156300,
      NULL,
      6,
      0.123843,
      0.678157,
      0.094558,
      NULL,
      0.710519,
      NULL,
      NULL,
      0.573923,
      NULL,
      NULL,
      1,
      NULL,
      1,
      209.779973,
      29.014270,
      1.588331,
      3.594489,
      1,
      3.566139,
      0.220088,
      1.274552,
      1.973299,
      NULL,
      NULL,
      2.640149,
      NULL,
      0.014888,
      0,
      NULL,
      0.233994,
      1.530572,
      NULL,
      2.734193,
      NULL,
      1.313666,
      NULL,
      NULL,
      NULL,
      0.748149,
      NULL,
      1.484287,
      NULL,
      3.697390,
      NULL,
      NULL,
      NULL,
      1.614114,
      20,
      23,
      0,
      2.082294,
      1.401068,
      NULL,
      1.609855,
      NULL,
      1,
      NULL,
      1.301967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.100184,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.621834,
      NULL,
      NULL,
      NULL,
      1.866672,
      0,
      1.936468,
      0,
      NULL,
      0,
      NULL,
      1.443879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.231155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228633,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1.038368,
      0,
      NULL,
      0,
      NULL,
      1.901575,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      0.438387,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.449467,
      NULL,
      3.222791,
      NULL,
      0.604590,
      NULL,
      0.055249,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.133048,
      NULL,
      1.199933,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132373,
      1,
      1.206085,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.288884,
      0,
      NULL,
      1.625569,
      2,
      NULL,
      0.402787,
      0.474636,
      NULL,
      1.582084,
      1,
      NULL,
      3.313018,
      NULL,
      NULL,
      1.324719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.096058,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013219,
      1.753464,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.658194,
      NULL,
      1,
      NULL,
      1.360289,
      9,
      NULL,
      1,
      NULL,
      NULL,
      6.294902,
      NULL,
      3.638069,
      3,
      0.458460,
      NULL,
      '21230',
      '',
      0.021341,
      '',
      '',
      '',
      0.214663,
      '',
      NULL,
      NULL);
commit;
end;
/


