set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      '4343',
      1,
      NULL,
      NULL,
      NULL,
      ' 2-28-1982',
      27,
      NULL,
      4,
      1.800999,
      NULL,
      ' 9-23-1977',
      NULL,
      2,
      304,
      84,
      0,
      '11-28-1999',
      NULL,
      ' 6-13-1990',
      0,
      2.331643,
      1.537597,
      1,
      1.676484,
      NULL,
      2.982277,
      1.844219,
      NULL,
      NULL,
      NULL,
      4,
      11,
      3,
      17,
      5.766089,
      0,
      5,
      2,
      NULL,
      1.223725,
      1,
      1.180072,
      1,
      0.145081,
      NULL,
      NULL,
      0.856805,
      1.767980,
      8,
      NULL,
      0,
      10,
      NULL,
      3,
      4.883312,
      NULL,
      0.325191,
      1,
      1.016482,
      1.146496,
      3.940464,
      NULL,
      0.596229,
      0,
      1,
      NULL,
      NULL,
      3,
      1.281688,
      0,
      NULL,
      0.370998,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.741755,
      0.189013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449215,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.000570,
      NULL,
      3,
      1.862504,
      NULL,
      0.286708,
      1.630361,
      1.033674,
      0,
      0.629019,
      1.141685,
      NULL,
      NULL,
      4.054611,
      0,
      3.138759,
      4,
      0,
      3,
      7.561741,
      NULL,
      2,
      NULL,
      NULL,
      4.439975,
      0.967584,
      0.311553,
      NULL,
      2.657740,
      4,
      1.307345,
      2.858450,
      2.542534,
      3,
      5.974063,
      3.999306,
      4.802908,
      1.119306,
      1,
      2,
      NULL,
      3,
      ' 5-11-1974',
      1,
      0,
      NULL,
      1.444806,
      0,
      2,
      NULL,
      20,
      3.571176,
      2.957322,
      0.483929,
      NULL,
      NULL,
      3,
      3,
      1,
      0.976455,
      1.201187,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.558232,
      3,
      1,
      2.757272,
      0.022471,
      0.089146,
      NULL,
      NULL,
      1.623917,
      NULL,
      3.770110,
      1,
      2,
      0.893154,
      6,
      1,
      1.703247,
      0.445734,
      2,
      0.212350,
      NULL,
      NULL,
      NULL,
      2.824821,
      13,
      0.297499,
      NULL,
      7.549590,
      1.474998,
      NULL,
      '10-21-1997',
      10,
      ' 4-28-1991',
      9,
      0.528095,
      1.881037,
      NULL,
      2,
      0.144448,
      0.888883,
      1.162069,
      NULL,
      1,
      0,
      NULL,
      4.696061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395895,
      1,
      3.821340,
      0,
      0.925245,
      0.496086,
      1.876732,
      2.527494,
      3,
      3.523361,
      2,
      2.075328,
      NULL,
      1.561826,
      1.819197,
      NULL,
      15,
      115,
      10.496946,
      6,
      1,
      1,
      1.111182,
      0,
      0.490964,
      0,
      1,
      1,
      0.674961,
      1.403116,
      3.123980,
      0.560133,
      6,
      1.447268,
      1,
      2,
      4.183150,
      6,
      NULL,
      0,
      2.928182,
      2.743206,
      NULL,
      0,
      7.654934,
      3.944038,
      2.712758,
      NULL,
      35,
      42.012180,
      63,
      3.464502,
      1,
      NULL,
      '20412',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.914619,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843910,
      NULL,
      1.907102,
      2.627941,
      NULL,
      1,
      0.210762,
      NULL,
      NULL,
      NULL,
      1.629644,
      0.998913,
      1.755849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.070290,
      NULL,
      NULL,
      90.423550,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.774283,
      1,
      0,
      0,
      1.977074,
      1,
      1.866686,
      1.718949,
      1,
      1,
      1.370029,
      NULL,
      0.869706,
      NULL,
      1.372689,
      NULL,
      0.997751,
      NULL,
      1.163505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142913,
      1,
      NULL,
      0.796812,
      0,
      2.254756,
      0,
      2.906004,
      NULL,
      3,
      2,
      1.051850,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.555011,
      1.991263,
      NULL,
      0.880512,
      1.032634,
      NULL,
      2,
      NULL,
      NULL,
      2.285227,
      NULL,
      NULL,
      1.343112,
      1,
      NULL,
      1,
      1,
      NULL,
      1.055383,
      1,
      NULL,
      1.821084,
      1.418171,
      NULL,
      0.371029,
      1.362603,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.971881,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.091599,
      1.589661,
      1.267569,
      NULL,
      1,
      NULL,
      1.544003,
      NULL,
      0,
      NULL,
      4,
      1.317422,
      NULL,
      NULL,
      141,
      98.940200,
      2.377223,
      1.990336,
      2,
      '13304',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


