set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813582';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      3.537421,
      5.011111,
      NULL,
      0.405964,
      2.085174,
      2,
      NULL,
      '403',
      '02212130',
      45.676929,
      21,
      '3204312',
      0,
      1,
      1,
      2,
      NULL,
      1.147029,
      0,
      NULL,
      NULL,
      ' 7-21-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901654,
      ' 0-19-1995',
      ' 1-29-1984',
      ' 8- 6-1994',
      0,
      0,
      1,
      2.729261,
      1.418763,
      3,
      2.661326,
      1,
      NULL,
      6.387298,
      13,
      12,
      2.709145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256317,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.192863,
      1.783367,
      1,
      0.241602,
      1,
      0.109845,
      0.882366,
      3.272638,
      1,
      1.572819,
      5,
      0.189519,
      NULL,
      0,
      1,
      0,
      3.984290,
      1.395785,
      NULL,
      1,
      0,
      0.857532,
      3,
      0,
      NULL,
      NULL,
      0.024865,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.407450,
      4.119062,
      2.084735,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.731751,
      NULL,
      NULL,
      NULL,
      0,
      2.499273,
      0.678690,
      NULL,
      0.983165,
      5,
      0.433452,
      1.410905,
      NULL,
      1.369242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.606555,
      1,
      3,
      0.757612,
      0,
      NULL,
      2,
      1,
      1.457868,
      1,
      1,
      0.518687,
      0.633298,
      0,
      1,
      0.363068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525144,
      0.337221,
      4.645974,
      1.660490,
      5,
      7.336266,
      5,
      1.746685,
      8,
      2.786225,
      3,
      9,
      1,
      3.957572,
      7,
      2,
      10,
      3,
      0.741242,
      5.425348,
      8.364026,
      7.310894,
      2,
      0.607214,
      NULL,
      NULL,
      NULL,
      439.398458,
      ' 2- 6-1997',
      235,
      0.720095,
      1,
      1.334095,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146638,
      0,
      3.198855,
      1,
      0,
      1.558355,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.236331,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.973071,
      1,
      4,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212731,
      0.218757,
      0,
      1,
      NULL,
      0.733920,
      1.501883,
      0.384828,
      0,
      NULL,
      NULL,
      NULL,
      2.488988,
      0,
      3,
      NULL,
      3,
      1,
      1,
      2,
      3,
      1,
      0,
      2.143370,
      0.617428,
      NULL,
      0,
      NULL,
      1.659918,
      0,
      1.999510,
      3.116640,
      0,
      1,
      1,
      0.317012,
      1,
      1.980158,
      1,
      1.018226,
      0.731939,
      0,
      1.488057,
      NULL,
      5,
      11,
      5.404892,
      NULL,
      NULL,
      NULL,
      0.720615,
      NULL,
      NULL,
      1,
      3.695679,
      1.826221,
      21,
      NULL,
      3,
      35.303768,
      NULL,
      NULL,
      NULL,
      5.084971,
      1,
      NULL,
      '20023',
      '',
      '',
      0,
      '',
      '',
      '',
      1.019180,
      '',
      NULL,
      '',
      NULL,
      21,
      NULL,
      20,
      0.721614,
      12,
      NULL,
      1.668859,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.934191,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.218180,
      NULL,
      NULL,
      1.776917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.573329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.328445,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.190006,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.112841,
      NULL,
      NULL,
      NULL,
      0,
      0.309505,
      0.291427,
      1,
      1.773066,
      NULL,
      0,
      1.375140,
      1,
      2.437717,
      0,
      NULL,
      2.229344,
      NULL,
      0.012047,
      0.703059,
      NULL,
      NULL,
      1.835882,
      NULL,
      NULL,
      NULL,
      1.918331,
      2.442748,
      8,
      1,
      4.609592,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.698663,
      NULL,
      NULL,
      NULL,
      2,
      0.603180,
      2.646447,
      NULL,
      0.397566,
      1,
      1,
      1,
      NULL,
      1.502777,
      NULL,
      NULL,
      1,
      3.553506,
      0.921613,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.307558,
      NULL,
      NULL,
      0.616977,
      NULL,
      NULL,
      0.065921,
      NULL,
      NULL,
      0.849452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.556716,
      1,
      NULL,
      NULL,
      NULL,
      4.029054,
      4.979311,
      4.654682,
      8,
      5,
      7.158048,
      0.032427,
      NULL,
      NULL,
      NULL,
      2,
      3.929328,
      0.607164,
      1,
      NULL,
      0.287751,
      NULL,
      NULL,
      NULL,
      2,
      1.465123,
      1,
      1.807734,
      3.127851,
      1.320425,
      1.964351,
      2,
      2,
      3,
      1.933617,
      0.867239,
      2,
      2.278249,
      NULL,
      9,
      1,
      6.860924,
      3,
      NULL,
      2,
      5,
      2.134715,
      1.950141,
      0,
      0,
      1.356281,
      NULL,
      3.483633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.509079,
      NULL,
      NULL,
      2.221942,
      NULL,
      NULL,
      0.179743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.512175,
      NULL,
      NULL,
      2.089694,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.827452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      239.502776,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.050011,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840638,
      NULL,
      NULL,
      NULL,
      0.841878,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.299466,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.122676,
      NULL,
      NULL,
      NULL,
      2.898690,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.501746,
      2.718733,
      8,
      NULL,
      1.640540,
      28,
      7.476444,
      1,
      NULL,
      NULL,
      1.970376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.176936,
      70,
      0,
      NULL,
      0.698714,
      1,
      1.540152,
      NULL,
      0.303420,
      1,
      1.107255,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.427814,
      0,
      1.509270,
      0.930082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347206,
      NULL,
      0,
      NULL,
      2.021586,
      0,
      3,
      3.841938,
      1,
      1,
      1.364533,
      3.751145,
      1.127227,
      NULL,
      1,
      0.442774,
      NULL,
      NULL,
      2.194448,
      NULL,
      1.437085,
      NULL,
      NULL,
      1.808542,
      0.045799,
      NULL,
      0,
      NULL,
      NULL,
      1.277723,
      2.654154,
      NULL,
      0.455484,
      2,
      NULL,
      1.624731,
      NULL,
      NULL,
      0.662854,
      NULL,
      NULL,
      NULL,
      1.073566,
      NULL,
      NULL,
      1,
      0.614741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      4.997122,
      4,
      0.491787,
      NULL,
      NULL,
      33.824799,
      NULL,
      4,
      1.815487,
      NULL,
      '22412',
      '4243',
      '',
      0,
      '',
      '',
      '',
      1.434565,
      '',
      NULL,
      '');
commit;
end;
/


