set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835115';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '1323131',
      2,
      1.229078,
      0,
      3,
      NULL,
      NULL,
      0.091390,
      NULL,
      NULL,
      '11-25-1996',
      20,
      NULL,
      5.635035,
      NULL,
      1,
      ' 5-23-1987',
      3,
      NULL,
      111.050763,
      136.264894,
      0.695842,
      ' 1-28-1979',
      ' 4- 1-2001',
      NULL,
      0,
      2,
      0,
      2.754326,
      1,
      1.348449,
      6,
      NULL,
      0.877235,
      118,
      NULL,
      NULL,
      3,
      NULL,
      155,
      1.021542,
      3.699370,
      6.565910,
      0.473000,
      NULL,
      1.370378,
      0.575649,
      0.089145,
      1.693603,
      1,
      0,
      0.563330,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      3,
      0,
      0.976918,
      NULL,
      NULL,
      0,
      1.337295,
      5,
      0.453330,
      1,
      NULL,
      0.107787,
      0,
      7.999891,
      NULL,
      3,
      0.922458,
      NULL,
      1,
      NULL,
      NULL,
      0.165214,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.504019,
      0.697001,
      1.665413,
      0,
      1.951453,
      1.687759,
      0.601686,
      0,
      1,
      NULL,
      0.722181,
      0.929372,
      NULL,
      1,
      0,
      1.587209,
      0.739854,
      0,
      4.562669,
      6.782827,
      1.542602,
      NULL,
      0.449480,
      0.395159,
      NULL,
      NULL,
      0.753322,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.420276,
      7,
      0.685957,
      1.456647,
      0,
      NULL,
      0,
      0.985646,
      1.294333,
      0,
      4,
      1,
      0,
      0.558877,
      0,
      NULL,
      1,
      2,
      7,
      4,
      0.216105,
      1.040290,
      1.797652,
      1.247725,
      2,
      0,
      NULL,
      NULL,
      4.813776,
      NULL,
      1,
      2,
      9.860662,
      9,
      1,
      0.885467,
      8,
      NULL,
      3.176386,
      8,
      3,
      9.000533,
      0.248899,
      4.987236,
      2,
      ' 3-14-1974',
      NULL,
      ' 2- 1-1992',
      497,
      NULL,
      1.834980,
      1.387921,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.759189,
      NULL,
      NULL,
      0,
      1.655607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.997496,
      1.411687,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.346103,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504072,
      3.849501,
      NULL,
      3.207442,
      NULL,
      NULL,
      1,
      1,
      71.379609,
      1,
      3,
      76,
      1798,
      NULL,
      1.881037,
      0,
      1,
      2,
      0.657063,
      NULL,
      3,
      NULL,
      3.298683,
      2.847618,
      NULL,
      2,
      0,
      3,
      1.828813,
      1,
      145,
      85,
      20,
      16.163128,
      43.530506,
      163,
      1,
      1.486595,
      NULL,
      0.612727,
      0.528497,
      1,
      1,
      0.298123,
      NULL,
      0,
      8,
      11.057897,
      5,
      6.824712,
      9,
      3,
      3,
      2.322209,
      6.682820,
      NULL,
      NULL,
      NULL,
      38.694433,
      2,
      1,
      NULL,
      28,
      7,
      NULL,
      3,
      0.273888,
      NULL,
      '41241',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '23222',
      '',
      NULL,
      0.829224,
      28,
      186,
      27.702438,
      0,
      28.167924,
      15.590124,
      56,
      2.584918,
      3,
      NULL,
      13,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.846283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682145,
      NULL,
      NULL,
      0.666836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.689548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.591534,
      NULL,
      NULL,
      8.058834,
      1.136041,
      NULL,
      1.472276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.963099,
      2.024979,
      NULL,
      3.147828,
      NULL,
      0.601259,
      NULL,
      NULL,
      1,
      1.422196,
      NULL,
      NULL,
      0,
      1.346624,
      1.234602,
      NULL,
      0,
      0.880716,
      0,
      NULL,
      1.718435,
      1.492994,
      0,
      1.308915,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      7.592346,
      NULL,
      NULL,
      8,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982062,
      8.939613,
      1,
      0.069279,
      19.663846,
      1.797679,
      NULL,
      NULL,
      NULL,
      6.146743,
      1,
      0,
      0,
      1,
      11,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      1.139910,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.075072,
      3,
      NULL,
      0.935502,
      NULL,
      17.161324,
      4,
      3.347893,
      0,
      NULL,
      1,
      2.364538,
      7.707327,
      3.665726,
      3,
      1.163154,
      2.695131,
      NULL,
      NULL,
      1,
      7.685589,
      NULL,
      NULL,
      NULL,
      4.734216,
      5.753585,
      0.469900,
      NULL,
      NULL,
      NULL,
      1,
      11,
      14,
      0.506076,
      NULL,
      NULL,
      3,
      8.774296,
      1.326772,
      NULL,
      NULL,
      7.196922,
      8.049984,
      0,
      2,
      2,
      0,
      5,
      1,
      0.271825,
      1.463598,
      1.827276,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327303,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.592829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.433145,
      NULL,
      NULL,
      1,
      1.794006,
      1,
      1,
      0,
      3.613416,
      3.858858,
      NULL,
      NULL,
      0,
      1.750746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782665,
      0.916929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.481476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088826,
      NULL,
      NULL,
      NULL,
      1.621392,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.002583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      100,
      43,
      NULL,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      17.681197,
      4.323444,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      210.699583,
      NULL,
      0.162959,
      1.502531,
      1,
      NULL,
      0,
      1.989725,
      1,
      1,
      1.445624,
      NULL,
      0,
      NULL,
      0.875222,
      1,
      0,
      1,
      0.152198,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230369,
      NULL,
      NULL,
      2,
      2,
      2.306525,
      3.160387,
      1.710303,
      NULL,
      0,
      0.928369,
      9.448991,
      7,
      1,
      NULL,
      6,
      1.959667,
      9.015673,
      14.784774,
      NULL,
      13.721862,
      NULL,
      1,
      12,
      2.808908,
      1,
      10,
      18,
      0,
      3.085180,
      17,
      2.511737,
      13,
      1.855626,
      0.583734,
      10.706870,
      12,
      NULL,
      7,
      14.548950,
      3.486801,
      17,
      11.719362,
      2,
      2.433725,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714340,
      0.596299,
      0.266402,
      NULL,
      0,
      1,
      8,
      11.103035,
      13,
      1.550133,
      1,
      1.502586,
      NULL,
      41.233696,
      2.222892,
      1.236148,
      0.902311,
      '01334',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '10143',
      '',
      '');
commit;
end;
/


