set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0224110',
      0.122221,
      NULL,
      0,
      NULL,
      '3240',
      NULL,
      1.648807,
      NULL,
      NULL,
      ' 4- 0-1978',
      19.730489,
      NULL,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      269,
      NULL,
      2.349354,
      NULL,
      ' 5- 1-1974',
      ' 7- 6-1977',
      2.275324,
      1,
      2,
      0,
      0.219905,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      4.648138,
      4.933173,
      22.790071,
      6,
      4.032780,
      NULL,
      1.705027,
      1,
      2,
      0,
      0,
      0,
      1,
      1.618062,
      0,
      3.695705,
      1.166973,
      NULL,
      1,
      1.093293,
      2.537352,
      6,
      1,
      1,
      7.182543,
      0.703626,
      1.251253,
      5,
      1,
      NULL,
      1,
      5.659626,
      1.039031,
      NULL,
      0,
      0,
      1.461791,
      3.839816,
      1,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      0.782514,
      NULL,
      2.183023,
      0,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      NULL,
      3,
      1.468409,
      1,
      1.653735,
      1.438859,
      0.144479,
      0.472898,
      NULL,
      0,
      7,
      0.969029,
      3.374316,
      NULL,
      0.993656,
      NULL,
      NULL,
      3,
      0.512525,
      NULL,
      0.679378,
      0.228110,
      1,
      0,
      NULL,
      NULL,
      0.822192,
      1,
      0.923538,
      5,
      1,
      0.253667,
      NULL,
      2,
      1.189243,
      0,
      NULL,
      NULL,
      1.501457,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.500458,
      3,
      2.786021,
      0.985970,
      NULL,
      0,
      1,
      5,
      3,
      2.729017,
      NULL,
      7.149513,
      8.275714,
      7,
      NULL,
      4,
      NULL,
      6,
      2.754301,
      NULL,
      NULL,
      ' 2-14-1984',
      332.832838,
      1.929294,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542955,
      NULL,
      1.060672,
      0.230242,
      NULL,
      0.745205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.249310,
      1.069091,
      2.332909,
      0.285130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.995189,
      2.686667,
      0.763193,
      1.513558,
      NULL,
      7.600900,
      8,
      NULL,
      6.358077,
      3,
      0.027527,
      NULL,
      NULL,
      NULL,
      12.639424,
      2,
      NULL,
      3.480803,
      1.022932,
      8,
      '10-11-1985',
      NULL,
      ' 1-26-1977',
      NULL,
      0,
      1,
      1,
      2.318150,
      1,
      0.969312,
      0.212774,
      NULL,
      NULL,
      1.853720,
      3.560226,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344636,
      0,
      0.809243,
      2,
      0,
      2.544773,
      3,
      NULL,
      1.577935,
      1.240716,
      3.720806,
      3.931817,
      2,
      2,
      0,
      4.482400,
      NULL,
      NULL,
      0.594343,
      7.484836,
      NULL,
      1,
      1.113537,
      0.069752,
      1,
      NULL,
      0,
      1.022478,
      2.743587,
      NULL,
      0,
      NULL,
      NULL,
      6.277286,
      0.917153,
      NULL,
      7,
      3.396819,
      5.805903,
      NULL,
      6.169190,
      NULL,
      0,
      0.045791,
      30,
      0.708562,
      1.657651,
      NULL,
      5.965380,
      19.971076,
      7.292261,
      4.854399,
      1,
      2.186224,
      '03003',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      17.874788,
      454,
      17.124095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.237687,
      1.284324,
      NULL,
      NULL,
      0.995668,
      0.778030,
      2.369183,
      2,
      1,
      0,
      0.517023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0.375547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.486758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042866,
      NULL,
      NULL,
      6,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.286874,
      NULL,
      NULL,
      0.878031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856560,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.755148,
      NULL,
      NULL,
      1.234376,
      NULL,
      NULL,
      1.418508,
      NULL,
      NULL,
      0.345605,
      NULL,
      NULL,
      1.388402,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.343778,
      NULL,
      NULL,
      0.181466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.913589,
      4,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789578,
      3,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      5.904028,
      3.226442,
      NULL,
      2.362454,
      0,
      3,
      0,
      0.337096,
      2,
      0.846548,
      3,
      2.899396,
      3.936511,
      7,
      4.619869,
      0,
      0.751112,
      2.801839,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.396785,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508862,
      NULL,
      NULL,
      1.793431,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.107091,
      NULL,
      NULL,
      3.818582,
      NULL,
      NULL,
      0.071855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127793,
      0.521670,
      1,
      1,
      0.943739,
      3.129354,
      1.341472,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.878089,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.543653,
      NULL,
      NULL,
      NULL,
      1.123790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.326899,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.424315,
      NULL,
      NULL,
      NULL,
      1.871477,
      NULL,
      NULL,
      NULL,
      0.932948,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.233780,
      6.690905,
      3.274496,
      0,
      1,
      3.945532,
      2,
      0.893803,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.712463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.784872,
      NULL,
      1.637609,
      319,
      0,
      1.162246,
      1.249625,
      1,
      0.277909,
      1.732837,
      NULL,
      1,
      1,
      0.592072,
      1,
      1,
      1,
      0.438438,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.991523,
      1.982214,
      1.834065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519216,
      1.883079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.602515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740613,
      1.074453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.771990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.460541,
      NULL,
      0.495517,
      NULL,
      1,
      1.343398,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665591,
      4.941863,
      11,
      1,
      0,
      3.932355,
      6.848862,
      18,
      0.704877,
      3.995754,
      1.792297,
      0,
      0,
      NULL,
      3,
      1.849858,
      NULL,
      1.758064,
      2,
      NULL,
      1.000263,
      2,
      NULL,
      2,
      2.534686,
      NULL,
      0,
      0,
      NULL,
      2,
      3,
      NULL,
      0.457419,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.655362,
      NULL,
      NULL,
      1.040355,
      0.424176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.826593,
      NULL,
      1,
      NULL,
      0.065044,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      0,
      3.576195,
      '43423',
      '',
      '',
      1,
      '04214',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


