set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5312661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '4123344',
      NULL,
      1,
      NULL,
      0,
      '4143',
      1,
      0.499615,
      NULL,
      NULL,
      ' 9- 5-1978',
      NULL,
      NULL,
      1.243064,
      0.630777,
      0,
      ' 6-21-1989',
      52,
      1,
      312,
      83,
      NULL,
      NULL,
      ' 4-20-2001',
      '11- 6-1984',
      3.009257,
      0.256341,
      2,
      1.773840,
      0,
      NULL,
      10,
      NULL,
      0,
      NULL,
      13,
      16.082198,
      4,
      0,
      15.209796,
      1,
      29.020245,
      3.845971,
      NULL,
      1.810837,
      NULL,
      1,
      NULL,
      0.615752,
      NULL,
      0,
      NULL,
      0.302679,
      0.901383,
      1.280704,
      1,
      1.470394,
      7,
      10.288144,
      0.432943,
      NULL,
      NULL,
      1.607660,
      0,
      1.318467,
      1,
      1.077792,
      1.395557,
      1.190053,
      1.098239,
      1.537995,
      0,
      1.152379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865285,
      0,
      NULL,
      0.971863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.368214,
      0.344659,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281971,
      1.438252,
      0,
      2.136636,
      3.655597,
      2,
      1,
      1.084568,
      2.586669,
      3.375925,
      1,
      0,
      1.866685,
      NULL,
      0.675087,
      0.857620,
      1.671449,
      NULL,
      NULL,
      NULL,
      1.592566,
      1.861610,
      NULL,
      1,
      0.882707,
      0,
      0.093051,
      NULL,
      0,
      1,
      0,
      2,
      0,
      0,
      5.809797,
      NULL,
      NULL,
      1.129474,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      2.811594,
      3,
      8.686000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.651788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.624275,
      1.872607,
      NULL,
      1.822751,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.620468,
      0.059052,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144390,
      0.003134,
      3.246024,
      3.436635,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.449923,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.187767,
      NULL,
      0.479460,
      NULL,
      0.551705,
      174,
      0.182671,
      1.520265,
      NULL,
      NULL,
      NULL,
      0.902369,
      0,
      0,
      NULL,
      1.099964,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      1.093768,
      NULL,
      NULL,
      0.934192,
      0.198295,
      0.999318,
      0,
      2.621627,
      0,
      0,
      1,
      0,
      3.423875,
      2.545079,
      0,
      NULL,
      1,
      NULL,
      1.604271,
      1.619620,
      7,
      0.899437,
      5.026987,
      1.677380,
      2.882802,
      5.547466,
      2,
      1.105891,
      3,
      NULL,
      2.554328,
      15,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868500,
      NULL,
      NULL,
      '13030',
      '11112',
      0.521696,
      '',
      '',
      '',
      2,
      '14220',
      NULL,
      '',
      3.384374,
      NULL,
      NULL,
      4,
      1.870938,
      10,
      2.927257,
      NULL,
      3,
      0.312464,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.733298,
      NULL,
      NULL,
      1.572111,
      NULL,
      NULL,
      0.675145,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.289591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243109,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.351215,
      0,
      0.535853,
      0,
      1.553303,
      1.698904,
      5,
      5,
      0,
      3,
      3.639290,
      0,
      1.987090,
      2.788555,
      1.757590,
      4.685971,
      0.031868,
      1.634819,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.615355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.477225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.324318,
      2,
      0.140895,
      1,
      1,
      0.719343,
      3,
      3.170579,
      0,
      2,
      0.292816,
      1,
      0.702672,
      NULL,
      NULL,
      1.397593,
      NULL,
      0,
      2.319517,
      NULL,
      2,
      5,
      6,
      3.291551,
      6.681911,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.337502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1977.333947,
      NULL,
      NULL,
      NULL,
      0.838889,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.116725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643316,
      NULL,
      NULL,
      NULL,
      0.052772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143433,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.325624,
      NULL,
      NULL,
      NULL,
      4.010052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147147,
      3,
      2.532292,
      3.530859,
      1.921746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.820878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.979384,
      NULL,
      1.043622,
      52,
      NULL,
      0.602508,
      0.408655,
      NULL,
      1.609603,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.949145,
      1,
      0.736046,
      0,
      1,
      1,
      1.528617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161575,
      3,
      2.294984,
      0.944010,
      4,
      NULL,
      NULL,
      12.262372,
      2.018051,
      0.649308,
      0,
      1.344636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.073378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.945459,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005810,
      NULL,
      NULL,
      NULL,
      2.438599,
      7.991060,
      4,
      1,
      NULL,
      NULL,
      64,
      81.728297,
      2.795258,
      1,
      6,
      '02414',
      NULL,
      '33024',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


