set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.426883,
      NULL,
      0.759775,
      0,
      2,
      3.624468,
      1.323886,
      1,
      '24',
      '13321244',
      30.883025,
      NULL,
      '0031104',
      2.126998,
      NULL,
      6,
      2,
      '1201',
      5.241228,
      1,
      NULL,
      NULL,
      ' 0-19-1983',
      NULL,
      63,
      NULL,
      0.666125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '11-13-1982',
      NULL,
      ' 3- 2-1999',
      3.562490,
      0,
      2.474071,
      0.465622,
      1.410973,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455472,
      NULL,
      5.762460,
      NULL,
      2,
      0,
      NULL,
      4,
      NULL,
      NULL,
      0.995643,
      1.371476,
      3.287880,
      NULL,
      NULL,
      1.132697,
      6.881695,
      2.736667,
      3.894694,
      0,
      1.227963,
      0,
      NULL,
      NULL,
      0.575940,
      NULL,
      NULL,
      2.564136,
      1.485517,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.894203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089479,
      0.512978,
      1,
      1.039068,
      4.871490,
      NULL,
      1.534788,
      0,
      1.309613,
      0,
      2,
      NULL,
      NULL,
      1.469379,
      0,
      1,
      1.853832,
      1,
      NULL,
      0.260182,
      1.696650,
      NULL,
      1,
      1.793958,
      1.800948,
      3.306463,
      5.948686,
      0,
      1,
      NULL,
      NULL,
      1,
      2.580469,
      0,
      0,
      0,
      0.855745,
      1.818900,
      2.613417,
      1,
      1.463241,
      0.994142,
      1,
      1,
      1.082992,
      0,
      0.360771,
      ' 1- 6-1984',
      NULL,
      ' 3- 5-1991',
      NULL,
      2.979483,
      2,
      0.381989,
      2.128985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830123,
      1,
      1,
      2.970993,
      0.384149,
      NULL,
      3.255804,
      4.607548,
      0.391809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.691134,
      NULL,
      0,
      NULL,
      1,
      1.664492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.056424,
      0.897884,
      1.138564,
      1,
      0,
      5.368363,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017214,
      1,
      1.617315,
      NULL,
      1,
      1,
      1,
      1.580358,
      NULL,
      0.607782,
      0.355812,
      NULL,
      NULL,
      NULL,
      2.475409,
      0.010362,
      2.775605,
      3,
      NULL,
      1,
      1.184319,
      3.059283,
      0,
      1.602398,
      1.695754,
      0.904194,
      NULL,
      0.185167,
      3.702154,
      0,
      5.544357,
      NULL,
      1,
      1.713442,
      1.946449,
      0.638120,
      0,
      1.253571,
      0.927491,
      1.915691,
      1,
      1.113852,
      1,
      1,
      3.644615,
      0,
      NULL,
      4.763107,
      1,
      1.346345,
      4.225992,
      0,
      NULL,
      2.532612,
      3,
      0,
      2,
      3,
      25.055890,
      NULL,
      1,
      51.700455,
      NULL,
      NULL,
      41,
      NULL,
      0,
      NULL,
      '3442',
      '04420',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      27,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.815858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      100.699384,
      1.878478,
      NULL,
      1,
      1,
      1,
      0.773163,
      1.902392,
      NULL,
      1.676267,
      3,
      1,
      NULL,
      0,
      0.160519,
      0.937418,
      1,
      0.931863,
      1.597128,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.716130,
      NULL,
      1.740586,
      NULL,
      NULL,
      NULL,
      1.796317,
      NULL,
      NULL,
      NULL,
      1.152992,
      NULL,
      NULL,
      0.510594,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.808888,
      NULL,
      1.171516,
      NULL,
      0.653013,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.935181,
      NULL,
      0.085852,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.753292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255791,
      1,
      0,
      NULL,
      NULL,
      1,
      0.985345,
      1.033362,
      1.182225,
      3.789901,
      2,
      1.915930,
      1,
      1.499358,
      NULL,
      1,
      NULL,
      NULL,
      1.164794,
      NULL,
      NULL,
      0,
      1.698170,
      NULL,
      NULL,
      0,
      NULL,
      0.997729,
      1.601247,
      NULL,
      0.433850,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.878635,
      NULL,
      0.616493,
      3.385293,
      NULL,
      0.999157,
      1,
      NULL,
      2,
      0.186862,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.865104,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      35,
      NULL,
      0,
      5.140076,
      2.032927,
      '2244',
      '23131',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


