set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2302334',
      3,
      1.937935,
      2,
      0,
      '1013',
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      3.724282,
      NULL,
      NULL,
      NULL,
      303.469905,
      52,
      2,
      ' 8-24-1986',
      ' 7-13-1983',
      ' 0-23-1982',
      0.610304,
      NULL,
      NULL,
      0.442404,
      0,
      NULL,
      2.694875,
      1,
      NULL,
      NULL,
      NULL,
      0.639499,
      2.143929,
      16.220285,
      NULL,
      4.265425,
      8.184189,
      2.758678,
      7.788305,
      2.710447,
      1.757614,
      0,
      1.141541,
      NULL,
      1,
      0,
      0.508164,
      0.023830,
      0,
      0,
      0.023782,
      0.654860,
      2,
      NULL,
      NULL,
      2.650455,
      NULL,
      0,
      3,
      0,
      0,
      4,
      NULL,
      0.614904,
      0.974483,
      NULL,
      3,
      3,
      0.315651,
      NULL,
      0,
      2.846029,
      1,
      NULL,
      NULL,
      1.715212,
      NULL,
      NULL,
      NULL,
      3.447818,
      0.296056,
      0,
      1,
      0,
      1,
      0,
      0.135201,
      NULL,
      0.344068,
      2,
      3,
      NULL,
      0,
      2,
      1.862092,
      0.168060,
      1,
      3.144836,
      0.296358,
      0.393005,
      7.540294,
      0,
      3.722829,
      NULL,
      1,
      NULL,
      NULL,
      1.625955,
      NULL,
      NULL,
      1.413140,
      0.990733,
      4.118963,
      1,
      3.605260,
      NULL,
      2,
      1.412372,
      1.831854,
      0.571620,
      NULL,
      1,
      1,
      2.392713,
      1.143742,
      0.654774,
      NULL,
      0.698426,
      1,
      NULL,
      0.939873,
      NULL,
      NULL,
      NULL,
      1,
      1.156245,
      1.474378,
      7.670525,
      1,
      1.721493,
      1.782360,
      2.605333,
      3.917674,
      5.137337,
      3,
      5,
      NULL,
      5.591754,
      5,
      NULL,
      3,
      2.427737,
      NULL,
      0,
      0.880813,
      11.786523,
      NULL,
      NULL,
      ' 2-15-1993',
      11,
      ' 0-21-1979',
      12.277113,
      1.350498,
      0.078610,
      0.445766,
      1.837585,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492115,
      NULL,
      1,
      3,
      NULL,
      1.588244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.614421,
      2.737631,
      1,
      NULL,
      1.256301,
      5,
      1,
      1,
      1,
      1.347427,
      0.140687,
      1.317977,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.532964,
      NULL,
      NULL,
      NULL,
      21,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.456496,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      3.080126,
      3.192274,
      NULL,
      3,
      3.181751,
      NULL,
      1,
      NULL,
      1,
      4.534736,
      NULL,
      1,
      NULL,
      0,
      1.482779,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.394969,
      NULL,
      2,
      7,
      6.822254,
      NULL,
      5,
      0.515798,
      NULL,
      3.145390,
      1,
      1,
      NULL,
      0.921981,
      3.257798,
      2.747604,
      NULL,
      1,
      9.886788,
      69,
      1,
      1,
      1,
      '01132',
      '34331',
      '',
      0,
      '',
      '',
      NULL,
      0.710960,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406550,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.730754,
      NULL,
      NULL,
      0.427573,
      NULL,
      0.213007,
      16,
      37.921646,
      2,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.677123,
      0,
      0,
      0.643530,
      1.009820,
      0,
      0.113044,
      1.465652,
      1,
      3.862868,
      NULL,
      0.823110,
      NULL,
      0,
      NULL,
      1.184306,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.717504,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.341492,
      NULL,
      1.292508,
      NULL,
      0.053549,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.142554,
      NULL,
      1,
      NULL,
      1.363182,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.772596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959600,
      1.503023,
      3.307673,
      10.789236,
      3,
      1,
      1,
      0.941215,
      3,
      3,
      1,
      2,
      0,
      1.165234,
      1,
      1,
      1,
      1.382690,
      0.515274,
      1,
      0.824896,
      0.871232,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0.503823,
      0,
      1,
      1,
      1.489930,
      0.419137,
      NULL,
      1.505802,
      1,
      1,
      1.919533,
      0.873940,
      1.764462,
      NULL,
      2.383805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887792,
      1,
      1,
      NULL,
      0.073057,
      NULL,
      NULL,
      6,
      NULL,
      1.295451,
      NULL,
      NULL,
      54.157603,
      83.930902,
      1.089412,
      5.429055,
      4,
      '03434',
      '40102',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


