set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845877';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      1.882763,
      NULL,
      0,
      1,
      0,
      NULL,
      '022',
      '22012312',
      70.910464,
      64.543860,
      '2222441',
      0.153403,
      1,
      0,
      0,
      '0304',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      129.755537,
      66.942052,
      NULL,
      3,
      2.889527,
      '11-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-11-1995',
      NULL,
      NULL,
      0,
      1,
      3.058661,
      2,
      0,
      3,
      3.337294,
      3,
      NULL,
      NULL,
      NULL,
      7,
      1.884373,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0.779853,
      0,
      1.019689,
      NULL,
      0,
      0.906699,
      0.969492,
      2,
      NULL,
      5,
      0,
      0.991345,
      NULL,
      1,
      NULL,
      2,
      0,
      2.351228,
      0,
      0,
      3,
      8.835226,
      0,
      4.772149,
      0,
      1,
      0,
      NULL,
      NULL,
      1.330084,
      NULL,
      NULL,
      6.682316,
      0,
      3,
      3,
      0,
      0.672477,
      1,
      3.275505,
      NULL,
      1.278472,
      1,
      0,
      NULL,
      1.864612,
      3.033364,
      0,
      1.850462,
      3,
      3,
      5,
      0.124331,
      1.305375,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      1.436206,
      NULL,
      NULL,
      0,
      3.033613,
      4,
      0,
      7.088035,
      NULL,
      4.709945,
      0.820020,
      1,
      0.744366,
      1.625371,
      3.144370,
      1.683564,
      NULL,
      1.108663,
      NULL,
      0.578565,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.689282,
      2.016344,
      6,
      NULL,
      1,
      0.304719,
      1,
      1,
      2,
      7,
      1.016755,
      1.230961,
      11.075025,
      0.879573,
      6,
      1,
      5.403009,
      5,
      6,
      5.650593,
      11.663209,
      4.283804,
      6.580427,
      7,
      NULL,
      NULL,
      ' 0-18-2003',
      461,
      NULL,
      125.056192,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.259061,
      0.111394,
      0,
      1.380055,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.286942,
      1.204964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      8.380991,
      1,
      NULL,
      NULL,
      NULL,
      0.239736,
      0.880840,
      1.425069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.132110,
      0.453023,
      0,
      1.228562,
      1.472725,
      2,
      7.731708,
      NULL,
      NULL,
      25,
      49,
      1,
      NULL,
      0.796609,
      1.682271,
      2.772782,
      0,
      NULL,
      3,
      3,
      2,
      2.100953,
      1,
      1,
      1.442792,
      2,
      NULL,
      3.520332,
      0.533737,
      1,
      1,
      3,
      NULL,
      0.383213,
      1.238804,
      0,
      0,
      1.522051,
      1.394253,
      1.361101,
      0,
      1.616508,
      2.713815,
      0,
      9.155085,
      9,
      0,
      0.080399,
      NULL,
      7.206238,
      NULL,
      2,
      2.373139,
      1,
      1,
      0,
      26.029465,
      NULL,
      3.021839,
      67.450749,
      NULL,
      44,
      4,
      5,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.755352,
      NULL,
      '',
      NULL,
      3.421047,
      15,
      NULL,
      7.934482,
      1,
      9,
      3.897990,
      1.718961,
      5.408818,
      0,
      NULL,
      1,
      1.077657,
      NULL,
      NULL,
      1.145536,
      NULL,
      NULL,
      NULL,
      0.996835,
      3,
      0.138582,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      1.087190,
      0,
      0,
      NULL,
      NULL,
      1.719436,
      1.407569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.567072,
      0.548559,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.589565,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892256,
      1,
      1.524176,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2.684741,
      1,
      1.794714,
      NULL,
      0,
      1.148506,
      0.625642,
      3.636608,
      0,
      0.673665,
      1,
      0,
      0.013253,
      3,
      3.415903,
      1,
      NULL,
      0.990026,
      2,
      NULL,
      NULL,
      NULL,
      2.114133,
      0,
      0.494531,
      5.179136,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.713762,
      0,
      NULL,
      0,
      NULL,
      NULL,
      6.528078,
      NULL,
      6,
      1,
      0.751338,
      1.889302,
      1.265658,
      NULL,
      NULL,
      3.623275,
      NULL,
      0.302715,
      0,
      NULL,
      NULL,
      0.855321,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.440865,
      3,
      0.878736,
      NULL,
      NULL,
      1.372774,
      NULL,
      NULL,
      2.789500,
      1.645074,
      3,
      3,
      NULL,
      4.283962,
      2,
      NULL,
      5,
      6.496052,
      1.732252,
      6,
      0,
      NULL,
      NULL,
      2.567759,
      0,
      2.746551,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2.899227,
      2.785313,
      NULL,
      2.405919,
      3,
      0,
      2.908440,
      NULL,
      NULL,
      4.539199,
      NULL,
      1,
      3.058406,
      5.938055,
      3.397546,
      3.102707,
      7,
      0.669854,
      1.604369,
      1,
      NULL,
      1,
      3.282674,
      NULL,
      NULL,
      0.295827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038016,
      NULL,
      NULL,
      0.396620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.749503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484369,
      NULL,
      NULL,
      2.130376,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      5.816202,
      NULL,
      NULL,
      NULL,
      122.183541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.036293,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.137896,
      51,
      NULL,
      2.390254,
      2.685897,
      NULL,
      1,
      NULL,
      NULL,
      1.179086,
      NULL,
      NULL,
      0.051493,
      NULL,
      NULL,
      0.146642,
      NULL,
      NULL,
      0,
      NULL,
      1.860000,
      1,
      5.535579,
      1,
      0.312601,
      1.316760,
      1,
      1.349134,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1.927221,
      1.328492,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.034671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366349,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223198,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.203761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.636816,
      1.235308,
      1.113822,
      0,
      0.250978,
      NULL,
      NULL,
      1,
      1.675742,
      1,
      1.159628,
      1,
      0.003122,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337198,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055573,
      1,
      15,
      1.854801,
      2.709840,
      0.082209,
      1.636245,
      1,
      NULL,
      1,
      3.749372,
      NULL,
      NULL,
      0.025508,
      NULL,
      1.310572,
      0,
      NULL,
      1,
      2.424179,
      NULL,
      NULL,
      0.664363,
      NULL,
      3.300066,
      2.165662,
      NULL,
      NULL,
      1.730420,
      NULL,
      0,
      0,
      NULL,
      1.704180,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.179697,
      NULL,
      6,
      1,
      1.404249,
      3,
      1.633305,
      2.661481,
      5,
      40.254201,
      4,
      0,
      4.066445,
      NULL,
      '44120',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


