set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2222343',
      1,
      1.112470,
      0,
      0,
      '0413',
      0.892745,
      0.033604,
      NULL,
      NULL,
      ' 4- 2-2000',
      115.580154,
      NULL,
      2.584909,
      3,
      1,
      ' 3- 2-1983',
      30.463365,
      1.872472,
      238.723645,
      34.296477,
      5.159838,
      NULL,
      NULL,
      ' 1-25-1979',
      1.938939,
      0.820040,
      1.685968,
      1,
      1.874834,
      1.280289,
      NULL,
      1.189747,
      NULL,
      NULL,
      NULL,
      8,
      3,
      NULL,
      22.061597,
      NULL,
      11.869624,
      0.972961,
      5,
      1,
      0.356717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7.564442,
      2.084716,
      1,
      0.764143,
      1.157313,
      0.344344,
      0.488245,
      0,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.150516,
      1.352860,
      1.563615,
      0,
      1,
      NULL,
      NULL,
      1.281707,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.854530,
      NULL,
      1,
      1,
      0,
      0.528032,
      0,
      NULL,
      0.432326,
      1,
      0.455768,
      1.174903,
      1.702903,
      1,
      0,
      0.475050,
      1,
      2,
      0,
      0.129918,
      1.005586,
      0.172112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939997,
      0.976942,
      0.171984,
      1.991272,
      1.484243,
      1,
      NULL,
      NULL,
      0,
      0.497587,
      0,
      NULL,
      0.570777,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1.760869,
      2.735404,
      NULL,
      NULL,
      1.532928,
      1.046360,
      2,
      0,
      NULL,
      0,
      1,
      0.881471,
      1.426571,
      4,
      1.100017,
      1.327305,
      1,
      0.626833,
      0,
      0.385261,
      1,
      0,
      0,
      1.706203,
      4,
      1.847281,
      0,
      1.427043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339629,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036485,
      0.668827,
      1.816658,
      NULL,
      1,
      1,
      NULL,
      1.146691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808854,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.101152,
      4.560016,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.639698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.042196,
      1,
      0,
      0.154877,
      1.516429,
      0.857821,
      1,
      NULL,
      NULL,
      1.845231,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.645899,
      NULL,
      2,
      2,
      0,
      NULL,
      3,
      2.930387,
      1.216573,
      3.287607,
      1.549415,
      1.650164,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.090192,
      0.248743,
      0.492064,
      NULL,
      NULL,
      0.669281,
      1,
      1.841669,
      2.691819,
      1.204023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      4.364327,
      1,
      0,
      '02121',
      '40223',
      '',
      1.009022,
      '',
      NULL,
      '',
      NULL,
      '1042',
      '',
      NULL,
      1,
      24.231416,
      NULL,
      5.212492,
      NULL,
      3.898889,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.112167,
      1.971222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.760389,
      0.254830,
      1.937477,
      NULL,
      NULL,
      1,
      0.121080,
      1.326936,
      0.822019,
      NULL,
      NULL,
      2.645333,
      NULL,
      0.094209,
      1.062930,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.150951,
      NULL,
      NULL,
      2.878014,
      2,
      0,
      0.011979,
      1.656411,
      NULL,
      NULL,
      NULL,
      3,
      1.712112,
      NULL,
      16.693300,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953391,
      0.700927,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1.062380,
      1.940858,
      1,
      NULL,
      0,
      0.360709,
      0,
      NULL,
      1.032959,
      NULL,
      NULL,
      3.692544,
      0.885530,
      1,
      NULL,
      NULL,
      NULL,
      3.175393,
      3,
      1,
      3.024309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.687382,
      0.932686,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.784786,
      1.674446,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.287484,
      NULL,
      NULL,
      1.188796,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.109742,
      3.522378,
      0,
      NULL,
      NULL,
      NULL,
      1.238215,
      NULL,
      NULL,
      3.334307,
      2.062771,
      3.427662,
      5.704025,
      0.357306,
      0.575008,
      1,
      2.914158,
      NULL,
      2.373481,
      1.837982,
      0,
      0.262121,
      2,
      0.302864,
      NULL,
      6,
      5.992335,
      2,
      1.855941,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.809675,
      0.005276,
      2.742478,
      3,
      0.887921,
      0.887812,
      6,
      0.628131,
      NULL,
      1.302590,
      1,
      2.016638,
      1,
      3.758798,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.463728,
      2.269150,
      2.985884,
      2.239905,
      NULL,
      3,
      NULL,
      2.317722,
      NULL,
      1,
      3.656140,
      38.843093,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.502282,
      NULL,
      NULL,
      NULL,
      1.403053,
      NULL,
      2.805659,
      1,
      NULL,
      NULL,
      3.226532,
      NULL,
      1.366570,
      NULL,
      0.905523,
      NULL,
      2.709346,
      NULL,
      NULL,
      1,
      3.749471,
      NULL,
      1.579977,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.490351,
      NULL,
      NULL,
      NULL,
      0.319003,
      NULL,
      0,
      NULL,
      0.812816,
      1.598747,
      0.918045,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.764120,
      1.873063,
      3,
      NULL,
      1.283899,
      NULL,
      1,
      NULL,
      NULL,
      0.944023,
      0.682051,
      NULL,
      1,
      NULL,
      9,
      NULL,
      3,
      NULL,
      1.700518,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.038576,
      74.775142,
      47.364482,
      1,
      NULL,
      3,
      1.922597,
      NULL,
      NULL,
      0.977149,
      NULL,
      NULL,
      1.286195,
      NULL,
      NULL,
      1.962208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      14.807266,
      1,
      1.535496,
      1,
      0,
      NULL,
      0,
      0,
      0.530425,
      1.390186,
      0,
      NULL,
      2,
      0.779058,
      0.881257,
      1.968627,
      NULL,
      0.149502,
      1.138472,
      NULL,
      1.394850,
      NULL,
      0.703140,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      2.656385,
      41.868861,
      51.654509,
      0,
      NULL,
      NULL,
      NULL,
      1.092798,
      NULL,
      0.402865,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.519260,
      NULL,
      1.505176,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925500,
      NULL,
      1.021592,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.570124,
      1,
      1.343831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.401318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083907,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427026,
      2.134853,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.707826,
      NULL,
      0.153231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.341144,
      5,
      13,
      1.248320,
      2.521844,
      3,
      NULL,
      4,
      2,
      1.237521,
      3,
      1,
      NULL,
      NULL,
      1,
      3.971793,
      1,
      1,
      2.882309,
      0,
      2.003936,
      14,
      1.445980,
      NULL,
      1,
      NULL,
      1.648940,
      3.268526,
      3,
      1.880656,
      1.193560,
      0.323064,
      3.824442,
      0,
      NULL,
      0,
      NULL,
      1.774314,
      1.635942,
      2,
      1,
      0,
      NULL,
      NULL,
      0.751699,
      2.569078,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149846,
      0,
      1,
      0.489813,
      NULL,
      1.846077,
      1.425834,
      5.360919,
      4.420427,
      1.518455,
      NULL,
      NULL,
      83.886856,
      93.528338,
      2.355723,
      0.388482,
      1.816488,
      NULL,
      '04141',
      '',
      NULL,
      '20232',
      '',
      '',
      NULL,
      '0022',
      '0423',
      NULL);
commit;
end;
/


