set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8514320';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      '0223',
      1,
      1,
      NULL,
      NULL,
      ' 6-28-1980',
      3.735335,
      NULL,
      NULL,
      3,
      1.839442,
      ' 0-12-1977',
      32,
      1,
      151.699136,
      NULL,
      1,
      ' 3-21-1979',
      ' 6-29-1983',
      ' 2-26-1977',
      0.771026,
      NULL,
      0.085838,
      1.910435,
      1.543080,
      NULL,
      9.694526,
      0,
      NULL,
      246.264694,
      NULL,
      14.561963,
      2.110669,
      7,
      129.702344,
      12,
      17,
      17.630159,
      12.256062,
      9,
      0.589083,
      1,
      1,
      0,
      NULL,
      NULL,
      1.562544,
      0.316099,
      3,
      0,
      1.461486,
      0.728619,
      NULL,
      NULL,
      NULL,
      8,
      0.099297,
      NULL,
      5.195881,
      0.478770,
      5.407432,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      7.096354,
      0.989004,
      3,
      NULL,
      0.344784,
      1,
      NULL,
      NULL,
      1.351724,
      NULL,
      NULL,
      2,
      0,
      0,
      0.536467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986020,
      0.005217,
      0,
      3.942232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029903,
      2.545002,
      NULL,
      1,
      2,
      2,
      1,
      0,
      0.881974,
      0.225804,
      NULL,
      1.651348,
      0.126407,
      NULL,
      0,
      NULL,
      0.076702,
      1,
      0,
      NULL,
      NULL,
      2,
      0.450274,
      1,
      1.636025,
      1.571186,
      NULL,
      1.404647,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957981,
      0.511699,
      NULL,
      4.901376,
      6.765043,
      9,
      0,
      4,
      7.757733,
      6.373132,
      3.720936,
      NULL,
      3,
      1,
      ' 0-13-1992',
      NULL,
      ' 1-15-1987',
      475.868553,
      2.302180,
      NULL,
      1.858048,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.762703,
      1,
      NULL,
      5,
      0.180633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.375529,
      NULL,
      0.094824,
      1.378497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.926885,
      0,
      NULL,
      0.861604,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421957,
      0,
      1.301001,
      0.494406,
      NULL,
      0,
      NULL,
      1.789288,
      38,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.317823,
      3.720902,
      4,
      0.542509,
      7.901363,
      4,
      4.258702,
      1,
      1.697978,
      1.991757,
      2,
      NULL,
      46.811325,
      3,
      0,
      NULL,
      3.548860,
      3,
      57,
      1,
      0.734847,
      1.572641,
      '24314',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.513408,
      28,
      269,
      1.550500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726461,
      12,
      3.263281,
      1.174270,
      NULL,
      NULL,
      1.013050,
      NULL,
      NULL,
      1.912809,
      7,
      3,
      NULL,
      0.666270,
      7,
      1.591865,
      NULL,
      NULL,
      0.519451,
      9,
      12,
      NULL,
      NULL,
      NULL,
      1.202439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.053103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      0.979554,
      3.975143,
      0,
      0.177733,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      16.501672,
      NULL,
      1.159709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.805236,
      1.961111,
      0,
      0.121365,
      NULL,
      1.155165,
      1.447354,
      0.386871,
      NULL,
      0,
      NULL,
      1,
      0,
      1.650421,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635216,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.529602,
      1.162477,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.928365,
      16,
      13.880964,
      1.170927,
      11,
      NULL,
      NULL,
      11.998233,
      17,
      0,
      NULL,
      NULL,
      5.801739,
      1.354109,
      2,
      1,
      NULL,
      NULL,
      0.026015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.914456,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.586525,
      0.909283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.604451,
      9.709694,
      NULL,
      1,
      15.189600,
      NULL,
      2.154797,
      NULL,
      3,
      1.425020,
      2.754000,
      2.987361,
      3,
      3,
      9,
      0.346483,
      NULL,
      NULL,
      NULL,
      3.327343,
      NULL,
      0.485703,
      1,
      1.300876,
      0.864968,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.735859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.982301,
      NULL,
      NULL,
      1.875802,
      1.699751,
      0.213003,
      0,
      1.527115,
      3.470785,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.930952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.532647,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718326,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.680543,
      NULL,
      NULL,
      0.560731,
      NULL,
      0.272565,
      9285,
      510,
      NULL,
      NULL,
      1,
      1.455566,
      0.810338,
      1.457797,
      NULL,
      0.888785,
      1.847175,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.492274,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620164,
      NULL,
      NULL,
      4,
      NULL,
      11.739311,
      1.276088,
      NULL,
      16.978720,
      8,
      NULL,
      NULL,
      6,
      NULL,
      17.325660,
      19,
      NULL,
      5.439435,
      18.868550,
      NULL,
      1,
      6.252697,
      NULL,
      12,
      16.746334,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      17.434123,
      NULL,
      5,
      NULL,
      NULL,
      2.041325,
      1.858528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474904,
      NULL,
      NULL,
      NULL,
      0.437472,
      NULL,
      4,
      1.252937,
      NULL,
      1,
      0.713267,
      3.995117,
      NULL,
      46.489977,
      5.199252,
      0,
      3,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.795026,
      NULL,
      NULL,
      '');
commit;
end;
/


