set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9892585';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      4.922995,
      5,
      3.398973,
      2,
      0.626864,
      0.911734,
      NULL,
      '303',
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      '1044',
      1.152204,
      0,
      NULL,
      NULL,
      ' 9-11-1984',
      NULL,
      27.253647,
      NULL,
      2,
      1,
      '10-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      1.335499,
      NULL,
      NULL,
      ' 7- 4-1991',
      0.789556,
      1.509191,
      1.135203,
      1,
      NULL,
      0,
      1,
      1,
      0,
      6.213377,
      4.387063,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1,
      NULL,
      1.658454,
      NULL,
      0,
      1.572767,
      NULL,
      0.955011,
      1,
      0,
      NULL,
      3.203097,
      2.954670,
      0.629264,
      0.970451,
      5.207085,
      1,
      0,
      NULL,
      2,
      8.386485,
      NULL,
      0.444870,
      1.951544,
      1,
      0,
      NULL,
      7,
      0.113006,
      2.607290,
      3,
      0.665409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981353,
      0,
      0.990600,
      0.278084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      5,
      NULL,
      1,
      1,
      NULL,
      0.066494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.982794,
      4.498636,
      NULL,
      1.256436,
      1,
      1.060755,
      1,
      NULL,
      1,
      1.076560,
      2.540240,
      0,
      0,
      0,
      1.243183,
      0.511555,
      NULL,
      0,
      3.901763,
      1.218648,
      0.704676,
      1.738674,
      0,
      0.877688,
      6.506722,
      2.595835,
      2,
      5.468549,
      2,
      0.416966,
      1,
      0,
      2.071326,
      8.388131,
      0,
      NULL,
      4,
      5.908833,
      NULL,
      2,
      5,
      3.508813,
      0.394695,
      NULL,
      0.389701,
      ' 9-16-1993',
      68,
      ' 3-21-1993',
      NULL,
      3,
      NULL,
      0.949399,
      5.791815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239567,
      0.553343,
      NULL,
      1,
      4.992009,
      1.213822,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742091,
      NULL,
      NULL,
      NULL,
      NULL,
      3.966703,
      0.784225,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624850,
      NULL,
      10,
      0,
      1,
      5.969933,
      0.747996,
      NULL,
      NULL,
      NULL,
      1.945394,
      6,
      0.939652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.455643,
      1,
      1,
      0.575397,
      0.880746,
      1.754955,
      1,
      1.251312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171595,
      2,
      0,
      3.247456,
      2,
      0,
      3,
      3.827189,
      0,
      3,
      2.983469,
      2.050528,
      5.772273,
      NULL,
      1,
      0,
      0.021562,
      3.058913,
      3,
      1,
      1,
      1,
      1.331993,
      1,
      0.662002,
      1,
      1,
      2.163369,
      3,
      0.976093,
      1.077688,
      6,
      NULL,
      1.273711,
      NULL,
      1,
      5,
      2.551014,
      5,
      2,
      1.864683,
      NULL,
      68,
      3.506086,
      1.353828,
      15.793022,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.949878,
      '40111',
      NULL,
      '',
      1.182115,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      14,
      54,
      8.392063,
      1,
      24,
      7,
      0.184715,
      1,
      3,
      2.106350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348617,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.216181,
      NULL,
      NULL,
      NULL,
      0.594641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366810,
      NULL,
      NULL,
      11.673660,
      11,
      1.289294,
      0.707779,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.677932,
      3,
      NULL,
      NULL,
      3,
      2,
      2,
      0.732030,
      NULL,
      1.169101,
      NULL,
      NULL,
      1,
      3,
      2.314926,
      0,
      0,
      1,
      2,
      0.869016,
      2.625477,
      0,
      3.976660,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      2,
      3.918415,
      3,
      3,
      NULL,
      0,
      1.322913,
      NULL,
      NULL,
      NULL,
      1.431051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.753230,
      3,
      1.754287,
      NULL,
      3.704907,
      1.061634,
      0,
      2,
      3,
      1,
      1,
      2,
      NULL,
      NULL,
      1.896470,
      NULL,
      1,
      NULL,
      5.630628,
      0.150952,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.891130,
      1.662910,
      NULL,
      2.102411,
      NULL,
      NULL,
      2,
      8.713366,
      5,
      9,
      2,
      4,
      0,
      NULL,
      NULL,
      1,
      0.517215,
      1.173452,
      1.175509,
      3,
      3.986763,
      0,
      0,
      1.189052,
      NULL,
      7,
      8.011475,
      3.987667,
      3.018183,
      3.187055,
      NULL,
      2.867642,
      NULL,
      2.514945,
      NULL,
      NULL,
      1,
      NULL,
      0.517258,
      7,
      10,
      1.982993,
      7,
      7.136533,
      3.986142,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962988,
      0,
      1,
      NULL,
      0.156270,
      NULL,
      NULL,
      0.457708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.454493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.469721,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.608993,
      NULL,
      NULL,
      0.059042,
      1,
      0.746079,
      1.402736,
      0,
      1.003736,
      1.198482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.608280,
      NULL,
      NULL,
      NULL,
      1.532362,
      NULL,
      NULL,
      NULL,
      0.182395,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.166693,
      NULL,
      NULL,
      NULL,
      1.276706,
      NULL,
      NULL,
      NULL,
      0.567348,
      NULL,
      NULL,
      NULL,
      1.500304,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.416738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058927,
      NULL,
      NULL,
      NULL,
      0.258618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.706602,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      20,
      5.985122,
      3,
      7.118438,
      7,
      0,
      NULL,
      NULL,
      NULL,
      1.150898,
      1.977356,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.522130,
      NULL,
      0.853472,
      1.641332,
      1,
      1.925087,
      0,
      0,
      1,
      1,
      1.534342,
      1,
      1.049426,
      1.216545,
      NULL,
      1,
      0.250051,
      1.255689,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.330416,
      NULL,
      3,
      2.295127,
      7,
      0.892765,
      0.918878,
      3,
      1.812840,
      NULL,
      NULL,
      1,
      1.203053,
      1.353392,
      NULL,
      NULL,
      1.658438,
      NULL,
      NULL,
      1,
      NULL,
      0.632942,
      0,
      NULL,
      1.270138,
      0,
      NULL,
      0.032009,
      0.377294,
      NULL,
      0.114409,
      3.853834,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2.014636,
      1.689119,
      NULL,
      1.820245,
      3,
      NULL,
      NULL,
      1.917806,
      1.658423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711562,
      NULL,
      0.437503,
      NULL,
      NULL,
      1.817388,
      5,
      NULL,
      1,
      NULL,
      15.147428,
      107,
      NULL,
      2.806978,
      3,
      '02012',
      '',
      NULL,
      0.117787,
      NULL,
      '',
      '',
      1.485294,
      '',
      NULL,
      '');
commit;
end;
/


