set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2123234',
      3,
      1.400867,
      6,
      2,
      '1241',
      3.499536,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1996',
      55,
      NULL,
      3.966323,
      0.622164,
      NULL,
      ' 6-19-1994',
      12,
      NULL,
      65,
      19.635021,
      3.551700,
      ' 1- 8-1983',
      '11-10-1974',
      NULL,
      3.225336,
      NULL,
      NULL,
      0.950906,
      1.453729,
      NULL,
      NULL,
      1.821318,
      0,
      8,
      1,
      0.847601,
      2,
      19,
      11,
      5.120848,
      13,
      NULL,
      3,
      NULL,
      0.599765,
      1.154261,
      0,
      0.372213,
      1.111990,
      0.691254,
      1.442213,
      1,
      0,
      0.073419,
      0.291615,
      1.354619,
      3.802440,
      NULL,
      NULL,
      1.481375,
      0.186033,
      0.121198,
      0,
      1,
      0.242520,
      NULL,
      1.165490,
      0.107336,
      0.653410,
      0,
      1,
      1.464562,
      NULL,
      NULL,
      NULL,
      0.683677,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317611,
      0,
      1,
      0.310507,
      1,
      1.919450,
      0.834990,
      1.934879,
      3,
      2.186776,
      NULL,
      2.815546,
      2.729954,
      NULL,
      1.357282,
      0.642053,
      1,
      NULL,
      1.161713,
      1,
      0.503001,
      9,
      1,
      NULL,
      1.467367,
      0.425033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040304,
      NULL,
      NULL,
      2.332800,
      5,
      0,
      1,
      NULL,
      1,
      0.544668,
      1,
      NULL,
      NULL,
      1,
      1,
      1.098906,
      NULL,
      1.742177,
      0,
      NULL,
      0.854854,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.016227,
      0.485846,
      0,
      NULL,
      8.345526,
      3,
      8.375903,
      NULL,
      5.402646,
      NULL,
      0.860753,
      4.964377,
      3,
      NULL,
      0,
      3.673770,
      NULL,
      4.928418,
      NULL,
      6.314695,
      3.859976,
      ' 1-16-1996',
      NULL,
      ' 1-16-1985',
      NULL,
      3.169033,
      3,
      0.353570,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.438920,
      0.398378,
      1,
      2.850135,
      1.423348,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.583276,
      5.743778,
      1,
      0,
      2.537709,
      1.723278,
      1,
      3.319777,
      0.702842,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254789,
      NULL,
      1.075736,
      0.524593,
      0,
      5,
      7,
      NULL,
      NULL,
      NULL,
      0.741120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233633,
      1,
      0.751287,
      1,
      0.433246,
      1,
      1,
      1.247031,
      NULL,
      1.341948,
      0,
      NULL,
      NULL,
      NULL,
      0.990291,
      1.878967,
      0,
      1,
      3,
      NULL,
      3,
      2,
      1,
      2.300919,
      1.658290,
      3,
      0,
      0.750590,
      3.530817,
      1,
      0.515645,
      1,
      1,
      NULL,
      1.055847,
      1,
      1,
      0.499104,
      1,
      0,
      0,
      1.406769,
      NULL,
      NULL,
      3.167024,
      1.130063,
      11.622408,
      3.260625,
      7.768579,
      9,
      NULL,
      5,
      3.072631,
      2,
      3,
      NULL,
      1,
      2.836143,
      62.389237,
      3,
      NULL,
      NULL,
      32,
      25,
      21,
      2,
      5,
      NULL,
      '0312',
      '',
      '',
      2.330372,
      '30004',
      '',
      '',
      1.204530,
      '',
      '',
      '',
      2.658363,
      10.604296,
      46.280373,
      0.829074,
      NULL,
      26.823111,
      1.147518,
      6.568257,
      1.285077,
      0.499696,
      1.018348,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.395553,
      1,
      1.038364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.278071,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.971308,
      NULL,
      NULL,
      0.499938,
      NULL,
      NULL,
      3.114941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.288272,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.821380,
      NULL,
      1,
      0,
      1.862068,
      1.480025,
      1.675839,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.269007,
      0.801090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.719770,
      NULL,
      NULL,
      8,
      9,
      1.650493,
      1.785092,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.584845,
      NULL,
      NULL,
      NULL,
      0.514163,
      NULL,
      NULL,
      0.067718,
      NULL,
      1.819668,
      1,
      NULL,
      NULL,
      7.896022,
      5,
      0,
      0,
      NULL,
      NULL,
      1.200035,
      NULL,
      NULL,
      0.158673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.478836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732258,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.688683,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      2.985770,
      3,
      0.981540,
      NULL,
      3,
      1,
      0,
      3.393185,
      2,
      1.993012,
      NULL,
      3,
      3.209568,
      NULL,
      1.618264,
      0.785142,
      NULL,
      NULL,
      1.524212,
      3,
      NULL,
      3.933456,
      NULL,
      3,
      8.853367,
      5,
      4.744427,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      1.724314,
      1.226538,
      0.122364,
      0.473376,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.560503,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.648204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.875735,
      1,
      NULL,
      0,
      0.373774,
      NULL,
      2.792139,
      NULL,
      3.352413,
      29.798314,
      NULL,
      NULL,
      NULL,
      3.110712,
      0.035818,
      NULL,
      2.699903,
      3,
      NULL,
      NULL,
      1,
      17.081496,
      16.141483,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.788290,
      0.024725,
      NULL,
      0,
      1.270003,
      1.498677,
      NULL,
      0,
      NULL,
      1.080440,
      NULL,
      1.251759,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.642921,
      0.593417,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.279412,
      2.789438,
      NULL,
      NULL,
      0.290375,
      3.469354,
      1,
      NULL,
      2.467394,
      3.993403,
      1,
      NULL,
      2,
      1.455054,
      1,
      NULL,
      2,
      2.165944,
      9.294504,
      NULL,
      7,
      NULL,
      2.555663,
      NULL,
      2,
      7.784096,
      4,
      1,
      17,
      5,
      2,
      0,
      1,
      2.753878,
      1.677346,
      1.014519,
      NULL,
      NULL,
      NULL,
      3.904794,
      1.116686,
      1.256724,
      1.749544,
      NULL,
      NULL,
      0,
      NULL,
      0.605524,
      33,
      NULL,
      0,
      3,
      1.162352,
      1,
      1,
      0,
      1.533359,
      NULL,
      0.281382,
      1,
      1.160101,
      NULL,
      0,
      0,
      0.942132,
      0.835597,
      1.052402,
      NULL,
      NULL,
      0,
      NULL,
      1.518964,
      NULL,
      1.766212,
      NULL,
      1.129662,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.095200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878237,
      3,
      1.096238,
      0,
      2.390264,
      3,
      NULL,
      NULL,
      3,
      2,
      2.432501,
      1.546233,
      0.686812,
      0,
      0,
      1.314587,
      0,
      1,
      0.806982,
      1.234634,
      0,
      0.760875,
      1.864323,
      NULL,
      NULL,
      1.999470,
      NULL,
      NULL,
      2.039876,
      1,
      0,
      1,
      2.098188,
      3.711699,
      0,
      NULL,
      NULL,
      1.095205,
      NULL,
      2.361688,
      NULL,
      NULL,
      1,
      1,
      3,
      0.334304,
      1.623291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.099934,
      1.337433,
      3,
      NULL,
      0.037124,
      2,
      3,
      NULL,
      3,
      3.291041,
      3.707668,
      3,
      2.427381,
      3.798553,
      2.349686,
      3,
      0,
      3,
      1,
      1,
      0,
      1.576368,
      NULL,
      0.183134,
      3,
      57,
      3.614366,
      NULL,
      0,
      1,
      0.100145,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      74,
      23,
      5.344311,
      2.124474,
      3,
      '2324',
      '',
      '',
      2.588038,
      '42000',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


