set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4034030',
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.553796,
      NULL,
      NULL,
      ' 8-10-1977',
      NULL,
      NULL,
      NULL,
      3,
      3.791544,
      ' 3-14-1982',
      1.196372,
      NULL,
      192,
      92.089771,
      2,
      NULL,
      '10-15-1992',
      NULL,
      0,
      NULL,
      3.998321,
      2,
      0,
      NULL,
      3,
      1,
      1,
      3.270269,
      4,
      11.398535,
      3,
      13.060692,
      30,
      3,
      3.751782,
      1.595285,
      0.467452,
      4.649079,
      0.498011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      4.236977,
      5.666912,
      5,
      0.903921,
      4.788785,
      4.620514,
      0.283670,
      0,
      0.081315,
      NULL,
      NULL,
      1.698991,
      3.052900,
      0.148700,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.712686,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.261032,
      NULL,
      0.627830,
      1.674044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762301,
      1,
      1.351658,
      NULL,
      0,
      4.304349,
      1.212933,
      NULL,
      1.659665,
      5,
      3,
      NULL,
      1,
      3.083911,
      1,
      0,
      1.067200,
      NULL,
      1.014410,
      NULL,
      NULL,
      6,
      1,
      0,
      2.336853,
      NULL,
      3,
      NULL,
      NULL,
      2.829996,
      1.378477,
      0.765487,
      1.557361,
      0,
      7.784729,
      1,
      4,
      4.044229,
      1.422502,
      5.160492,
      1,
      0.552918,
      9,
      9.400646,
      NULL,
      1.982481,
      NULL,
      NULL,
      NULL,
      251,
      NULL,
      415,
      NULL,
      0.425453,
      0.865454,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.866321,
      1.819685,
      1.143505,
      0.722531,
      0.903121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239790,
      0,
      1,
      1,
      0.001038,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.941517,
      0,
      0.794142,
      NULL,
      0.325811,
      0.093990,
      3,
      14,
      0.053718,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.380264,
      NULL,
      3,
      2,
      2.103835,
      0,
      3,
      3,
      1.676964,
      1.362243,
      0,
      1,
      NULL,
      3.495524,
      5,
      0.475012,
      1.925504,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.945348,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      4.077061,
      NULL,
      8.741890,
      1,
      1,
      NULL,
      2,
      2,
      NULL,
      0,
      9.686043,
      NULL,
      3.199791,
      NULL,
      19,
      NULL,
      5,
      4,
      0.015353,
      3,
      '24310',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      62.672408,
      81,
      45,
      0,
      NULL,
      NULL,
      0,
      1.228236,
      3.050117,
      3,
      1.625501,
      1,
      NULL,
      NULL,
      0,
      0.341670,
      1.632534,
      3.871337,
      NULL,
      0.512255,
      NULL,
      1.048386,
      1,
      2.003435,
      0,
      1.378221,
      0,
      2.407708,
      0.256130,
      1.696812,
      NULL,
      1.891891,
      NULL,
      NULL,
      NULL,
      1.478393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      7,
      1.740469,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.238535,
      12.053995,
      6.795666,
      1.279041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.691126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389117,
      NULL,
      NULL,
      1.317886,
      NULL,
      NULL,
      1.113464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315189,
      NULL,
      NULL,
      NULL,
      0.974129,
      1.855701,
      2.634811,
      NULL,
      NULL,
      7,
      0,
      5,
      1.968677,
      13,
      NULL,
      0,
      NULL,
      NULL,
      3.612785,
      2,
      2.800952,
      1,
      NULL,
      NULL,
      0.895973,
      NULL,
      NULL,
      1.424642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414425,
      NULL,
      NULL,
      NULL,
      2,
      3.182366,
      0,
      NULL,
      NULL,
      0,
      2.666297,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4.461852,
      3,
      0,
      NULL,
      3,
      NULL,
      3,
      3.334283,
      2.749017,
      0,
      8,
      NULL,
      6.835464,
      NULL,
      2.342025,
      1.264741,
      2,
      0,
      3.168264,
      0.842852,
      2.869771,
      2.897780,
      2,
      2,
      3,
      NULL,
      0,
      9,
      2.919629,
      NULL,
      NULL,
      1,
      NULL,
      7.892180,
      0,
      0,
      1,
      0,
      0.939069,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.051125,
      NULL,
      NULL,
      1.752826,
      NULL,
      NULL,
      1.097849,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.756336,
      1.940803,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.942179,
      NULL,
      NULL,
      NULL,
      2.968263,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.347161,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11.209635,
      NULL,
      1,
      NULL,
      NULL,
      1.023526,
      NULL,
      NULL,
      0.074967,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061789,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.663780,
      0.921091,
      NULL,
      1,
      0.504554,
      0,
      1,
      0,
      1.691143,
      1.004757,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038927,
      0.113512,
      0.704506,
      4.367273,
      1,
      5,
      NULL,
      3.060287,
      4.320753,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.015987,
      0.718023,
      NULL,
      1.177919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3.211000,
      NULL,
      3.959888,
      2.954462,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.636008,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311638,
      NULL,
      5,
      6,
      10,
      3,
      1,
      3.808351,
      NULL,
      98.426533,
      5,
      1.057722,
      1,
      '22201',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


