set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0311442',
      0,
      0,
      0,
      1,
      '1133',
      NULL,
      0.600374,
      NULL,
      NULL,
      ' 7-13-1988',
      NULL,
      NULL,
      NULL,
      1.305970,
      3,
      NULL,
      17,
      0,
      72.409216,
      16.751564,
      0.608188,
      ' 9-12-1981',
      ' 5-20-2001',
      '11-12-1978',
      1,
      0,
      NULL,
      2,
      1.768941,
      0,
      1.001331,
      3.891445,
      NULL,
      NULL,
      NULL,
      4.045813,
      4.615684,
      5,
      25,
      5,
      8,
      3,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.296812,
      0,
      2.999336,
      3,
      6.222642,
      1.127707,
      0.994038,
      1.202137,
      3,
      0.862229,
      3,
      1,
      0.888630,
      1,
      NULL,
      1.165268,
      5.410806,
      1.598751,
      NULL,
      NULL,
      1.540531,
      0.310227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5.921699,
      1.514496,
      NULL,
      1,
      0.768700,
      1,
      1.094463,
      NULL,
      1.346288,
      NULL,
      0.207913,
      0.445281,
      1,
      0,
      1.437907,
      0,
      NULL,
      NULL,
      1.192614,
      NULL,
      1.491340,
      2.753029,
      0,
      NULL,
      NULL,
      NULL,
      2.715816,
      3,
      NULL,
      3.143554,
      1,
      NULL,
      2,
      2,
      1.143797,
      1,
      1.828182,
      4,
      NULL,
      4.288195,
      NULL,
      NULL,
      3.005535,
      0.982669,
      2.109277,
      2,
      ' 6-26-1976',
      238,
      '11-15-1983',
      65.390824,
      0.506124,
      1.209231,
      1.768556,
      2.728433,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643016,
      0,
      0,
      1,
      0,
      0.817848,
      1.111409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.589446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.855742,
      0.787773,
      0,
      0,
      0.750573,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.565655,
      0.947187,
      1.280856,
      1,
      1,
      3.533225,
      94,
      1.332960,
      0,
      NULL,
      NULL,
      NULL,
      3.763654,
      0,
      3,
      NULL,
      1.055173,
      2,
      2,
      1.902043,
      3,
      1.886942,
      2,
      2,
      NULL,
      1.896994,
      18.400613,
      4,
      NULL,
      39,
      164,
      NULL,
      NULL,
      NULL,
      1.989836,
      0.320650,
      0.502576,
      1,
      1.610555,
      0,
      NULL,
      15,
      5,
      1.800005,
      11.672603,
      8,
      NULL,
      5,
      5,
      4,
      5.119717,
      3,
      1,
      2,
      0,
      NULL,
      28,
      3,
      2.200662,
      NULL,
      0.129147,
      79.582107,
      8.110194,
      0,
      1.210317,
      3,
      '43441',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.311657,
      34,
      130.661177,
      14.779396,
      1.301732,
      23.466361,
      NULL,
      0,
      NULL,
      1.908106,
      1.955454,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.710113,
      NULL,
      NULL,
      0.733539,
      1,
      1.918905,
      0,
      NULL,
      NULL,
      1.297808,
      NULL,
      NULL,
      0.071042,
      NULL,
      NULL,
      1.559863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861780,
      NULL,
      NULL,
      2.637441,
      NULL,
      0,
      NULL,
      0.837904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002867,
      NULL,
      NULL,
      0.445810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.679283,
      3,
      2,
      1,
      1.759675,
      NULL,
      NULL,
      NULL,
      NULL,
      4.316052,
      2.846938,
      5.422994,
      1.205673,
      NULL,
      NULL,
      0.427986,
      NULL,
      NULL,
      1.698621,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.047354,
      NULL,
      NULL,
      1.437962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.273786,
      NULL,
      NULL,
      1.847599,
      NULL,
      NULL,
      NULL,
      3.262042,
      1,
      NULL,
      2.207369,
      3,
      2.309331,
      NULL,
      1.343833,
      3.276195,
      NULL,
      NULL,
      2.189087,
      NULL,
      NULL,
      1.999234,
      NULL,
      NULL,
      2,
      1.172467,
      0,
      NULL,
      3.412055,
      3,
      NULL,
      5.612039,
      4.603492,
      0,
      2,
      0,
      0.507842,
      NULL,
      NULL,
      0.842679,
      3.927937,
      1,
      3,
      NULL,
      3,
      NULL,
      7.091146,
      1,
      1.167261,
      3,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.113837,
      0.263472,
      1,
      1.785909,
      1.600931,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181234,
      1,
      1.881930,
      0,
      0.418619,
      1.105844,
      0.125827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.934554,
      NULL,
      NULL,
      NULL,
      3.588460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521916,
      NULL,
      NULL,
      NULL,
      1.515065,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634768,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.179260,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      1.676007,
      0,
      0.489067,
      NULL,
      NULL,
      0.611986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1817.776974,
      0.934250,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      0.558332,
      0,
      0.885911,
      NULL,
      NULL,
      1,
      0,
      1.308311,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160535,
      0.864451,
      0,
      1,
      2,
      2,
      0.543247,
      0,
      4,
      NULL,
      2.638482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.386783,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.189490,
      NULL,
      1,
      3.647569,
      NULL,
      1.403587,
      3,
      NULL,
      1,
      0.213586,
      NULL,
      0,
      1,
      NULL,
      1.207812,
      NULL,
      NULL,
      1.393023,
      0.205135,
      NULL,
      1.446131,
      0,
      NULL,
      2,
      1.321015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.920839,
      1.361812,
      NULL,
      NULL,
      23.199217,
      121,
      0,
      0.342823,
      0.582464,
      '12022',
      '',
      '',
      1.004239,
      '',
      '',
      '',
      0.599229,
      NULL,
      '',
      '');
commit;
end;
/


