set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '4222440',
      0,
      NULL,
      0,
      2,
      NULL,
      3.144275,
      NULL,
      NULL,
      NULL,
      ' 5-22-1982',
      NULL,
      NULL,
      2.148130,
      0.997394,
      1.367975,
      NULL,
      NULL,
      4,
      178,
      23,
      3.921062,
      ' 5-21-1979',
      ' 3-17-1988',
      ' 9-12-1997',
      1,
      NULL,
      3.781620,
      0,
      2,
      NULL,
      2.432359,
      0,
      0,
      NULL,
      5,
      NULL,
      4,
      0,
      28,
      2.019391,
      9,
      2.704824,
      NULL,
      6.165856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592571,
      1,
      2.875541,
      0.701965,
      2,
      1,
      1.886826,
      0,
      1.171126,
      NULL,
      2,
      0,
      1.417984,
      1.304393,
      0.372502,
      NULL,
      8,
      0.876866,
      5.965080,
      NULL,
      3,
      1.290211,
      NULL,
      NULL,
      1.371055,
      NULL,
      NULL,
      9.018518,
      1,
      3.086094,
      0.694648,
      0.337867,
      NULL,
      3,
      NULL,
      0,
      0.805052,
      NULL,
      2.402190,
      NULL,
      2.524627,
      0,
      NULL,
      1.198503,
      1,
      0,
      6,
      NULL,
      7,
      9.689062,
      1.874605,
      1,
      0,
      1.693006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.787671,
      6,
      2.210551,
      4,
      1,
      0,
      3,
      NULL,
      0.806537,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      0.017729,
      NULL,
      0,
      NULL,
      NULL,
      2.280019,
      2.802283,
      2,
      5.425659,
      1,
      1,
      0.246682,
      0,
      2,
      2.626252,
      1.944150,
      3,
      NULL,
      2.616341,
      0.595576,
      NULL,
      1,
      5.385165,
      8.774359,
      6.157039,
      5.974853,
      2.766296,
      0,
      2,
      0,
      NULL,
      1.806418,
      ' 9-25-1985',
      113,
      NULL,
      NULL,
      1.254287,
      0.816102,
      1.415392,
      NULL,
      1.582559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389556,
      0.929184,
      0,
      1.748114,
      NULL,
      1.571372,
      1,
      0.940288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780720,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.786755,
      NULL,
      4.722461,
      NULL,
      1,
      1.698235,
      NULL,
      NULL,
      NULL,
      0.155808,
      3.787177,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820714,
      0,
      0.456472,
      0,
      NULL,
      1.134554,
      NULL,
      NULL,
      3.269448,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0.230765,
      1.057696,
      3,
      NULL,
      3.624950,
      0,
      1,
      3.481404,
      1,
      1.749434,
      NULL,
      9.032492,
      10.606722,
      14,
      NULL,
      12,
      6,
      6,
      NULL,
      0,
      NULL,
      1,
      1,
      0.880858,
      1,
      0.252944,
      9,
      11.154550,
      1.827341,
      NULL,
      3.641401,
      4.584685,
      8.511484,
      0.017354,
      4,
      4.485883,
      1,
      0.404135,
      2.509359,
      1,
      NULL,
      1,
      2.990927,
      0.120224,
      NULL,
      29.935045,
      34,
      41.392026,
      1.412536,
      NULL,
      1,
      '41223',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      9,
      302,
      2.804896,
      0.934279,
      11,
      5,
      5,
      0,
      3,
      1,
      1.874417,
      1,
      NULL,
      NULL,
      1.855576,
      NULL,
      NULL,
      0.091037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.584338,
      NULL,
      0.326595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.310595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923623,
      NULL,
      NULL,
      NULL,
      3,
      0.298639,
      NULL,
      NULL,
      1.048865,
      1.401019,
      2,
      1.429917,
      0,
      0.429886,
      1,
      1,
      1.555555,
      NULL,
      3,
      3,
      1,
      2.814079,
      NULL,
      NULL,
      1,
      1,
      3.197071,
      0.245887,
      2,
      1.003984,
      0,
      1.661169,
      0.946636,
      NULL,
      NULL,
      1,
      1.235410,
      0.682419,
      3.834718,
      1,
      0.044719,
      1.045318,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594610,
      2,
      1,
      NULL,
      1,
      3,
      0,
      1,
      1.193103,
      1,
      NULL,
      NULL,
      5.707480,
      1,
      NULL,
      2,
      0.894165,
      1.165304,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.013191,
      NULL,
      NULL,
      NULL,
      1.688459,
      NULL,
      NULL,
      0.603954,
      NULL,
      NULL,
      1.402572,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.735898,
      0.555217,
      0.244432,
      0,
      4.607311,
      2.138737,
      8.646380,
      1,
      1.575943,
      8,
      2.437360,
      2,
      2,
      1,
      0,
      2,
      1.809860,
      1.918822,
      2.702142,
      0,
      0.992293,
      1,
      0.578962,
      5.794655,
      NULL,
      NULL,
      1.802988,
      1,
      0.082239,
      1,
      NULL,
      0.250542,
      2,
      2,
      0.101611,
      NULL,
      0.638730,
      3.767522,
      1,
      0,
      1.959020,
      1,
      1.698028,
      NULL,
      3.074165,
      0.050518,
      0,
      0,
      0.322024,
      1.397430,
      1,
      NULL,
      NULL,
      0.093604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.022128,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.377564,
      1,
      1.128664,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065523,
      1.326099,
      NULL,
      NULL,
      1.526749,
      1,
      NULL,
      NULL,
      1.031788,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.888355,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.552712,
      NULL,
      NULL,
      1.899146,
      0.077902,
      NULL,
      NULL,
      0.776367,
      2,
      NULL,
      NULL,
      1,
      0.501752,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.071252,
      NULL,
      NULL,
      NULL,
      0.296291,
      NULL,
      4,
      0.269967,
      NULL,
      NULL,
      1.073015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99.804546,
      NULL,
      1.995334,
      1,
      NULL,
      NULL,
      1.299231,
      1,
      0.336905,
      NULL,
      1.668809,
      1.761626,
      0.132128,
      1.972142,
      NULL,
      0,
      NULL,
      NULL,
      0.067288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.962946,
      1.235139,
      NULL,
      NULL,
      1.521505,
      1,
      2.024116,
      3.256871,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.740876,
      0.692781,
      NULL,
      0.455635,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.185061,
      NULL,
      0.650866,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.512881,
      1,
      NULL,
      0.446981,
      0,
      NULL,
      0.231904,
      0,
      NULL,
      1.100662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170041,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4.133526,
      NULL,
      6,
      NULL,
      NULL,
      1,
      63,
      34,
      NULL,
      NULL,
      NULL,
      '41223',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.030026,
      '',
      '',
      '');
commit;
end;
/


