set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7,
      3.803940,
      3,
      3,
      2,
      NULL,
      0.651438,
      2,
      '02',
      '20312220',
      9.606521,
      21,
      '3412231',
      0,
      0,
      3,
      1,
      '3210',
      0.997160,
      0.476281,
      NULL,
      NULL,
      ' 0- 9-1984',
      NULL,
      18,
      NULL,
      NULL,
      1.331302,
      ' 1- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630887,
      0,
      0,
      NULL,
      0,
      0,
      3.661924,
      1,
      0.720799,
      14.274843,
      12,
      5,
      1.754053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.263063,
      0.727282,
      0.047242,
      1,
      0.865245,
      0,
      NULL,
      5,
      NULL,
      3.734052,
      3.794860,
      0.954959,
      NULL,
      NULL,
      0,
      0.927316,
      0,
      0.021032,
      0,
      1,
      1.563425,
      0.423027,
      1.187942,
      NULL,
      NULL,
      NULL,
      1.932630,
      0.033952,
      NULL,
      NULL,
      NULL,
      1.062155,
      3,
      1.303663,
      1,
      0,
      1.278338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342595,
      0,
      NULL,
      1.366702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020919,
      1,
      3.825117,
      NULL,
      0,
      1.181181,
      1.238690,
      0,
      0,
      1,
      1,
      1.454556,
      0.441931,
      0.015617,
      1,
      0.151023,
      NULL,
      NULL,
      0,
      2,
      0,
      1.137881,
      1,
      1,
      5.464898,
      2.362501,
      4.031261,
      5.406590,
      1.636490,
      NULL,
      7,
      0.741018,
      1,
      NULL,
      0.201008,
      4,
      7.273211,
      6,
      NULL,
      0,
      7,
      1.908880,
      4,
      NULL,
      NULL,
      1.394485,
      '10-17-1975',
      305.487162,
      ' 4-13-1995',
      79.611518,
      1,
      0.604663,
      NULL,
      6.235153,
      1.245190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163753,
      NULL,
      1.941835,
      0.789757,
      1,
      0.848938,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8.350851,
      0.728240,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.470073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.070387,
      6,
      0,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      2.988985,
      2,
      2,
      0.205255,
      6.679983,
      NULL,
      NULL,
      ' 9-26-2002',
      NULL,
      ' 9- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      3.355373,
      3.244001,
      1,
      1,
      1,
      0.610779,
      1.854965,
      0,
      NULL,
      2.629957,
      0.381053,
      NULL,
      NULL,
      NULL,
      3.447632,
      1,
      3.183048,
      3.216233,
      2,
      0,
      3.931110,
      3,
      2,
      2,
      3.064363,
      0,
      1.035087,
      NULL,
      NULL,
      NULL,
      0.931349,
      0,
      1.431884,
      5.112438,
      NULL,
      1.345718,
      0.543633,
      0,
      1.817585,
      1,
      1,
      0,
      0.058117,
      0,
      3.046940,
      NULL,
      7,
      11,
      NULL,
      1.183796,
      7,
      3,
      1,
      0,
      2.612706,
      3.839863,
      0.561283,
      0,
      48,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.706708,
      2.873950,
      0.478326,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      26.854186,
      31,
      NULL,
      3.375502,
      NULL,
      5.289572,
      0.361399,
      1,
      NULL,
      NULL,
      3.576397,
      0.708018,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.674674,
      NULL,
      NULL,
      1.849896,
      NULL,
      1.548753,
      1,
      NULL,
      NULL,
      1.454584,
      3,
      3,
      1.442958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561879,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.162184,
      0.988719,
      1,
      0.903857,
      0.006113,
      NULL,
      NULL,
      NULL,
      0.917210,
      NULL,
      2,
      0.193769,
      0.306429,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.455904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.242758,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.967744,
      0,
      NULL,
      NULL,
      3.592103,
      1,
      0,
      3,
      2,
      0.160997,
      1.778904,
      NULL,
      NULL,
      9.316769,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.046290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995260,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478569,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.977085,
      0,
      NULL,
      4,
      NULL,
      1.305320,
      0,
      NULL,
      NULL,
      1.166504,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      2.978942,
      3.580422,
      2.038343,
      5,
      2,
      0,
      NULL,
      NULL,
      3.176691,
      3,
      2.932608,
      NULL,
      NULL,
      2.153299,
      0,
      1,
      3.580433,
      NULL,
      NULL,
      6,
      2.704742,
      3.041860,
      7.357766,
      NULL,
      0.363778,
      1,
      1.407412,
      NULL,
      1.516339,
      NULL,
      0.767544,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.646697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.115521,
      NULL,
      NULL,
      0.953878,
      NULL,
      NULL,
      3,
      3.189080,
      2,
      1,
      NULL,
      3.969335,
      NULL,
      NULL,
      0,
      1.561512,
      NULL,
      NULL,
      1.551423,
      11.935296,
      NULL,
      NULL,
      2.827129,
      NULL,
      NULL,
      NULL,
      0,
      0.307009,
      NULL,
      NULL,
      0,
      1.404528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.339743,
      0.990012,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2.434962,
      3,
      NULL,
      NULL,
      2,
      0.469632,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      2.572404,
      NULL,
      NULL,
      12,
      11.531875,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      7.307818,
      6.612169,
      1,
      NULL,
      NULL,
      1.445214,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226950,
      3,
      1.785755,
      0.875775,
      0,
      1.955317,
      1,
      NULL,
      NULL,
      1.002362,
      0,
      0,
      1,
      0,
      1,
      1,
      1.568455,
      0.455773,
      0.117817,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.875178,
      0.273172,
      0.097820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656416,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.197176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111186,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.538544,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516136,
      NULL,
      0.696065,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034406,
      3.340485,
      NULL,
      0,
      2.139044,
      3,
      5.973469,
      0.956317,
      12.631541,
      3,
      0,
      0,
      1.195617,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.152843,
      0.490152,
      NULL,
      0.512289,
      1.687956,
      NULL,
      1.556926,
      1.101094,
      NULL,
      1,
      0.542735,
      NULL,
      1.287257,
      NULL,
      NULL,
      0.142782,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.554631,
      NULL,
      NULL,
      3.224982,
      0.447864,
      1.031325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.229325,
      NULL,
      6,
      2.575428,
      7,
      0,
      NULL,
      NULL,
      35.340672,
      59.167666,
      2.744213,
      2.899001,
      2,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


