set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4422003',
      0.158910,
      0.456071,
      1,
      NULL,
      '2331',
      3,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1976',
      53,
      NULL,
      1,
      NULL,
      2.277519,
      ' 1- 8-2002',
      41.914967,
      0,
      202.307632,
      NULL,
      1.873155,
      NULL,
      ' 3-17-1991',
      ' 5-17-2002',
      0.540684,
      1.612286,
      NULL,
      0.111463,
      1.337644,
      1.307201,
      0.400291,
      2,
      NULL,
      NULL,
      NULL,
      9,
      4,
      17.738407,
      5,
      3,
      25.501168,
      3.915423,
      3,
      5,
      1,
      NULL,
      0,
      1.617614,
      1.175644,
      0.345606,
      1.419305,
      0,
      NULL,
      NULL,
      1.719070,
      4.019361,
      0.443783,
      7,
      2.954687,
      5,
      0.572604,
      0.601441,
      6.481667,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5.954036,
      NULL,
      3.802942,
      2,
      0.931793,
      3.197014,
      NULL,
      NULL,
      NULL,
      4.096346,
      1,
      0.433449,
      0.991979,
      0.394407,
      0,
      0,
      1,
      2.814462,
      1,
      0,
      2.197807,
      0.258059,
      1,
      1.954267,
      0,
      1.972261,
      NULL,
      0,
      NULL,
      4.983005,
      1.831027,
      1.386659,
      0,
      NULL,
      3,
      3,
      3,
      2.537168,
      1,
      NULL,
      NULL,
      0.452585,
      4,
      0.100919,
      0,
      7,
      0,
      0,
      0.436971,
      NULL,
      1.056352,
      1.945063,
      1,
      1.551380,
      2,
      1.751241,
      0,
      0.602909,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.413741,
      0,
      4,
      1,
      1.423480,
      2,
      1,
      4,
      1.526187,
      5,
      1.045890,
      4.334945,
      3,
      NULL,
      NULL,
      0.114666,
      NULL,
      2,
      NULL,
      1,
      3,
      1.576108,
      5.260143,
      5,
      NULL,
      2.247563,
      ' 8-17-1993',
      7.555688,
      ' 0-15-1989',
      0.472222,
      0.758054,
      1.031756,
      1.618581,
      2,
      0.149991,
      NULL,
      2,
      0.136203,
      NULL,
      1,
      5.026352,
      5,
      NULL,
      1,
      NULL,
      4.174956,
      4,
      6,
      2,
      2.278075,
      2,
      ' 1-21-1989',
      1.383084,
      ' 2-29-1993',
      1,
      NULL,
      NULL,
      0.262062,
      1.414254,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.177494,
      1.427476,
      2,
      NULL,
      1,
      0.969963,
      1,
      0.247073,
      1.306908,
      3.379179,
      0.878866,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      2.457316,
      0.524412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.552475,
      1,
      0,
      NULL,
      1,
      1,
      3.389605,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.491027,
      1,
      2.218461,
      1.208316,
      1.800978,
      2.609179,
      3.264160,
      2.362816,
      0.937934,
      1,
      3.478914,
      1.347841,
      NULL,
      0,
      NULL,
      0,
      0,
      0.676249,
      0.167295,
      1,
      0.155049,
      0.998013,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.451597,
      1,
      1,
      10.112066,
      6.500935,
      3.593810,
      4.696924,
      NULL,
      1.212762,
      2.838397,
      1.732998,
      2,
      3.230187,
      3.665842,
      0,
      NULL,
      3.968352,
      NULL,
      NULL,
      16,
      31.441945,
      NULL,
      1.487487,
      5.417970,
      2,
      '12131',
      '',
      '',
      0.565965,
      '',
      NULL,
      '',
      0.410246,
      '',
      '',
      '',
      2.171078,
      10,
      NULL,
      4,
      1,
      37.829715,
      0.897922,
      2,
      4.682999,
      NULL,
      1.916112,
      NULL,
      1,
      NULL,
      NULL,
      1.569092,
      NULL,
      NULL,
      1.048284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.864690,
      0.493424,
      1.578138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5,
      NULL,
      1.782834,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.223272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.612085,
      1,
      0.657635,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.347762,
      NULL,
      0,
      NULL,
      NULL,
      3.132961,
      3.324990,
      1.262676,
      1,
      NULL,
      NULL,
      1.737252,
      NULL,
      NULL,
      1.057256,
      NULL,
      NULL,
      1.314318,
      NULL,
      NULL,
      0.821438,
      NULL,
      NULL,
      1.703362,
      NULL,
      NULL,
      1.771048,
      NULL,
      NULL,
      NULL,
      2,
      0.287728,
      NULL,
      0,
      1.779246,
      1.744926,
      2,
      0.066019,
      NULL,
      NULL,
      NULL,
      1.267342,
      3.153251,
      0.205020,
      2,
      0,
      0.973948,
      1.938952,
      2,
      1,
      7.053652,
      0,
      3.855419,
      NULL,
      NULL,
      3.630697,
      0,
      NULL,
      NULL,
      0,
      2,
      0.518376,
      0,
      NULL,
      NULL,
      4,
      1.392308,
      NULL,
      NULL,
      5.290971,
      0.749968,
      0.795060,
      NULL,
      NULL,
      3.528889,
      2.780473,
      1,
      0,
      NULL,
      1.511232,
      NULL,
      NULL,
      NULL,
      NULL,
      8.065735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.333485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.376724,
      NULL,
      NULL,
      0.605011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.284610,
      NULL,
      NULL,
      1,
      3.691300,
      NULL,
      1,
      NULL,
      0,
      0.933558,
      NULL,
      2.408436,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.166642,
      NULL,
      NULL,
      NULL,
      1.428257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560960,
      NULL,
      NULL,
      NULL,
      0.778974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709419,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.174652,
      NULL,
      NULL,
      NULL,
      2.119944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.630821,
      NULL,
      NULL,
      NULL,
      11.855796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.936566,
      0.379531,
      5.792826,
      0.691392,
      34,
      NULL,
      3.131497,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      8.165908,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      39,
      0,
      0.726083,
      1.442427,
      1,
      0.180027,
      1,
      0,
      0.676175,
      1,
      1,
      1.868111,
      0.827879,
      0,
      0.770196,
      0,
      1.587682,
      0,
      0,
      1.145726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.002827,
      1.107273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628975,
      1.406012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203767,
      0.492249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.655106,
      0.287575,
      NULL,
      NULL,
      1.541774,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.167192,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517865,
      1.892276,
      0.179515,
      1,
      1.768107,
      1.843474,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.525095,
      2.108666,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.996401,
      NULL,
      NULL,
      1.313780,
      NULL,
      3.217223,
      0.706616,
      NULL,
      0.399143,
      1.123322,
      NULL,
      NULL,
      0.794471,
      NULL,
      1.217445,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.020479,
      0.774670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.855681,
      NULL,
      2.249528,
      NULL,
      0.013026,
      0.727045,
      NULL,
      NULL,
      52.344680,
      24.611902,
      4,
      1,
      4,
      NULL,
      NULL,
      '',
      0.774574,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


