set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      0.681564,
      NULL,
      0.094936,
      3,
      0,
      0.492742,
      NULL,
      '22144112',
      4,
      NULL,
      '1430043',
      0,
      1,
      4,
      NULL,
      '4433',
      0.755285,
      1,
      NULL,
      NULL,
      ' 8- 9-1995',
      7,
      10,
      NULL,
      2,
      2,
      ' 8-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      4.799544,
      NULL,
      NULL,
      ' 7-11-1995',
      2,
      NULL,
      0,
      NULL,
      0,
      0,
      2.848995,
      0,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      NULL,
      NULL,
      NULL,
      0.940809,
      NULL,
      1,
      0.948517,
      0.450762,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      3.138871,
      9,
      1,
      1.485911,
      4.104095,
      0.244078,
      7,
      11.795450,
      6,
      NULL,
      8.590235,
      7,
      5,
      2.406155,
      4,
      NULL,
      0.687312,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463318,
      NULL,
      NULL,
      8,
      10.738757,
      1.581879,
      NULL,
      0,
      1.144638,
      1.335608,
      NULL,
      1,
      2.474412,
      3,
      NULL,
      NULL,
      NULL,
      1.833679,
      0.290987,
      3.763520,
      NULL,
      0.060752,
      1.501426,
      1.225428,
      3,
      0.331467,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.303329,
      NULL,
      NULL,
      0.275579,
      NULL,
      6,
      0.275266,
      3.622621,
      0,
      2,
      3,
      0.049246,
      1.040847,
      3.211468,
      NULL,
      1,
      NULL,
      NULL,
      1.143025,
      1,
      NULL,
      1.440769,
      NULL,
      0.238825,
      1,
      NULL,
      1,
      NULL,
      1,
      1.209353,
      NULL,
      3.331192,
      1,
      NULL,
      NULL,
      0.375081,
      6,
      1.823290,
      0.405763,
      3,
      0.670546,
      0.086454,
      NULL,
      4,
      7,
      9,
      8.406598,
      0.503093,
      1.527762,
      NULL,
      NULL,
      NULL,
      20.719724,
      ' 0-19-1978',
      10.796433,
      3.802299,
      NULL,
      0,
      0.065236,
      0.236942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286458,
      0,
      NULL,
      1.891908,
      2,
      5.773465,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150410,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.791504,
      0,
      1.887144,
      2.871307,
      NULL,
      7,
      4,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.315928,
      5.125944,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.652019,
      0.965566,
      NULL,
      NULL,
      0,
      NULL,
      21,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2,
      3.507748,
      2,
      2.493716,
      0.915827,
      0,
      3,
      1,
      1.529588,
      NULL,
      3.450901,
      2,
      0,
      0.582398,
      0.508183,
      3.457228,
      NULL,
      1,
      0.000236,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      1.914720,
      5.348224,
      NULL,
      5,
      0.686671,
      2,
      7,
      2.730709,
      1,
      5.219268,
      2,
      3.555727,
      1.698791,
      66,
      0.373864,
      1.295695,
      7,
      NULL,
      40.502913,
      47.919615,
      5,
      4.360518,
      0,
      '21333',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      29,
      27.489233,
      23,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828997,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.100432,
      0,
      3,
      1.764700,
      0,
      NULL,
      1,
      NULL,
      0.808464,
      0.718649,
      1,
      3.621599,
      NULL,
      1,
      3,
      1,
      NULL,
      1.060380,
      0,
      NULL,
      NULL,
      NULL,
      0.925544,
      NULL,
      NULL,
      NULL,
      3.652956,
      0,
      0.505019,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.091444,
      1.089211,
      NULL,
      0.843927,
      0,
      NULL,
      2.937104,
      NULL,
      1,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104444,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139438,
      NULL,
      NULL,
      3.773073,
      0,
      NULL,
      0.974158,
      NULL,
      NULL,
      4.385303,
      0,
      1.577165,
      1,
      1,
      NULL,
      0.623436,
      NULL,
      NULL,
      4.079596,
      1.872905,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.307808,
      NULL,
      NULL,
      3.453807,
      NULL,
      0.421851,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      2.672320,
      0.605777,
      3,
      6,
      6,
      4.423008,
      3,
      0.261103,
      0.260617,
      0,
      1,
      3,
      2.249642,
      0.305511,
      2.610298,
      1,
      NULL,
      NULL,
      4,
      5.686234,
      5,
      4,
      NULL,
      1.357319,
      0.872494,
      NULL,
      NULL,
      NULL,
      1.680444,
      1,
      0.222510,
      0,
      2.021492,
      NULL,
      NULL,
      0.460108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.581121,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      2.372602,
      3.394335,
      0.802891,
      2,
      1.530465,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      10.148083,
      NULL,
      NULL,
      NULL,
      1.644017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.952510,
      NULL,
      0.130715,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.461722,
      NULL,
      0.394159,
      NULL,
      0.240692,
      NULL,
      NULL,
      NULL,
      1.854401,
      NULL,
      3.361619,
      NULL,
      1,
      NULL,
      1.431462,
      NULL,
      NULL,
      NULL,
      1.858795,
      NULL,
      0,
      NULL,
      2.705272,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.835355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722692,
      NULL,
      0.264032,
      NULL,
      0,
      NULL,
      7.560113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.776256,
      0.426200,
      0.859728,
      NULL,
      12,
      0,
      0.510740,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      1.604633,
      NULL,
      0,
      1,
      0,
      1.150816,
      0.933280,
      NULL,
      1,
      0.752848,
      1.943883,
      1,
      0.967378,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.249950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660328,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.839962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.826701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372287,
      1,
      0,
      NULL,
      1.796121,
      NULL,
      115,
      NULL,
      2.417727,
      NULL,
      3.426455,
      NULL,
      0.706139,
      NULL,
      3.671964,
      1,
      NULL,
      NULL,
      NULL,
      2.162103,
      3,
      2,
      0.397648,
      3,
      0.363185,
      NULL,
      1,
      1.197538,
      0,
      NULL,
      5.392088,
      0.750752,
      0.416830,
      NULL,
      1.745627,
      1.865709,
      1,
      0.245006,
      1,
      0,
      NULL,
      1.278992,
      1.044970,
      NULL,
      1.399237,
      0.654443,
      1,
      0.373665,
      1.685815,
      0.998991,
      3.684513,
      1.919975,
      0,
      0,
      1,
      1,
      NULL,
      3.359488,
      1.519864,
      0,
      0,
      0,
      3.395803,
      NULL,
      1,
      0,
      1.995786,
      NULL,
      1,
      1.641660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342218,
      NULL,
      1,
      NULL,
      0.880859,
      1,
      3.640012,
      2.458519,
      6,
      0,
      NULL,
      NULL,
      73,
      NULL,
      2,
      0.432562,
      2.307395,
      '44443',
      '42210',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


