set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2021220',
      3,
      1,
      NULL,
      0,
      '2401',
      1.346200,
      0,
      NULL,
      NULL,
      ' 2-10-2003',
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1995',
      7.263442,
      0,
      NULL,
      163.286440,
      NULL,
      NULL,
      '11-26-1994',
      ' 1-16-1978',
      NULL,
      3.210286,
      0,
      3,
      0.806762,
      2.347475,
      1.730941,
      NULL,
      NULL,
      NULL,
      NULL,
      2.384202,
      0.144673,
      21,
      13.086862,
      1.673177,
      17.616886,
      2,
      1.270265,
      3.196589,
      1.115094,
      1.535861,
      NULL,
      0.997359,
      0.875856,
      NULL,
      NULL,
      1,
      0,
      0.664058,
      0,
      3,
      3.337524,
      0.065899,
      0.993234,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      4,
      0,
      0.300568,
      1.795463,
      1.324157,
      NULL,
      7,
      0.825837,
      3.873028,
      3.889978,
      1.651612,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.097950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.055390,
      1.485564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954262,
      1.091086,
      NULL,
      1.719855,
      3.706718,
      1.459684,
      NULL,
      0.391495,
      0,
      1.982774,
      0,
      0.069696,
      3,
      1,
      0,
      0,
      NULL,
      0.109441,
      NULL,
      NULL,
      1.906849,
      1.572442,
      0.106199,
      4.245875,
      NULL,
      4.687810,
      4,
      1,
      2,
      1.566478,
      0,
      NULL,
      3,
      NULL,
      4.870003,
      2,
      NULL,
      3,
      6.895542,
      NULL,
      3.412193,
      9.338644,
      4.592589,
      3,
      NULL,
      1.390696,
      0.790923,
      ' 8-27-1977',
      156.199437,
      ' 3- 0-1991',
      18,
      1.188808,
      1,
      1.022123,
      1,
      4.615535,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      0.335191,
      7,
      1,
      0,
      NULL,
      2.781674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.262826,
      4.069633,
      5,
      1.647349,
      4.852186,
      1.490447,
      5,
      1,
      NULL,
      NULL,
      0,
      7.765185,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.255379,
      2,
      0,
      1,
      NULL,
      NULL,
      0.317308,
      1.710005,
      48,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.571825,
      NULL,
      2.431192,
      0.061449,
      0,
      2.296799,
      3.760557,
      NULL,
      1.065444,
      2.443362,
      3,
      3,
      0.465841,
      1.958868,
      1,
      2,
      0,
      1.499250,
      2,
      1,
      0.674449,
      1,
      1.536194,
      0.551191,
      1.885528,
      NULL,
      1.982988,
      NULL,
      1,
      NULL,
      0.967067,
      7.819924,
      5,
      2,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      3.600788,
      1.661365,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      8,
      1.137242,
      0,
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2.563506,
      10,
      66.944878,
      48.013376,
      2,
      41,
      1.039588,
      0,
      5,
      2,
      NULL,
      3,
      0.365254,
      NULL,
      NULL,
      0.068656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.669425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0.559110,
      NULL,
      NULL,
      0.811213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.714959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.674887,
      NULL,
      5.748737,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.870601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      1.344723,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.487309,
      1,
      NULL,
      NULL,
      2.650129,
      7,
      5.345499,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386322,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      3.932276,
      1,
      3.037642,
      NULL,
      4.582426,
      4.154767,
      1,
      0,
      NULL,
      NULL,
      0,
      1.759961,
      1,
      2.539308,
      0,
      NULL,
      1,
      NULL,
      0.820054,
      2,
      4,
      1,
      3.043114,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.866206,
      2,
      0,
      2.654848,
      3.434336,
      3,
      5,
      5.612310,
      5.608954,
      NULL,
      4,
      0,
      2.277409,
      NULL,
      5,
      1,
      1,
      0.667085,
      1.671212,
      0.843489,
      2.353486,
      NULL,
      NULL,
      1.081793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.580088,
      NULL,
      NULL,
      0.556690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.084984,
      1,
      1,
      NULL,
      1,
      NULL,
      1.788062,
      NULL,
      NULL,
      3.332792,
      NULL,
      NULL,
      NULL,
      27.881844,
      NULL,
      NULL,
      NULL,
      3.654101,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.410973,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.073245,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.248462,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401051,
      28,
      4,
      0,
      NULL,
      1,
      0.797332,
      NULL,
      NULL,
      0.073469,
      1.091951,
      2.160012,
      3,
      5,
      2.181686,
      1,
      NULL,
      NULL,
      0.777835,
      NULL,
      1,
      348,
      1,
      1.424384,
      1.040048,
      1,
      1.684443,
      1,
      NULL,
      1.698340,
      0.058739,
      1.292804,
      NULL,
      NULL,
      0.966224,
      0.903671,
      1.623613,
      1.175074,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031603,
      NULL,
      7.951839,
      1.255212,
      0.211301,
      2,
      4,
      6,
      1.236297,
      1,
      NULL,
      NULL,
      0.330560,
      NULL,
      2,
      1,
      NULL,
      1.051842,
      3,
      NULL,
      0.766441,
      0.748349,
      NULL,
      3,
      2,
      NULL,
      3.460520,
      0.879823,
      NULL,
      1.594369,
      3.160739,
      NULL,
      NULL,
      2.457866,
      NULL,
      NULL,
      0,
      NULL,
      2.900485,
      1.830443,
      NULL,
      2,
      0,
      NULL,
      0.851966,
      1.830327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3.912660,
      NULL,
      0.234124,
      NULL,
      NULL,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      '32241',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


