set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6700116';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3.820155,
      1,
      NULL,
      NULL,
      ' 3-20-2002',
      55,
      NULL,
      0,
      0,
      0.256178,
      ' 3- 8-1986',
      NULL,
      2,
      134,
      87.393157,
      1.215962,
      ' 5-12-1992',
      ' 6- 8-1982',
      ' 4-21-1981',
      1.166929,
      1,
      1.960742,
      1,
      1,
      3.308039,
      2.958062,
      0.675185,
      1.944097,
      102.744144,
      0,
      17.534317,
      2.822686,
      21.852426,
      7.404620,
      2.855639,
      NULL,
      NULL,
      3,
      5,
      2.815426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.897735,
      NULL,
      1,
      NULL,
      1.545966,
      1,
      7.737377,
      3,
      8.565542,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.519200,
      3.338775,
      2.274115,
      3,
      1.851642,
      NULL,
      NULL,
      0.314569,
      NULL,
      NULL,
      3,
      7.264243,
      1.385990,
      2,
      2.485963,
      3.251698,
      1.851380,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2.867809,
      0.597989,
      0.580415,
      2,
      0.153187,
      1,
      2.674831,
      2.307656,
      1.129059,
      1.210053,
      9,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.337520,
      NULL,
      NULL,
      0.174120,
      4,
      NULL,
      3,
      6,
      3,
      0,
      0,
      1,
      NULL,
      2,
      5,
      1,
      2.870225,
      1.470800,
      0,
      0.346699,
      0,
      1.538786,
      NULL,
      0,
      1,
      0.322109,
      4.154808,
      1,
      NULL,
      4,
      0.209123,
      0.011926,
      3.140532,
      5.081350,
      NULL,
      5.201909,
      NULL,
      3.153245,
      1,
      8,
      5,
      NULL,
      7.286121,
      8.964029,
      8,
      NULL,
      2.424056,
      NULL,
      NULL,
      5,
      1,
      ' 7-16-1976',
      673.590163,
      ' 4-10-1996',
      349.181259,
      0,
      1.545993,
      1.939718,
      NULL,
      0.591189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132076,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      0,
      0,
      1.471890,
      3.985660,
      7,
      1.537113,
      3.449687,
      1,
      1.517872,
      4.326815,
      3.204473,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.831858,
      1,
      0,
      3.496084,
      NULL,
      2.725519,
      0,
      NULL,
      20.917752,
      225.593961,
      3.267044,
      NULL,
      1.556578,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2.373566,
      NULL,
      0.468761,
      2.967689,
      1,
      0.243366,
      NULL,
      1,
      0.822280,
      0.222226,
      1,
      2,
      0.735049,
      NULL,
      NULL,
      1.171076,
      0,
      0.312090,
      1.751222,
      NULL,
      1.856711,
      0.179448,
      NULL,
      NULL,
      11.980330,
      7,
      2.305619,
      11,
      8,
      4,
      1,
      2.247531,
      1.925182,
      0,
      NULL,
      NULL,
      10.904492,
      1.286144,
      NULL,
      NULL,
      NULL,
      32,
      34.192371,
      5,
      2,
      NULL,
      '42343',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.440097,
      NULL,
      '',
      NULL,
      2,
      0.301366,
      103.737080,
      21,
      NULL,
      63,
      NULL,
      42.340019,
      6.908041,
      3.513535,
      3,
      0,
      NULL,
      3.524514,
      0.106669,
      3.238843,
      3,
      NULL,
      1,
      3.342502,
      1,
      0.116965,
      1,
      0.192413,
      2.765306,
      1,
      1.990924,
      3.593164,
      3,
      0,
      1.278079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.111401,
      2.500231,
      1.582965,
      2.248727,
      0.113083,
      NULL,
      NULL,
      10.939498,
      8.501842,
      4.579200,
      1.579633,
      1.012599,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.149699,
      1.054505,
      NULL,
      0.810306,
      0,
      2.403533,
      3,
      1,
      NULL,
      0.072656,
      NULL,
      1.742824,
      2.772027,
      2,
      0.072654,
      1,
      NULL,
      0,
      NULL,
      0.936850,
      NULL,
      NULL,
      0,
      0.794958,
      3.495162,
      3.053528,
      2,
      0,
      0,
      NULL,
      NULL,
      3.556569,
      NULL,
      0,
      3,
      8.188832,
      5,
      1.605511,
      0,
      NULL,
      NULL,
      NULL,
      0.741191,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.232353,
      1.029397,
      NULL,
      NULL,
      1,
      4.425181,
      NULL,
      0.659703,
      1,
      1,
      0,
      0.984952,
      NULL,
      1,
      1.609389,
      NULL,
      0.836252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.234495,
      1,
      1,
      1,
      NULL,
      1,
      6.620452,
      0,
      NULL,
      1.563179,
      NULL,
      3,
      4,
      NULL,
      NULL,
      3.375611,
      1.916608,
      0.025541,
      0.243857,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.972741,
      1.666192,
      NULL,
      1.343390,
      3.497403,
      0.358414,
      NULL,
      3,
      NULL,
      2,
      2.527855,
      2.536952,
      1,
      NULL,
      1.177856,
      0,
      5.556569,
      0.442561,
      2.356706,
      0.898892,
      0,
      NULL,
      0,
      1.282126,
      0.825914,
      1,
      2,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      14.950558,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.097628,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.471450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.369777,
      1,
      1.781262,
      0.090530,
      1.519402,
      NULL,
      NULL,
      1.088115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175689,
      NULL,
      NULL,
      NULL,
      3.350046,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287043,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.294162,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.930551,
      NULL,
      NULL,
      NULL,
      3.845300,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.223750,
      NULL,
      NULL,
      NULL,
      2.011758,
      306.029022,
      273.589255,
      2,
      36.747988,
      NULL,
      0,
      NULL,
      NULL,
      3.309373,
      64.181155,
      18,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.530017,
      NULL,
      NULL,
      201.870246,
      46,
      1.868301,
      3,
      0,
      NULL,
      0,
      3.817774,
      0,
      NULL,
      NULL,
      3.074954,
      0.647044,
      NULL,
      0.991477,
      NULL,
      0,
      0,
      1,
      2.965287,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.282645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.463966,
      NULL,
      1.689904,
      NULL,
      NULL,
      NULL,
      0.255452,
      NULL,
      1.035022,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288154,
      0.446619,
      0,
      1.243762,
      0,
      1,
      NULL,
      0.577616,
      0.952561,
      1.351371,
      NULL,
      1.489637,
      2.442148,
      NULL,
      3,
      1,
      NULL,
      2.410580,
      NULL,
      1.629197,
      NULL,
      1.771093,
      0.425024,
      NULL,
      1.671597,
      1,
      2.184674,
      1,
      NULL,
      0.393626,
      1,
      2,
      3,
      1.341810,
      1.983374,
      0,
      0.111170,
      NULL,
      0.415040,
      2.351605,
      0,
      3.301183,
      0,
      1,
      2.443083,
      3,
      0.761848,
      0.533378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4.760135,
      NULL,
      4,
      NULL,
      NULL,
      3,
      13.407738,
      75,
      5,
      0.628024,
      NULL,
      '00014',
      '',
      NULL,
      1.538702,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


