set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9629037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '01',
      9.980352,
      27.610972,
      '0033201',
      3,
      1.410151,
      0,
      2,
      '4433',
      4,
      1,
      NULL,
      NULL,
      NULL,
      11,
      60,
      NULL,
      1.608384,
      1.441695,
      '10-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      2.552967,
      ' 3-10-1993',
      ' 2-19-1995',
      '11-26-1974',
      0,
      2,
      NULL,
      1.186743,
      0,
      3.299473,
      6,
      1,
      1.786348,
      4.003526,
      4,
      8,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.226084,
      0,
      NULL,
      3.365897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866725,
      NULL,
      2,
      0.231138,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.703571,
      NULL,
      NULL,
      NULL,
      0.256302,
      1.200363,
      0,
      1.800942,
      NULL,
      NULL,
      0.480475,
      NULL,
      NULL,
      6,
      3.664615,
      NULL,
      NULL,
      NULL,
      1.084901,
      2.793118,
      2,
      1.244543,
      2.553426,
      2,
      0.220901,
      2.207533,
      1.903669,
      1.229199,
      3,
      2.044608,
      2,
      2,
      7,
      2.296868,
      9,
      9,
      1,
      4,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.934165,
      0.727560,
      NULL,
      NULL,
      2,
      1.082987,
      0.891846,
      0,
      0.735679,
      1.393842,
      1,
      0,
      0.399660,
      1.340515,
      1.839649,
      0,
      0.057096,
      1,
      1.142217,
      NULL,
      1.390051,
      1,
      1,
      1.215583,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.254911,
      0,
      NULL,
      4,
      4,
      NULL,
      7.232223,
      4.662131,
      NULL,
      2.020550,
      2.569870,
      ' 2- 5-1990',
      NULL,
      ' 5-15-1976',
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.370070,
      0.674558,
      1.426199,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.608058,
      3,
      1,
      0.636930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1.590559,
      3.440695,
      1.165261,
      NULL,
      0,
      5.776618,
      1.505922,
      2,
      3,
      0.496449,
      0.689712,
      NULL,
      NULL,
      NULL,
      4.706631,
      0.036938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.822969,
      0.114615,
      0.706817,
      0.750687,
      1.447796,
      0,
      3,
      20,
      1.405116,
      0.771098,
      NULL,
      NULL,
      NULL,
      1.291432,
      NULL,
      1.885701,
      3.764471,
      2.342544,
      NULL,
      3.615806,
      2.493827,
      1.046947,
      NULL,
      2.190828,
      2.232973,
      1.184369,
      0.272917,
      2,
      2.136168,
      NULL,
      0,
      1.187175,
      1.749627,
      NULL,
      1,
      0,
      NULL,
      0.429182,
      NULL,
      1,
      0.175556,
      NULL,
      3.115789,
      4.447954,
      NULL,
      8,
      2.802016,
      5,
      2,
      1,
      6,
      5,
      2,
      0.850674,
      1,
      NULL,
      3.698396,
      15.810593,
      1,
      1.970792,
      NULL,
      NULL,
      24,
      41.995562,
      3.849831,
      NULL,
      3.921844,
      '14404',
      '30323',
      '',
      0,
      '',
      '',
      '',
      1.747933,
      '',
      '',
      '',
      0,
      53,
      89,
      35,
      1.044501,
      40.291781,
      6,
      3,
      2.190093,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.232901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.218294,
      NULL,
      0.508710,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.035642,
      4,
      1.726958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490320,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1,
      0.127707,
      0.327328,
      NULL,
      NULL,
      2.799980,
      NULL,
      0,
      NULL,
      2,
      0,
      2.637850,
      NULL,
      1,
      0.854134,
      NULL,
      1.783077,
      NULL,
      1.402954,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.314939,
      NULL,
      NULL,
      3.523235,
      0.941979,
      1.984013,
      NULL,
      5.460102,
      7.551647,
      0.117224,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249114,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.400218,
      2.226564,
      0,
      NULL,
      NULL,
      1.576429,
      6.590711,
      3.220646,
      1,
      1.151784,
      1.534197,
      1.595732,
      NULL,
      NULL,
      3.764655,
      5,
      0.878243,
      1.304563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885272,
      NULL,
      NULL,
      1.561923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148770,
      NULL,
      NULL,
      1.108816,
      NULL,
      NULL,
      1.769354,
      NULL,
      NULL,
      1.881742,
      NULL,
      NULL,
      4,
      NULL,
      1.886110,
      2.938955,
      3,
      NULL,
      1.871359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.032442,
      6.624667,
      2,
      1,
      1,
      0,
      1,
      2.131997,
      2.632521,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      4.601520,
      1.110673,
      2.430034,
      NULL,
      0,
      1,
      3.681867,
      2.066823,
      0,
      NULL,
      0,
      1.909361,
      0.524184,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      1.741580,
      0,
      0.002423,
      3.161261,
      1.589289,
      NULL,
      NULL,
      7.697600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.484507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.033162,
      NULL,
      NULL,
      NULL,
      0.757002,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.204311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860987,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.311724,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515905,
      NULL,
      NULL,
      NULL,
      4.841112,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      2,
      4.672874,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      0.318869,
      NULL,
      NULL,
      0.912515,
      NULL,
      NULL,
      1.230045,
      NULL,
      0.089025,
      479.800647,
      1,
      0.691042,
      0,
      0,
      2,
      0,
      NULL,
      0.672450,
      1,
      0,
      1,
      1.296291,
      1,
      0,
      3.448896,
      1.197742,
      NULL,
      1,
      2.325626,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.966747,
      NULL,
      1.681129,
      NULL,
      NULL,
      NULL,
      101,
      NULL,
      3,
      25,
      12.269113,
      NULL,
      NULL,
      0.627407,
      NULL,
      3.526609,
      NULL,
      0,
      NULL,
      1.450815,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.715563,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.818527,
      NULL,
      1,
      NULL,
      1.483199,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      0.636965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628184,
      0.651187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124412,
      0.125178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807511,
      0.939109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864344,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812942,
      NULL,
      NULL,
      1.887667,
      NULL,
      1.176457,
      NULL,
      NULL,
      NULL,
      1.256612,
      NULL,
      1,
      NULL,
      1.249055,
      1,
      0.660488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      0.627359,
      3.131115,
      3.324601,
      1,
      8.720071,
      NULL,
      NULL,
      0.826169,
      0,
      1.235919,
      NULL,
      1,
      0.085321,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      1.256116,
      2,
      NULL,
      0.826344,
      0,
      NULL,
      3.497675,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.481594,
      0,
      NULL,
      3,
      3,
      NULL,
      1.064022,
      1,
      NULL,
      2,
      0,
      1.285048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861623,
      0.411647,
      NULL,
      2.867524,
      NULL,
      1.394538,
      NULL,
      1.600297,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.469676,
      NULL,
      0.587083,
      NULL,
      0,
      NULL,
      1.061214,
      NULL,
      0,
      NULL,
      2.834738,
      NULL,
      2,
      NULL,
      3,
      1.426795,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.093659,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      2,
      37.590159,
      16.431716,
      NULL,
      2.896667,
      NULL,
      '30220',
      '44423',
      '',
      1.271789,
      '',
      NULL,
      '',
      0.151834,
      '',
      '',
      NULL);
commit;
end;
/


