set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9665591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '21',
      1,
      27,
      '0241104',
      1.784446,
      NULL,
      6,
      3,
      '1113',
      4.129948,
      0,
      NULL,
      NULL,
      ' 2- 5-1974',
      28.503426,
      56,
      NULL,
      1.662988,
      0.496622,
      '11- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0.399533,
      ' 8- 7-1976',
      ' 7-28-1992',
      ' 8- 6-1986',
      3,
      2.205391,
      NULL,
      0.123951,
      0,
      1.396041,
      1,
      NULL,
      0,
      16.404388,
      10.119244,
      7.025187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.278202,
      NULL,
      0,
      NULL,
      0.054516,
      2,
      0.619061,
      0,
      NULL,
      0.908586,
      0,
      NULL,
      0.252904,
      2.133474,
      5.597044,
      5,
      3,
      0,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.145601,
      NULL,
      5,
      0.547515,
      0.866878,
      3,
      2.572188,
      1,
      NULL,
      NULL,
      1.450230,
      NULL,
      NULL,
      1,
      NULL,
      1.865521,
      1.419035,
      NULL,
      0,
      3.877034,
      NULL,
      0.345899,
      2.129816,
      3,
      0.058519,
      3,
      1.981236,
      1,
      3,
      NULL,
      0,
      1,
      0.087672,
      3,
      NULL,
      9,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      1.888343,
      NULL,
      0,
      1.934770,
      0.430680,
      NULL,
      0,
      0.479739,
      6,
      1.279940,
      0.108391,
      1.276462,
      0,
      0.840539,
      NULL,
      1.998087,
      NULL,
      0,
      2.117907,
      5.492393,
      0,
      1,
      4,
      0,
      1.052984,
      5.285183,
      NULL,
      0,
      5.448712,
      0,
      2.888572,
      3,
      NULL,
      NULL,
      6.404230,
      9,
      5.005263,
      7,
      NULL,
      NULL,
      5.128817,
      10,
      3.625570,
      '11-22-1979',
      160.703030,
      NULL,
      7.200328,
      2,
      0,
      1.314062,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.627482,
      0.234783,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.150869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291990,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      1.885018,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.836752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440496,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.301077,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.106346,
      2.464330,
      0,
      NULL,
      3,
      0,
      NULL,
      1.572640,
      2.775852,
      NULL,
      3.844265,
      0,
      1,
      NULL,
      2.454351,
      5,
      1.209414,
      0.988982,
      1.128725,
      NULL,
      0,
      0.513313,
      1.171656,
      1,
      1.603808,
      NULL,
      0.120374,
      NULL,
      NULL,
      3,
      1.485790,
      8.101255,
      9,
      3.478469,
      0,
      7,
      NULL,
      3.794990,
      3.778893,
      1.343870,
      3.357983,
      2.208975,
      NULL,
      NULL,
      2,
      2,
      12.619006,
      NULL,
      6,
      74,
      NULL,
      0.888170,
      2.862077,
      '20040',
      '',
      '',
      1.872073,
      '',
      '',
      '',
      1.647311,
      '',
      '',
      '',
      3,
      10.918779,
      75.318333,
      0,
      0.562735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.480191,
      NULL,
      NULL,
      1.558958,
      NULL,
      NULL,
      2,
      NULL,
      2.788877,
      0.572977,
      NULL,
      NULL,
      1.739127,
      NULL,
      NULL,
      2,
      2.799363,
      NULL,
      1.013625,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.479712,
      0.395850,
      1.036751,
      1.594972,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.495983,
      1.448210,
      0,
      1.886252,
      NULL,
      NULL,
      0.414575,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.917256,
      1.613847,
      3.110921,
      0.009641,
      0.292844,
      2,
      0,
      0.994741,
      2.229247,
      NULL,
      NULL,
      1.734391,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.742463,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.446711,
      NULL,
      NULL,
      2,
      0,
      3.291171,
      3,
      0.492567,
      1.578546,
      1,
      NULL,
      NULL,
      1.389238,
      NULL,
      0.036966,
      NULL,
      2.364094,
      NULL,
      0.141022,
      NULL,
      NULL,
      3,
      5,
      1,
      1.521374,
      NULL,
      NULL,
      1.264549,
      NULL,
      NULL,
      0.340137,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.357728,
      NULL,
      NULL,
      1.906224,
      0.020264,
      NULL,
      0,
      0.391488,
      0,
      2,
      3,
      1.246932,
      1,
      2,
      2.134612,
      1.420377,
      4,
      4,
      1,
      1,
      2,
      3,
      1.815720,
      NULL,
      0.437372,
      NULL,
      1.215385,
      5.206359,
      7,
      6,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3.129252,
      2,
      NULL,
      NULL,
      2,
      2,
      1,
      7,
      NULL,
      NULL,
      NULL,
      2.853701,
      0.028600,
      0.366965,
      NULL,
      NULL,
      1,
      0.798245,
      1,
      0,
      1.376787,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563340,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.049484,
      NULL,
      2.791781,
      NULL,
      0,
      2.104187,
      0,
      NULL,
      NULL,
      0.236547,
      NULL,
      NULL,
      0.586013,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      332.601283,
      8.324894,
      NULL,
      1.405426,
      1.424628,
      NULL,
      1.996206,
      1,
      1.060988,
      NULL,
      0.174440,
      1.631442,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.740775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.952650,
      3.138252,
      0.710034,
      3.034088,
      2,
      3,
      1.823274,
      0.014596,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0.795219,
      NULL,
      1.128459,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.075563,
      NULL,
      NULL,
      1.823644,
      3.210193,
      NULL,
      1.062790,
      2.478234,
      NULL,
      0,
      NULL,
      NULL,
      0.314113,
      1,
      NULL,
      NULL,
      0.355908,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663444,
      NULL,
      NULL,
      NULL,
      0.837936,
      NULL,
      NULL,
      5,
      7,
      3,
      NULL,
      2,
      47.932767,
      65.414472,
      1,
      3.192724,
      0,
      '44012',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


