set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8030435';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3323230',
      2.820065,
      0,
      NULL,
      3,
      '0302',
      3,
      1,
      NULL,
      NULL,
      ' 1- 1-1985',
      NULL,
      NULL,
      3.606929,
      1,
      0.252331,
      NULL,
      58.247396,
      1.589824,
      NULL,
      NULL,
      NULL,
      ' 0-21-1985',
      '10-17-1996',
      ' 7-22-1979',
      3,
      NULL,
      NULL,
      1.058611,
      NULL,
      1.411440,
      NULL,
      0.039472,
      1.539428,
      NULL,
      NULL,
      11.282550,
      6,
      5,
      NULL,
      0.927326,
      27.377993,
      5,
      0,
      6.668313,
      0,
      NULL,
      0,
      0.878368,
      1.988760,
      0.301601,
      1,
      1.345224,
      1.898631,
      2.781168,
      0.674813,
      3,
      0,
      2.844450,
      NULL,
      0,
      0.995016,
      1.648081,
      1.561954,
      1.896323,
      4,
      1,
      1.037119,
      1,
      1.833409,
      NULL,
      0.922677,
      1.282869,
      1,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.036549,
      0.305803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.040100,
      0,
      5.172903,
      1,
      4,
      0,
      1.186762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.380582,
      1,
      NULL,
      0,
      3.181813,
      NULL,
      0.212229,
      1,
      3.557529,
      0,
      0.039467,
      NULL,
      0,
      1.518024,
      1.469528,
      0.270447,
      NULL,
      1.077576,
      NULL,
      0.470718,
      1,
      5,
      5.005329,
      4,
      NULL,
      1.956668,
      2,
      0,
      4,
      NULL,
      1.678946,
      NULL,
      5,
      0,
      5,
      2,
      2,
      1,
      3,
      1,
      2.578969,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.509950,
      1.637588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151975,
      0.394457,
      0.219274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.208503,
      0.370963,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.740834,
      3.920590,
      1.854914,
      1,
      0.402711,
      0,
      1.326762,
      NULL,
      NULL,
      5.896488,
      NULL,
      0.244857,
      NULL,
      NULL,
      NULL,
      2,
      0.053273,
      1.975906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      20.191888,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      2,
      3.889585,
      1.501011,
      2,
      0,
      2,
      NULL,
      NULL,
      2.936087,
      2,
      0.371693,
      0.831860,
      0.377163,
      2.792370,
      NULL,
      1.694663,
      1,
      0,
      0,
      0,
      0.857253,
      1,
      1.632640,
      0.067248,
      NULL,
      0,
      NULL,
      1.764108,
      1,
      NULL,
      4.349674,
      6,
      11,
      1,
      1,
      3,
      6.906108,
      NULL,
      NULL,
      1,
      41,
      1,
      1,
      NULL,
      6,
      50,
      22,
      0,
      0,
      3,
      NULL,
      '14140',
      '',
      NULL,
      '',
      '',
      '',
      1.792471,
      '',
      '',
      '',
      NULL,
      26.062952,
      325,
      2.451179,
      3.402095,
      3,
      10.018087,
      14.518081,
      3.053649,
      3,
      1,
      NULL,
      0.835378,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.527700,
      2,
      1,
      0,
      1.986284,
      0,
      0,
      0.184939,
      NULL,
      NULL,
      1.363706,
      NULL,
      0.568895,
      1.408776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.572212,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2.652086,
      0.831215,
      0.937790,
      1.232989,
      1.400494,
      0,
      1,
      0,
      1.473179,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.774719,
      NULL,
      0,
      3,
      2.233067,
      0,
      NULL,
      0.264538,
      0,
      2,
      0,
      0.420534,
      0,
      NULL,
      NULL,
      NULL,
      3.821138,
      0.362072,
      0,
      NULL,
      1,
      0,
      NULL,
      0.678178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.635971,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0.900145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.882062,
      1.735552,
      0.171061,
      1.664766,
      0.264233,
      0,
      NULL,
      NULL,
      5,
      1.936886,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.876180,
      0,
      1.364248,
      0.462601,
      0.910123,
      1,
      5,
      1.845965,
      1.924657,
      NULL,
      1.797498,
      NULL,
      1.650419,
      NULL,
      NULL,
      3,
      1.712239,
      NULL,
      NULL,
      0.824218,
      3.862437,
      3.656922,
      1.960932,
      0,
      8,
      5.773441,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.508283,
      2.668454,
      0.002497,
      NULL,
      2.160590,
      2,
      8,
      3.336725,
      3.781560,
      6.116738,
      4.299522,
      1.936636,
      0.328190,
      NULL,
      2.399192,
      0.241344,
      0.984206,
      NULL,
      1.980537,
      1.227280,
      3.593426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.858451,
      NULL,
      NULL,
      1.483937,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.169484,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.819004,
      0,
      0.591175,
      1.385136,
      0,
      1,
      NULL,
      7,
      NULL,
      0,
      0.412934,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.172213,
      2.046715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.360127,
      NULL,
      2,
      0,
      0,
      NULL,
      3.648781,
      NULL,
      1,
      NULL,
      0,
      0.057664,
      0,
      NULL,
      1.284264,
      1,
      1,
      NULL,
      0.414287,
      0,
      0.023382,
      NULL,
      NULL,
      1.351228,
      0,
      NULL,
      1,
      0.220578,
      1,
      NULL,
      0,
      3.706694,
      2.388085,
      NULL,
      0,
      3.109361,
      2.764412,
      NULL,
      2,
      3.774745,
      2.945674,
      NULL,
      2,
      NULL,
      0.576125,
      NULL,
      0,
      12.611796,
      12.955157,
      NULL,
      2.651495,
      3.156259,
      NULL,
      2.650912,
      3,
      9,
      2,
      0,
      49.359613,
      3,
      2,
      179,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.709497,
      2,
      0,
      NULL,
      2.191197,
      NULL,
      NULL,
      NULL,
      0.633122,
      NULL,
      0.585917,
      324.087453,
      6.755292,
      3.259045,
      1.147840,
      3.068119,
      NULL,
      0,
      0.121053,
      1.823036,
      NULL,
      1.325200,
      0,
      3,
      1,
      0,
      1.666276,
      1,
      1,
      0.311681,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.331047,
      NULL,
      183,
      NULL,
      3,
      NULL,
      56,
      NULL,
      1.923058,
      0.864145,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.196273,
      NULL,
      0,
      NULL,
      1.964215,
      NULL,
      2,
      NULL,
      1.508266,
      NULL,
      0.018701,
      NULL,
      0,
      NULL,
      0.502865,
      NULL,
      0.406278,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.087956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.873092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790855,
      0.082758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683050,
      0.447567,
      1.021530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.206553,
      7.520661,
      NULL,
      5.270670,
      0,
      7,
      4.825318,
      0.698066,
      1.437086,
      NULL,
      3,
      2.223515,
      1.909495,
      1.801174,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      0,
      1.456991,
      2.659647,
      3,
      1.091690,
      0,
      0.230805,
      1.566106,
      2.386279,
      NULL,
      0.389374,
      NULL,
      0,
      0,
      1,
      1.097732,
      0,
      1,
      NULL,
      NULL,
      1.313856,
      0,
      1,
      2.071601,
      1.447520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1.652304,
      NULL,
      0,
      NULL,
      1.987926,
      NULL,
      1,
      NULL,
      1.654346,
      NULL,
      3.915289,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.744673,
      NULL,
      1,
      NULL,
      1.248567,
      NULL,
      1,
      35,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1.665312,
      1.523007,
      NULL,
      5.387146,
      NULL,
      0.589944,
      NULL,
      NULL,
      82.278829,
      9,
      3.832285,
      1.047880,
      2.594769,
      '22202',
      NULL,
      NULL,
      0.601904,
      '',
      '',
      NULL,
      1.638450,
      '',
      '',
      '');
commit;
end;
/


