set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '24',
      30.073545,
      21.934790,
      '0033032',
      NULL,
      0,
      0,
      NULL,
      '2220',
      NULL,
      0,
      NULL,
      NULL,
      '10-20-2003',
      26,
      NULL,
      NULL,
      1.986660,
      NULL,
      ' 0-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1984',
      NULL,
      ' 8-22-1993',
      NULL,
      2,
      1,
      0.759550,
      3.807459,
      2.214244,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.004247,
      NULL,
      3.029181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.874468,
      0.101304,
      0,
      NULL,
      0,
      1.148427,
      NULL,
      0,
      NULL,
      4,
      1,
      2.324504,
      NULL,
      3,
      0,
      7.349981,
      2,
      2.275823,
      0,
      0.454698,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.820972,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1.054434,
      1.049941,
      0.073230,
      1,
      0.481380,
      0,
      1,
      1.381748,
      1.228472,
      NULL,
      0.294630,
      2.920886,
      NULL,
      3,
      1,
      2.832727,
      3.921920,
      0.224608,
      1.939628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.496183,
      NULL,
      NULL,
      1.821045,
      NULL,
      6.712262,
      4,
      1.082999,
      1,
      1.378669,
      0,
      0,
      0.037179,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.451029,
      0,
      5,
      0.747730,
      0.670610,
      1,
      5,
      4.843185,
      2,
      0.380884,
      1.997185,
      1.703093,
      0.580436,
      7.153802,
      0.032772,
      5,
      0.110578,
      6.487762,
      NULL,
      4,
      NULL,
      8.294023,
      5.284440,
      2,
      0.386344,
      0.413769,
      0,
      2,
      ' 1- 8-1982',
      131,
      NULL,
      9,
      2,
      1.236798,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.669035,
      0.684098,
      1,
      2,
      0.609832,
      5,
      0.162498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.492422,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.158474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133672,
      0,
      2,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.346521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320196,
      1,
      1,
      0.650634,
      1.868693,
      0,
      2,
      27,
      NULL,
      1.912590,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.218887,
      2,
      1.039615,
      1.950586,
      3.353974,
      1.050267,
      1.247923,
      1.278063,
      1,
      1,
      3,
      NULL,
      1,
      1.538391,
      0.443537,
      NULL,
      1,
      1.655685,
      0.358228,
      1,
      1.316532,
      0.427719,
      0.179243,
      0,
      0,
      0.784254,
      3.469028,
      0,
      NULL,
      0.821843,
      2.329502,
      6.052485,
      NULL,
      3,
      3,
      1.090797,
      0,
      0,
      0,
      3,
      49.095101,
      0.596010,
      0,
      23,
      NULL,
      14.039518,
      21.094179,
      5.369004,
      NULL,
      NULL,
      '33143',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      2,
      27,
      9.465590,
      24.216820,
      0,
      NULL,
      0.682383,
      NULL,
      5.729724,
      0,
      1,
      2,
      0.266613,
      NULL,
      NULL,
      0,
      3,
      1.349230,
      0.639511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491554,
      NULL,
      NULL,
      NULL,
      NULL,
      3.155027,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333390,
      NULL,
      NULL,
      1.975883,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.505715,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.507086,
      2.238951,
      NULL,
      NULL,
      0.823574,
      0,
      0,
      1.900035,
      2.032551,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.747567,
      0,
      0,
      0.724395,
      3.897591,
      NULL,
      1.791786,
      2,
      1.135703,
      NULL,
      0.827545,
      3,
      1.598644,
      1,
      0,
      0,
      3,
      NULL,
      1.697405,
      NULL,
      3.628657,
      NULL,
      0.417216,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.132801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.968705,
      0.917258,
      NULL,
      NULL,
      3.364384,
      3,
      NULL,
      1.809647,
      NULL,
      NULL,
      1.088639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.314198,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.785124,
      1,
      NULL,
      NULL,
      5.729519,
      0,
      5.458343,
      2.014013,
      1.719238,
      NULL,
      1.217388,
      NULL,
      1.000093,
      1,
      NULL,
      NULL,
      3,
      3,
      1.625231,
      3,
      NULL,
      3.088966,
      NULL,
      7,
      1.674632,
      3.924441,
      3,
      NULL,
      1.934116,
      2,
      3.588755,
      0,
      NULL,
      NULL,
      1.809694,
      NULL,
      NULL,
      2.898801,
      NULL,
      5,
      0.366515,
      NULL,
      NULL,
      1.458778,
      NULL,
      NULL,
      1,
      1,
      0.628752,
      NULL,
      0.872963,
      1.097538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.940721,
      0.516630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567104,
      NULL,
      NULL,
      NULL,
      1.195641,
      11,
      1.196168,
      3,
      3.254710,
      1.790567,
      0.209791,
      NULL,
      NULL,
      0.957748,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.069982,
      NULL,
      0,
      124.136052,
      1.610134,
      0,
      3.939520,
      NULL,
      NULL,
      1.532508,
      1,
      NULL,
      0,
      1.652338,
      0.486444,
      NULL,
      3.439974,
      1.046608,
      0.550593,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.512536,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      18,
      NULL,
      NULL,
      34,
      28.809914,
      0,
      0.780584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.200506,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.144511,
      NULL,
      0.558990,
      NULL,
      0.655500,
      NULL,
      1.658133,
      NULL,
      1.905363,
      NULL,
      1.862278,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.596092,
      6.074225,
      0.852742,
      3.942875,
      3,
      0,
      NULL,
      NULL,
      1.941443,
      0,
      1.661155,
      0,
      NULL,
      NULL,
      3.304513,
      NULL,
      0.924347,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.347740,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.957729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342630,
      NULL,
      1.243333,
      NULL,
      0,
      NULL,
      NULL,
      5.172794,
      0.980338,
      1,
      NULL,
      NULL,
      26.312038,
      NULL,
      1,
      NULL,
      0,
      '42013',
      '22431',
      NULL,
      1.913710,
      NULL,
      '',
      NULL,
      1.551517,
      '',
      '',
      '');
commit;
end;
/


