set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2231101',
      1,
      0.161615,
      3,
      3,
      '1214',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      16.286247,
      NULL,
      NULL,
      1.807450,
      NULL,
      ' 3-26-1983',
      30,
      1.984301,
      298,
      46.874184,
      0,
      NULL,
      '10-24-1988',
      NULL,
      2,
      NULL,
      2.667617,
      1,
      0.470703,
      1.388821,
      NULL,
      1.179760,
      0.511510,
      11,
      NULL,
      0.030471,
      3.740138,
      20.570780,
      NULL,
      0.781181,
      11,
      NULL,
      0,
      2.535338,
      0.194347,
      2,
      0,
      0.577616,
      NULL,
      0,
      NULL,
      0,
      0.645766,
      1.107284,
      0,
      2.248599,
      5.412530,
      0.444018,
      NULL,
      1.191853,
      NULL,
      0.959660,
      1.942686,
      NULL,
      1.861075,
      NULL,
      1.473716,
      1,
      1.679525,
      0,
      0.781995,
      1.147591,
      1,
      0.981110,
      0,
      NULL,
      1.064027,
      NULL,
      NULL,
      1.966359,
      NULL,
      NULL,
      1.660359,
      1.526954,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888637,
      1.194342,
      NULL,
      1.972618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.697532,
      5,
      1,
      NULL,
      7.893596,
      5.504182,
      5.329450,
      0.496232,
      1,
      2,
      0.799127,
      1,
      1,
      4.144349,
      NULL,
      NULL,
      1.783660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639865,
      0.548310,
      0.556399,
      4.263081,
      5,
      NULL,
      5,
      5,
      NULL,
      NULL,
      0,
      0,
      NULL,
      9,
      NULL,
      3,
      NULL,
      9,
      0.564065,
      9,
      NULL,
      7.093336,
      7,
      NULL,
      NULL,
      1.266048,
      '11-23-1979',
      172,
      NULL,
      5.139469,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542591,
      NULL,
      3,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036703,
      0.640701,
      1.106018,
      0,
      0,
      1,
      3,
      3.868062,
      3.764234,
      0.358032,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352338,
      NULL,
      1.706752,
      0.422081,
      1,
      0.597393,
      0.779987,
      20.064489,
      0,
      0.949280,
      NULL,
      NULL,
      NULL,
      3.569567,
      1.659293,
      0,
      4.413988,
      5.724807,
      NULL,
      NULL,
      0.036523,
      NULL,
      NULL,
      1.456220,
      0.700198,
      3.877577,
      3.033813,
      1,
      0,
      0,
      1.190538,
      1,
      0.428043,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785590,
      0,
      0.517102,
      1,
      NULL,
      0,
      0,
      1.525495,
      NULL,
      10.188971,
      NULL,
      6,
      3.821079,
      5,
      NULL,
      2,
      1.613600,
      1,
      1.144562,
      2,
      18.242620,
      NULL,
      2,
      NULL,
      26,
      32.212515,
      26,
      0.987666,
      1.659462,
      2,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.523877,
      '',
      '',
      NULL,
      2.627631,
      27.464636,
      24.536989,
      1,
      1,
      NULL,
      NULL,
      1.102141,
      NULL,
      3,
      0.856382,
      3.410659,
      0,
      NULL,
      NULL,
      0.769889,
      NULL,
      NULL,
      0,
      0.584563,
      1.148483,
      1.331748,
      NULL,
      NULL,
      1.354311,
      NULL,
      NULL,
      0.362365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.238332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.977193,
      0,
      1.513542,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.104776,
      0.398313,
      2.149955,
      3.229877,
      0,
      2.474174,
      1.780243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170007,
      NULL,
      NULL,
      1,
      1.377874,
      1,
      NULL,
      NULL,
      1.782568,
      NULL,
      NULL,
      2.940041,
      3.649575,
      1.946839,
      NULL,
      1.414338,
      1,
      0,
      NULL,
      NULL,
      3.484142,
      1.727227,
      0.520846,
      1.521498,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.253612,
      NULL,
      NULL,
      1.478897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.249173,
      1,
      NULL,
      NULL,
      5,
      0.339952,
      1,
      NULL,
      NULL,
      3.558197,
      1,
      NULL,
      NULL,
      NULL,
      1.500497,
      1.857019,
      2.660544,
      0.355476,
      0,
      1.091412,
      1,
      1.479926,
      NULL,
      1.000021,
      0.025339,
      2.313941,
      3,
      0,
      2.728114,
      0.434089,
      1,
      1,
      0,
      NULL,
      1,
      1.038667,
      0.522066,
      3,
      3,
      NULL,
      0.631132,
      0.546875,
      0.441235,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315606,
      1,
      1.168895,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401864,
      NULL,
      NULL,
      1.374931,
      NULL,
      NULL,
      0.895871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.820884,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.515799,
      0.677193,
      1,
      0.815664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.305736,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.553404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.955748,
      0.938553,
      1,
      NULL,
      NULL,
      0.065513,
      0.018563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645310,
      NULL,
      NULL,
      1.574812,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.166214,
      1.232433,
      1,
      NULL,
      0.697637,
      1,
      1.284617,
      NULL,
      1,
      0,
      0.111447,
      1,
      0,
      1.875943,
      0.286726,
      0,
      1,
      0.438434,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.335353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815163,
      1.237689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735124,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914410,
      0.172076,
      NULL,
      0,
      NULL,
      1.950308,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.348971,
      NULL,
      1.129532,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925464,
      1.678594,
      NULL,
      1,
      2.513915,
      NULL,
      3.910378,
      0.707257,
      0.798793,
      0.289997,
      1.093651,
      NULL,
      1,
      0.185171,
      NULL,
      1,
      1.992747,
      NULL,
      1.048785,
      NULL,
      NULL,
      1.527909,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.168820,
      0,
      NULL,
      0,
      2.776639,
      NULL,
      3.918129,
      0.628643,
      NULL,
      NULL,
      3,
      NULL,
      0.664577,
      1,
      NULL,
      0,
      0.318509,
      NULL,
      3.739658,
      0.236871,
      1.037688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961409,
      NULL,
      0.216379,
      NULL,
      1,
      NULL,
      1,
      0.535931,
      NULL,
      1.232976,
      NULL,
      NULL,
      11.004718,
      87,
      5,
      0.218085,
      NULL,
      '01110',
      '',
      '',
      0,
      '',
      '',
      '',
      1.415306,
      '',
      '',
      '');
commit;
end;
/


