set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '0111233',
      2,
      1.206716,
      1,
      2,
      NULL,
      2.255307,
      1,
      NULL,
      NULL,
      '10-24-1982',
      12.292431,
      NULL,
      3,
      1.649889,
      3.319925,
      NULL,
      28.574058,
      NULL,
      104,
      37.180014,
      3,
      ' 1- 9-1986',
      ' 2- 9-1976',
      ' 4-13-1985',
      NULL,
      NULL,
      1.041616,
      2.582744,
      NULL,
      2.040057,
      0,
      1.312254,
      1.649287,
      6.883589,
      8.184668,
      14,
      0,
      3.125300,
      NULL,
      8,
      NULL,
      2,
      1.724859,
      0.335118,
      1,
      4.601507,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.434197,
      0.965246,
      NULL,
      3.199184,
      6,
      3.552520,
      6,
      0.382304,
      1.908327,
      1,
      1.641646,
      1,
      2,
      2.369442,
      1,
      3,
      0.240860,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.601702,
      NULL,
      NULL,
      NULL,
      1.884070,
      NULL,
      NULL,
      6,
      0.493052,
      6,
      3,
      1.636479,
      1,
      NULL,
      NULL,
      1,
      3.139683,
      1,
      1,
      NULL,
      0.789449,
      NULL,
      0.660675,
      1,
      1.494765,
      0.997641,
      NULL,
      1.012923,
      3.881383,
      9,
      NULL,
      0,
      1.502133,
      0.379046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.949198,
      4,
      2,
      0,
      6,
      0.113425,
      3.904158,
      1,
      1,
      0.967587,
      1.357201,
      2.156389,
      0,
      3.087958,
      1.867420,
      0.598100,
      NULL,
      1,
      0.460805,
      NULL,
      0.355783,
      3.672636,
      1,
      0,
      NULL,
      1.896068,
      4,
      2,
      0.711532,
      NULL,
      0.781219,
      0,
      1.709035,
      NULL,
      3.857567,
      1,
      4,
      0,
      2,
      NULL,
      NULL,
      NULL,
      7,
      7.248364,
      NULL,
      NULL,
      1,
      0,
      ' 6-29-1987',
      373,
      '10-14-2003',
      NULL,
      1.438567,
      1.294462,
      0.808031,
      3.511455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477383,
      NULL,
      NULL,
      1,
      1.457357,
      NULL,
      1.132915,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      1.448664,
      NULL,
      1,
      1.312499,
      0.351323,
      1,
      2.265184,
      2,
      0.675995,
      1.716445,
      0,
      0,
      3.509548,
      7.821400,
      0.950731,
      4,
      0.002749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.158471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638533,
      0,
      0.122663,
      1.724876,
      1,
      1,
      NULL,
      1,
      13,
      1.336691,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073666,
      0,
      3,
      2.972487,
      3,
      NULL,
      2,
      0.657803,
      1,
      0.624178,
      3,
      NULL,
      1,
      1.679502,
      2,
      2.005836,
      5,
      1.553971,
      0,
      5.974601,
      0.285839,
      NULL,
      0.106281,
      NULL,
      0,
      1.172910,
      1.751644,
      0.551321,
      0,
      0,
      NULL,
      1.257041,
      10.909912,
      7,
      5.560826,
      9.902614,
      NULL,
      NULL,
      0,
      1,
      3.835923,
      1,
      0,
      1,
      55.023541,
      0,
      NULL,
      NULL,
      35.770789,
      61,
      11,
      0,
      0,
      3,
      '33103',
      '',
      '',
      3.470180,
      NULL,
      '',
      '',
      1.338299,
      '',
      NULL,
      '',
      NULL,
      30,
      26.155596,
      NULL,
      NULL,
      19.848374,
      NULL,
      0,
      3,
      1.023416,
      NULL,
      NULL,
      0.006530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.197686,
      NULL,
      NULL,
      0.193872,
      NULL,
      NULL,
      0.499659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.259738,
      1,
      0,
      0.166151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.393001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.400050,
      2.528890,
      0,
      NULL,
      NULL,
      0.659977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.149079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.790431,
      5,
      NULL,
      1,
      0.190249,
      NULL,
      NULL,
      NULL,
      0.105070,
      1,
      1,
      3,
      0.032971,
      NULL,
      NULL,
      3,
      1.207949,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049800,
      NULL,
      NULL,
      1.617210,
      NULL,
      NULL,
      0.507924,
      NULL,
      NULL,
      3,
      NULL,
      0.305078,
      1.220590,
      NULL,
      NULL,
      4,
      4.050165,
      1,
      0.746240,
      5,
      3.558768,
      2.029820,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.548216,
      NULL,
      2,
      1,
      2.568060,
      0.586325,
      5.617256,
      5.122482,
      NULL,
      1,
      1,
      3.415397,
      3.202274,
      0.397675,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.244781,
      4,
      3.884576,
      NULL,
      NULL,
      NULL,
      0.039711,
      0.927947,
      1.834689,
      0.687996,
      1.277512,
      0.471803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.535168,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.591887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.829536,
      NULL,
      NULL,
      NULL,
      0.321945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.706439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      18.925029,
      0,
      1,
      57,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.549714,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.877906,
      NULL,
      0.629216,
      0,
      NULL,
      0,
      0.442741,
      1.844869,
      1.179295,
      0,
      NULL,
      1,
      0,
      1.518813,
      NULL,
      1.328497,
      0,
      1,
      0,
      1.049702,
      1,
      0,
      0.166689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.487333,
      0.886947,
      NULL,
      4,
      4.004262,
      2,
      3.353648,
      4.167801,
      2.330226,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.129080,
      NULL,
      1.166124,
      NULL,
      NULL,
      0.005800,
      2,
      NULL,
      1,
      1,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      1.908237,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.035731,
      NULL,
      2,
      1.975320,
      1.611060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.356359,
      3.948310,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.944665,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.508882,
      NULL,
      1.558759,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.535165,
      NULL,
      6,
      5.426769,
      NULL,
      1.001164,
      NULL,
      NULL,
      37.220063,
      10,
      4,
      2.630972,
      0.606975,
      '44214',
      '',
      NULL,
      0.039118,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


