set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2,
      1,
      NULL,
      3,
      0.665595,
      1,
      NULL,
      NULL,
      '00221132',
      48,
      53,
      '3403314',
      NULL,
      NULL,
      1,
      1,
      '2023',
      1,
      0,
      NULL,
      NULL,
      ' 6-15-2000',
      25,
      198,
      NULL,
      1,
      5.069922,
      '11- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      2.876663,
      '11-20-1975',
      NULL,
      ' 2-15-1978',
      NULL,
      3,
      0,
      1.436574,
      0.622354,
      0,
      3.345166,
      0.364028,
      NULL,
      NULL,
      NULL,
      1.073948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835063,
      6.811167,
      NULL,
      NULL,
      0,
      0,
      1,
      0.359384,
      1.577639,
      1.391048,
      3.269417,
      1.115574,
      0,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4.940784,
      1.278595,
      NULL,
      0.886485,
      0.970908,
      1.425201,
      NULL,
      1.302644,
      NULL,
      0.409519,
      NULL,
      1.501235,
      NULL,
      0.793712,
      3,
      2.849651,
      0,
      1.924039,
      NULL,
      NULL,
      0.146660,
      NULL,
      NULL,
      3,
      3,
      2.882397,
      3,
      0,
      1,
      NULL,
      0,
      0,
      0.006207,
      0.001629,
      1.195654,
      1,
      1,
      0.774832,
      0,
      NULL,
      0.215312,
      NULL,
      0.799316,
      1.402596,
      7,
      10,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.942355,
      1,
      4.522204,
      5.213135,
      4,
      3,
      0,
      5,
      0.301962,
      0,
      5.783909,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      3.899193,
      2.032634,
      NULL,
      0,
      8,
      5,
      3.271745,
      NULL,
      4,
      5.756368,
      4,
      NULL,
      0,
      7.225457,
      0.157164,
      2,
      4.475531,
      2,
      NULL,
      8,
      4,
      3,
      5.050649,
      1,
      6,
      1.468680,
      ' 5-10-1991',
      54.677995,
      ' 7- 0-2001',
      7,
      3.112350,
      0.015830,
      0.604893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704509,
      NULL,
      NULL,
      1.011803,
      0.359369,
      1.446970,
      0.739634,
      1.393661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831505,
      NULL,
      4.900006,
      3.712111,
      0,
      7.124537,
      1.921547,
      1.257794,
      1,
      1,
      NULL,
      NULL,
      1.487369,
      2,
      1,
      0.314197,
      NULL,
      1.157155,
      1,
      4.693859,
      2.448851,
      4.996673,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.071957,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754196,
      NULL,
      0.342340,
      NULL,
      1.713904,
      1,
      0,
      2.038960,
      NULL,
      2,
      1.762758,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.776835,
      1,
      0.788831,
      NULL,
      3.964828,
      2,
      3,
      1,
      NULL,
      0.992168,
      4,
      0.189349,
      1,
      2.149958,
      1.770723,
      1,
      1.178852,
      0.352238,
      1,
      1.618032,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      11,
      7,
      11,
      4.575422,
      5.190250,
      0.728916,
      1.268330,
      NULL,
      2.878920,
      0,
      1,
      0,
      3.413836,
      2.791721,
      42.079683,
      NULL,
      36.126374,
      15,
      NULL,
      3.585807,
      0,
      '04140',
      '43134',
      '12314',
      1.992682,
      '',
      '',
      '',
      0.298877,
      '',
      '',
      '',
      1.189744,
      22.465000,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314430,
      10.047306,
      12.022291,
      NULL,
      27,
      3.301866,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      227.029819,
      1.960510,
      NULL,
      0.805124,
      0,
      1,
      1.799012,
      0,
      1.113388,
      1,
      1,
      1,
      0.160783,
      1.513082,
      1.532649,
      0.052701,
      1,
      0.423517,
      1.791102,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851471,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920380,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.329553,
      1.006259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391098,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387793,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.705586,
      1,
      3,
      0.491346,
      0.560411,
      NULL,
      NULL,
      1,
      1.700079,
      1.708139,
      1.633456,
      1.597792,
      0.514232,
      NULL,
      0.876391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.465703,
      2,
      3,
      NULL,
      1,
      NULL,
      1,
      2,
      5,
      0.858327,
      0.532874,
      1.581540,
      0.655253,
      NULL,
      NULL,
      0.920963,
      0,
      NULL,
      1.217413,
      1.678469,
      NULL,
      0,
      1.836686,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.375197,
      NULL,
      NULL,
      1.412648,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      1.369752,
      1.858831,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.237246,
      0.214745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.082503,
      NULL,
      4,
      5.805713,
      0.390162,
      NULL,
      NULL,
      NULL,
      121,
      NULL,
      0,
      0,
      NULL,
      '23444',
      '41302',
      '20034',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


