set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3042111',
      2,
      1,
      3,
      0,
      NULL,
      0.710268,
      0.117920,
      NULL,
      NULL,
      NULL,
      29.105851,
      NULL,
      0,
      0.555898,
      NULL,
      ' 4-23-2000',
      26.920797,
      1.379220,
      308.280684,
      102,
      2,
      NULL,
      NULL,
      NULL,
      1.347564,
      0.422415,
      0.234003,
      2.358626,
      0.443097,
      0.930741,
      2,
      1,
      NULL,
      NULL,
      NULL,
      6.911411,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      2,
      3,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240505,
      0.535322,
      0,
      0,
      0,
      0.741640,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.432820,
      NULL,
      0.279463,
      1.340188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.566684,
      1.338840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893552,
      1.728212,
      0.234237,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305731,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      0.496112,
      0,
      1.023031,
      NULL,
      2,
      0,
      1,
      1.575973,
      0,
      0,
      NULL,
      0,
      1.391129,
      3.391748,
      0.594580,
      NULL,
      1.235029,
      0.148711,
      0.038592,
      0.711817,
      0.531620,
      5,
      0,
      1.627324,
      1,
      1,
      1.696290,
      1,
      NULL,
      NULL,
      NULL,
      1.526806,
      2,
      6,
      NULL,
      2.197688,
      1.135261,
      1.335501,
      1.548625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043094,
      3.422889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776641,
      1.618191,
      NULL,
      0.789097,
      8.144388,
      NULL,
      1.252242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      1.992971,
      0,
      NULL,
      1,
      NULL,
      0.838287,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2.530736,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.874649,
      0.383688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.252620,
      1,
      0,
      1,
      1,
      0.031901,
      15,
      1,
      1.106770,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.165051,
      2.388658,
      NULL,
      NULL,
      0,
      2.367557,
      1,
      0,
      3.108330,
      NULL,
      2,
      1.065239,
      0,
      2,
      NULL,
      0,
      0.630060,
      0,
      NULL,
      1.338171,
      NULL,
      0.026474,
      NULL,
      1,
      0.167730,
      NULL,
      1.290961,
      1,
      2.701819,
      1.086267,
      11.229888,
      NULL,
      1,
      5,
      NULL,
      NULL,
      3.434138,
      2,
      3,
      NULL,
      3,
      2,
      63,
      1.493965,
      2.015166,
      NULL,
      43.308063,
      59.737091,
      66,
      3,
      1.173378,
      1,
      '',
      '',
      '',
      NULL,
      '24332',
      '14414',
      '',
      0.796297,
      '',
      '',
      '',
      2,
      24.489430,
      NULL,
      25.699729,
      0.057580,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527392,
      NULL,
      NULL,
      1.405024,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928293,
      NULL,
      NULL,
      0.072714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.896570,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.292323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.611292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.241359,
      NULL,
      NULL,
      1.640721,
      NULL,
      NULL,
      1.380665,
      NULL,
      NULL,
      0.324423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.067057,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.782413,
      NULL,
      NULL,
      1.070982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.151433,
      0,
      3,
      1.021029,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.627119,
      4.936972,
      0.780307,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.200377,
      NULL,
      NULL,
      1.486569,
      2.692588,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      3,
      1,
      0.582978,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.371455,
      NULL,
      5,
      0.424528,
      4.346534,
      3.692374,
      1,
      NULL,
      NULL,
      0.093088,
      1,
      NULL,
      1.060328,
      1.672934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530428,
      1.973353,
      3.226473,
      NULL,
      1,
      1.270814,
      0.000651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.006819,
      NULL,
      1,
      NULL,
      NULL,
      1.768979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312577,
      NULL,
      NULL,
      1.709871,
      NULL,
      1,
      4.766502,
      1.760907,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.257061,
      1.666004,
      0,
      1,
      1.826328,
      0,
      1.818255,
      1,
      0.689817,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.936820,
      0.997753,
      1.337936,
      0,
      NULL,
      5.292826,
      1.400829,
      2,
      11.995985,
      0.945436,
      1.257476,
      0.869523,
      0,
      NULL,
      NULL,
      0.883490,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.836550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.394368,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.231035,
      1.799967,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070272,
      0,
      NULL,
      NULL,
      NULL,
      0.714805,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.041756,
      NULL,
      NULL,
      NULL,
      2.163437,
      NULL,
      0.622619,
      NULL,
      0.522849,
      NULL,
      1.802163,
      NULL,
      2,
      NULL,
      16,
      0.312055,
      NULL,
      0.876811,
      NULL,
      1,
      NULL,
      1.984255,
      NULL,
      0.093353,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      90,
      7.471463,
      NULL,
      1,
      1,
      '',
      '',
      '',
      3,
      '31343',
      '21331',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


