set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7112759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '4121234',
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      2.957140,
      1,
      10,
      ' 3-29-1978',
      64.115734,
      NULL,
      1,
      0,
      1,
      NULL,
      3,
      2.479473,
      41.475481,
      NULL,
      3.285786,
      ' 3-28-1980',
      ' 2-26-1982',
      NULL,
      0,
      0.567728,
      0,
      0.779513,
      0,
      2,
      NULL,
      0,
      0,
      39,
      NULL,
      14,
      0.031289,
      3.952499,
      NULL,
      5,
      14,
      5,
      NULL,
      4,
      0.897362,
      0,
      5.477393,
      3,
      0.251571,
      0.336397,
      1,
      NULL,
      0,
      1,
      NULL,
      5,
      3.301474,
      1.709828,
      NULL,
      4.302934,
      0.604454,
      1,
      NULL,
      1.242821,
      0,
      1.172643,
      1,
      0,
      0.996446,
      0,
      NULL,
      NULL,
      1,
      0,
      1.835188,
      1.163735,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726497,
      1,
      1.182466,
      0,
      0,
      2.588479,
      0,
      1.486456,
      NULL,
      NULL,
      1.559858,
      1.288186,
      3.903809,
      1.737120,
      NULL,
      1,
      0,
      0.702686,
      2,
      0.584133,
      3,
      NULL,
      1.476308,
      NULL,
      4.376084,
      3.540277,
      1,
      0.045384,
      1,
      NULL,
      NULL,
      1.291964,
      1,
      2,
      1,
      1.626457,
      1.802676,
      1.740167,
      NULL,
      0,
      1.309430,
      0.309235,
      1.320295,
      1.534073,
      0,
      1.864147,
      1.246332,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3.272694,
      NULL,
      1.703917,
      1,
      NULL,
      0.141447,
      1.606689,
      NULL,
      3.816050,
      0,
      NULL,
      3.157026,
      NULL,
      0.178419,
      3.998462,
      1.441488,
      4,
      0,
      NULL,
      0.242910,
      1.493891,
      1.908235,
      2.111947,
      3.515423,
      7.162044,
      3,
      ' 5-21-1976',
      23.288544,
      ' 2- 4-1990',
      NULL,
      1.495225,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.452927,
      0.819893,
      1,
      1.450185,
      1,
      0.259830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.978874,
      10,
      0.861370,
      1.207512,
      NULL,
      0,
      9.039264,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      2.546855,
      7,
      5,
      8.444488,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      2.713925,
      NULL,
      NULL,
      NULL,
      8.492030,
      ' 7-28-1978',
      14.242999,
      3,
      0,
      1.656998,
      2,
      NULL,
      NULL,
      NULL,
      0.937403,
      0.554002,
      1,
      3.859688,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.063550,
      0,
      3,
      1,
      2,
      0,
      3.953545,
      0,
      0.529828,
      0.780985,
      3.583046,
      0,
      0,
      NULL,
      0,
      0.397388,
      5.090625,
      1,
      1,
      NULL,
      NULL,
      1,
      0.329279,
      1,
      0.473853,
      0,
      1.530974,
      0.625525,
      1,
      NULL,
      NULL,
      6.504827,
      1.251870,
      6,
      0,
      3,
      1.200348,
      2.651106,
      3,
      0.063458,
      NULL,
      30,
      0.687038,
      2.839425,
      NULL,
      11.485523,
      NULL,
      NULL,
      3.248276,
      1.082593,
      3,
      '34444',
      '',
      NULL,
      1.556621,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      29.571789,
      NULL,
      18.087411,
      1,
      25.132025,
      0,
      NULL,
      1,
      0.908578,
      NULL,
      NULL,
      1.470005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.565003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215108,
      1,
      0.940122,
      NULL,
      NULL,
      0.590750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.967830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.630181,
      0.658167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.096383,
      NULL,
      5,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197525,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681199,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.781246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.908162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.037899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.597892,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.495991,
      1.389975,
      NULL,
      NULL,
      0,
      NULL,
      0.477931,
      1,
      NULL,
      1.926681,
      3.410317,
      2,
      0.091919,
      6,
      5.136258,
      1.167470,
      0.373553,
      3,
      1.065204,
      1,
      NULL,
      NULL,
      0.130412,
      NULL,
      NULL,
      NULL,
      0.241485,
      1,
      2,
      6.094956,
      1,
      5,
      0.880862,
      2.511822,
      0,
      NULL,
      NULL,
      0,
      0.654311,
      0.160952,
      0.571351,
      0,
      0.742136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.662835,
      2.009454,
      2,
      2.429932,
      1,
      0,
      1,
      0.264983,
      NULL,
      NULL,
      NULL,
      3.766485,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.481297,
      NULL,
      NULL,
      NULL,
      1.721856,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.052703,
      NULL,
      NULL,
      NULL,
      0.237284,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.260307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.929293,
      NULL,
      2.123611,
      NULL,
      2.603040,
      1,
      0,
      NULL,
      NULL,
      1.956580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.750070,
      14.378527,
      8.218924,
      1.841971,
      0,
      1.549555,
      0.170477,
      0.065613,
      1.535795,
      0.906177,
      1,
      0,
      0.965468,
      0.483765,
      0,
      1.712812,
      0.973709,
      1.562393,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.491601,
      NULL,
      10.678141,
      5,
      1.905155,
      1.613913,
      NULL,
      NULL,
      0.438801,
      NULL,
      3,
      1.980996,
      NULL,
      1,
      0.538213,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.492294,
      1,
      NULL,
      0,
      1.162685,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.025853,
      NULL,
      NULL,
      0.700963,
      1,
      0,
      1.339612,
      0,
      0.561431,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541636,
      1,
      1,
      1.742728,
      1,
      0.000744,
      5.658306,
      3,
      NULL,
      0,
      NULL,
      NULL,
      97,
      68.335904,
      2.994664,
      1.348811,
      0,
      NULL,
      '03334',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


