set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1321313',
      1,
      0.990371,
      NULL,
      NULL,
      '2111',
      NULL,
      1,
      NULL,
      NULL,
      ' 3-27-1992',
      NULL,
      NULL,
      2.218958,
      NULL,
      4,
      ' 8-21-1997',
      75.477831,
      5.157409,
      142,
      32.258011,
      3.403381,
      ' 9-25-1979',
      NULL,
      ' 8-21-1986',
      0,
      1,
      3.418161,
      NULL,
      NULL,
      0.898580,
      9,
      2.135755,
      NULL,
      NULL,
      NULL,
      8,
      7,
      38.901728,
      8.765971,
      NULL,
      3,
      4,
      NULL,
      4,
      0,
      0,
      0.975773,
      1.542102,
      1,
      0.935860,
      0.259201,
      1.971626,
      0,
      1,
      1,
      3,
      1,
      1,
      NULL,
      5.147309,
      0.336025,
      0.642540,
      0,
      0,
      1.513301,
      5.120965,
      0,
      1.045632,
      0,
      1,
      0,
      3,
      1.074842,
      5.851803,
      1.293156,
      NULL,
      1.829729,
      NULL,
      NULL,
      1.588336,
      NULL,
      NULL,
      1,
      1.015221,
      1.109959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.358867,
      0.408986,
      1.974927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591167,
      5,
      NULL,
      NULL,
      NULL,
      1,
      6.716117,
      0.743791,
      NULL,
      1.850942,
      3,
      NULL,
      1.543001,
      5.129891,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.738979,
      NULL,
      1.636217,
      3.696786,
      2,
      1.982129,
      0.007600,
      7.994798,
      NULL,
      0.468890,
      6.044557,
      2,
      1.832602,
      3.252347,
      5.525863,
      0,
      0.758709,
      4,
      0,
      0,
      4.797545,
      NULL,
      1.546715,
      7.864036,
      7.067967,
      0.804270,
      NULL,
      3,
      NULL,
      359.991471,
      ' 9- 9-1979',
      17,
      2,
      2,
      0,
      NULL,
      0.545470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.303785,
      5.853667,
      NULL,
      1,
      1.324758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.582490,
      NULL,
      6.930973,
      0,
      0,
      9,
      NULL,
      1,
      3.670746,
      NULL,
      NULL,
      5.200617,
      NULL,
      1.036763,
      1.536761,
      0.674462,
      3.489269,
      1.887048,
      2.963305,
      2,
      7,
      7.549205,
      NULL,
      1.255202,
      NULL,
      NULL,
      NULL,
      1,
      2.487040,
      0.120697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825358,
      0.135782,
      0.793260,
      2.121943,
      3.434100,
      0.285619,
      0,
      2.253329,
      22.167005,
      0,
      0.717891,
      NULL,
      NULL,
      NULL,
      2.400375,
      0,
      2.637110,
      3,
      1.256512,
      3,
      NULL,
      0.551999,
      3,
      3,
      3.666120,
      1.998485,
      2.170242,
      2,
      2,
      0.477348,
      9.758639,
      3.341122,
      1,
      NULL,
      0.927077,
      1.313554,
      0,
      1,
      1.531042,
      NULL,
      1,
      NULL,
      2.102750,
      1,
      3.628829,
      1,
      4,
      1,
      NULL,
      7.746829,
      NULL,
      4,
      1,
      NULL,
      6,
      2,
      2,
      0.300262,
      19.136655,
      3,
      2,
      NULL,
      74.936532,
      35,
      NULL,
      4.729492,
      1.734060,
      NULL,
      '44111',
      NULL,
      NULL,
      1.477119,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      11.595113,
      85,
      52,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.875902,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.715393,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.650020,
      NULL,
      NULL,
      0.980720,
      NULL,
      NULL,
      1.017661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.996511,
      NULL,
      0.714583,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.875739,
      1.015107,
      0,
      1,
      NULL,
      NULL,
      5,
      1,
      2.361177,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968091,
      NULL,
      NULL,
      0.179330,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.101868,
      3.621491,
      0.648495,
      3.425357,
      0.198150,
      7,
      3,
      NULL,
      4,
      2,
      2,
      0.027601,
      0,
      1.665104,
      0,
      1,
      NULL,
      2,
      3,
      2.880508,
      NULL,
      0,
      3,
      1.888780,
      0.350747,
      4,
      3,
      3,
      2,
      0.898021,
      0,
      NULL,
      3,
      1,
      2,
      1.372574,
      1.818674,
      0.256615,
      1.020841,
      5.167362,
      4,
      NULL,
      NULL,
      1.655722,
      3.417537,
      NULL,
      NULL,
      0,
      0.885513,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418131,
      NULL,
      NULL,
      0.661151,
      NULL,
      NULL,
      1.257710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788973,
      3,
      2,
      1,
      NULL,
      3.019184,
      NULL,
      NULL,
      NULL,
      3.362557,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      NULL,
      NULL,
      1.605044,
      NULL,
      NULL,
      NULL,
      3.412503,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.433120,
      NULL,
      NULL,
      NULL,
      3.538382,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.467483,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464706,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      15.005896,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.078943,
      0.534892,
      1,
      1.503283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038560,
      NULL,
      NULL,
      1,
      0.246701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      744.909322,
      0.721441,
      0,
      0.333283,
      NULL,
      1.135015,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.570472,
      0.736368,
      1.805952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.122931,
      NULL,
      0,
      9,
      1,
      1,
      1.502329,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.953347,
      NULL,
      0.628516,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.967585,
      1.194911,
      NULL,
      0.691914,
      1.219245,
      NULL,
      1,
      NULL,
      NULL,
      0.237272,
      0.186570,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.677358,
      0,
      NULL,
      1,
      0.561310,
      1.912581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541805,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      10.413490,
      3.557949,
      0.159759,
      1,
      NULL,
      46,
      5,
      1.244078,
      3,
      '34213',
      '',
      '',
      0.042644,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


