set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.333801,
      0.704320,
      NULL,
      NULL,
      1.483330,
      2.105251,
      2,
      0.219330,
      NULL,
      '22012241',
      NULL,
      NULL,
      '4202002',
      NULL,
      NULL,
      5,
      2,
      '2401',
      4,
      1.440363,
      NULL,
      NULL,
      ' 0- 7-1984',
      NULL,
      NULL,
      NULL,
      2,
      3,
      ' 9-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      4.376529,
      NULL,
      NULL,
      '11-23-1989',
      3.863786,
      1.882592,
      1.920234,
      3,
      1.917493,
      1.020528,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.698347,
      1,
      0,
      0,
      0,
      1,
      2.348452,
      NULL,
      5,
      0,
      5,
      0.316454,
      1,
      1.785034,
      1.318385,
      5,
      0.780039,
      NULL,
      NULL,
      3.477975,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.352185,
      0,
      NULL,
      4,
      1.843086,
      NULL,
      NULL,
      0.850994,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.161179,
      NULL,
      0.111820,
      0.919113,
      1,
      3.030479,
      NULL,
      0,
      1,
      0,
      0.050271,
      1.138715,
      0.266999,
      5,
      NULL,
      NULL,
      8,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591131,
      4.970673,
      4.172214,
      0,
      1.348988,
      7.766397,
      NULL,
      1,
      5.283004,
      0,
      0,
      0,
      1.898846,
      0,
      1,
      0.370922,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      4,
      9.072689,
      9.435619,
      NULL,
      8,
      8.244782,
      1,
      7,
      1,
      5,
      3,
      1.238964,
      0.956930,
      3,
      5.873770,
      4,
      4.846464,
      1,
      4,
      0,
      NULL,
      2,
      ' 1-18-1994',
      98,
      ' 2-29-1981',
      NULL,
      NULL,
      0,
      0,
      4.872969,
      1.755959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859161,
      0.934044,
      1,
      1.430287,
      1.590531,
      NULL,
      0.558025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.577494,
      NULL,
      3.640768,
      0.277101,
      0,
      9.267999,
      0.327042,
      0,
      2.539485,
      3,
      1.952085,
      0,
      0.932386,
      NULL,
      NULL,
      0,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.813307,
      0,
      NULL,
      0.116014,
      0,
      NULL,
      1,
      0,
      NULL,
      2.792051,
      0.308267,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.544606,
      1,
      0.697628,
      3,
      0,
      2,
      1.763740,
      NULL,
      2,
      2.558328,
      0,
      0.660831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.027526,
      NULL,
      0,
      0.960287,
      0,
      NULL,
      NULL,
      NULL,
      0.105597,
      5,
      NULL,
      3.041896,
      2,
      11.091725,
      1.290669,
      5,
      2.009378,
      4,
      NULL,
      3.103168,
      3.214867,
      6.916426,
      2.072184,
      0,
      55.182608,
      NULL,
      NULL,
      NULL,
      NULL,
      5.758712,
      NULL,
      '40142',
      '',
      '',
      0.055871,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      23,
      23.947327,
      17.584952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.593276,
      1,
      NULL,
      0.124286,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      1.554425,
      0.673179,
      3.357682,
      0.245665,
      0,
      1.184760,
      NULL,
      1,
      2.051491,
      NULL,
      1.556478,
      1.598307,
      1.230091,
      1.695168,
      1,
      2,
      0,
      3.354538,
      NULL,
      0.441750,
      0,
      NULL,
      0.006467,
      0,
      3.573058,
      0.125395,
      4.019564,
      NULL,
      1,
      NULL,
      0.199006,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.179428,
      0,
      NULL,
      1,
      NULL,
      0,
      1.649480,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      2.836984,
      0,
      0.355021,
      NULL,
      NULL,
      NULL,
      0.624022,
      NULL,
      0,
      0,
      1.835556,
      3,
      2.728195,
      1,
      0,
      NULL,
      NULL,
      1.734863,
      2,
      1.286909,
      4,
      10,
      1,
      1,
      1.198932,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.876923,
      NULL,
      NULL,
      1.213661,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.235135,
      1.253503,
      2,
      2.236715,
      1.781857,
      0.000706,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.614660,
      NULL,
      NULL,
      0.733401,
      0,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.149859,
      9,
      5.801001,
      NULL,
      NULL,
      NULL,
      1.167477,
      0,
      1,
      2.758487,
      1,
      2,
      1.436763,
      0.200331,
      3,
      8.001650,
      0.343392,
      5.797494,
      1.914619,
      0,
      1.900182,
      3,
      1.756904,
      1.137387,
      0.575695,
      NULL,
      1,
      2,
      2.859745,
      3,
      6,
      1,
      2.349001,
      5,
      6.195799,
      1,
      0,
      2.139385,
      2.747527,
      NULL,
      0.446546,
      0.271983,
      1,
      1.540109,
      0,
      NULL,
      NULL,
      0.214428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.801771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886994,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.200494,
      NULL,
      0,
      1.007185,
      2,
      NULL,
      NULL,
      NULL,
      0.540985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.274413,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.663265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.096688,
      NULL,
      NULL,
      NULL,
      3.139111,
      NULL,
      NULL,
      NULL,
      0.934611,
      NULL,
      NULL,
      NULL,
      0.204117,
      NULL,
      NULL,
      NULL,
      0.165898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977424,
      NULL,
      NULL,
      NULL,
      0.413796,
      1.410945,
      NULL,
      3,
      16,
      1.917419,
      1.393179,
      NULL,
      NULL,
      0.518761,
      11.798187,
      5,
      1.550953,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165542,
      NULL,
      8,
      0,
      1.066971,
      0.079944,
      1,
      NULL,
      NULL,
      1,
      1.149951,
      1,
      1.171345,
      NULL,
      0.618186,
      0,
      1,
      1.675860,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015518,
      0.811020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672705,
      1.474284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047960,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.079312,
      NULL,
      0.144216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829826,
      NULL,
      0,
      0,
      3.535451,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314430,
      0,
      0,
      0,
      0,
      NULL,
      1.038328,
      NULL,
      1.551551,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.744352,
      NULL,
      0,
      1,
      NULL,
      1.916750,
      3.643346,
      NULL,
      0.776964,
      1,
      NULL,
      1,
      1.755643,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.035364,
      NULL,
      NULL,
      0.634870,
      1.660333,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.484765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.686811,
      1.007000,
      3,
      0.418007,
      NULL,
      NULL,
      2.779590,
      163,
      4,
      3,
      7,
      NULL,
      '13443',
      '24214',
      0,
      '',
      '',
      '',
      0.015795,
      '',
      '',
      '');
commit;
end;
/


